PROGRAM Ein_Aus_Um;

USES CRT;

TYPE tPal = ARRAY[1..768] OF BYTE;

PROCEDURE GetPal(VAR Pal : tPal);
VAR i : WORD;
BEGIN
 PORT[$3c7] := 0;
 FOR i := 1 TO 768 DO
  Pal[i] := PORT[$3c9];
END;

PROCEDURE WaitVRetrace;
BEGIN
 WHILE PORT[$3da] AND 8 = 0 DO;
END;

PROCEDURE Einblenden(Pal : tPal);
VAR i : BYTE; j : WORD;
BEGIN
 PORT[$3c8] := 0;
 FOR i := 0 TO 63 DO BEGIN
  WaitVRetrace;
  FOR j := 1 TO 768 DO
   IF Pal[j] >= i THEN PORT[$3c9] := i ELSE PORT[$3c9] := Pal[j];
 END;
END;

PROCEDURE Ausblenden;
VAR Pal : tPal; i : BYTE; j : WORD;
BEGIN
 GetPal(Pal);
 PORT[$3c8] := 0;
 FOR i := 63 DOWNTO 0 DO BEGIN
  WaitVRetrace;
  FOR j := 1 TO 768 DO
   IF Pal[j] >= i THEN PORT[$3c9] := i ELSE PORT[$3c9] := Pal[j];
 END;
END;

PROCEDURE Umblenden(NeuPal : tPal);
VAR AltPal : tPal; i : BYTE; j : WORD;
BEGIN
 GetPal(AltPal);
 PORT[$3c8] := 0;
 FOR i := 0 TO 63 DO BEGIN
  WaitVRetrace;
  FOR j := 1 TO 768 DO BEGIN
   IF AltPal[j] > NeuPal[j] THEN Dec(AltPal[j])
    ELSE IF AltPal[j] < NeuPal[j] THEN Inc(AltPal[j]);
   PORT[$3c9] := AltPal[j];
  END;
 END;
END;

PROCEDURE LinienZiehen;
VAR i,j : WORD;
BEGIN
 FOR i := 0 TO 319 DO
  FOR j := 0 TO 199 DO MEM[$A000:j*320+i] := j;
END;

PROCEDURE Palette(VAR Pal : tPal; EinsZwei : BYTE);
VAR i : WORD;
BEGIN
 CASE EinsZwei OF
  1 : FOR i := 1 TO 768 DO IF i MOD 3 = 0 THEN Pal[i] := i MOD 64 ELSE Pal[i] := 0;
  2 : FOR i := 1 TO 768 DO IF i MOD 3 = 2 THEN Pal[i] := i MOD 64 ELSE Pal[i] := 0;
 END;
END;

VAR Pal : tPal;

BEGIN
 asm mov ax,0013h; int 10h; end; {Modus 13h setzen}
 LinienZiehen; {Farbige Linien mit Ur-Palette}
 Ausblenden; {Linien ausblenden}
 Palette(Pal,1); {Blaue Palette erstellen}
 Einblenden(Pal); {Linien mit blauer Palette einblenden}
 Palette(Pal,2); {Grne Palette erstellen}
 Umblenden(Pal); {Linien mit grner Palette umblenden}
 Ausblenden; {Linien ausblenden}
 asm mov ax,0003h; int 10h; end; {Wieder in den Textmodus}
END.