UNIT Tools;

INTERFACE

USES Crt;

 PROCEDURE Wri(x,y : BYTE; VG,HG : BYTE; Text : STRING);
 PROCEDURE Rahmen(x1, y1, x2, y2 : BYTE; VG,HG : BYTE);
 PROCEDURE HideCursor;
 PROCEDURE ShowCursor;
 PROCEDURE KeyBufClr;
 PROCEDURE Colors(VG,HG : BYTE);
 PROCEDURE WaitForKeyPressed(Key : CHAR);

IMPLEMENTATION

{Schreibt "Text" an Position x,y im Textmodus mit Farbe VG auf}
{Farbe HG}
PROCEDURE Wri(x,y : BYTE; VG,HG : BYTE; Text : STRING);
VAR OldTextAttr : BYTE;
BEGIN
 OldTextAttr := TextAttr;
 GotoXY(x,y);
 Colors(VG,HG);
 Write(Text);
 TextAttr := OldTextAttr;
END;

{Zeichnet einen Rahmen im Textmodus von Stelle x1,y1 bis zur}
{Stelle x2,y2 mit Farbe VG auf Farbe HG}
PROCEDURE Rahmen(x1, y1, x2, y2 : BYTE; VG,HG : BYTE);
VAR i, j, OldTextAttr : BYTE;
BEGIN
 OldTextAttr := TextAttr;
 Colors(VG,HG);
 Wri(x1,y1,VG,HG,#201);
 Wri(x1,y2,VG,HG,#200);
 Wri(x2,y1,VG,HG,#187);
 Wri(x2,y2,VG,HG,#188);
 FOR i := x1+1 TO x2-1 DO Wri(i,y1,VG,HG,#205);
 FOR i := x1+1 TO x2-1 DO Wri(i,y2,VG,HG,#205);
 FOR i := y1+1 TO y2-1 DO Wri(x1,i,VG,HG,#186);
 FOR i := y1+1 TO y2-1 DO Wri(x2,i,VG,HG,#186);
 FOR i := x1+1 TO x2-1 DO
  FOR j := y1+1 TO y2-1 DO
   Wri(i,j,VG,HG,' ');
 TextAttr := OldTextAttr;
END;

{Lt den ewig blinkenden Cursor verschwinden}
PROCEDURE HideCursor; Assembler;
ASM
 MOV AH,$01;
 MOV CH,$20;
 MOV CL,$20;
 INT $10;
END;

{Lt den verschwundenen Cursor wieder erscheinen}
PROCEDURE ShowCursor; Assembler;
ASM
 MOV ah,$01;
 MOV cx,$0607;
 INT $10;
END;

{Setzt Vordergrundfarbe VG und Hintergrundfarbe HG}
{VG und HG mssen als Zahlen bergeben werden}
PROCEDURE Colors(VG,HG : BYTE);
BEGIN
 TextColor(VG);
 TextBackGround(HG);
END;

{Lscht den Tastaturspeicher}
PROCEDURE KeyBufClr;
VAR Dummy : CHAR;
BEGIN
 REPEAT
  IF KeyPressed THEN Dummy := ReadKey;
 UNTIL KeyPressed = FALSE;
END;

{Wartet auf den mit "Key" bergebenen Buchstaben, bis dieser}
{gedrckt wird. "Key" mu entweder als Buchstabe in Hochkommas}
{oder als #<Zahl> nach der ASCII-Tabelle bergeben werden.}
PROCEDURE WaitForKeyPressed(Key : CHAR);
VAR Ok : BOOLEAN;
BEGIN
 KeyBufClr;
 Ok := FALSE;
 REPEAT
  IF KeyPressed THEN IF ReadKey = Key THEN Ok := TRUE;
 UNTIL Ok = TRUE;
END;

{Kein Initialisierungsteil => nur END.}
END.
