PROGRAM Plasma;

USES CRT;
VAR j : BYTE;

PROCEDURE SetMode(Modus : BYTE); ASSEMBLER;
ASM
 XOR AH,AH
 MOV AL,Modus
 INT 10h
END;

PROCEDURE NewCol(xl,yo,x,y,xr,yu : INTEGER);
VAR Col : INTEGER;
BEGIN
 IF MEM[$A000:y*320+x] = 0 THEN BEGIN
  Col := xr - xl + yu - yo;
  Col := Random(Col*3)-Col;
  Col := Col + (MEM[$A000:yo*320+xl]+MEM[$A000:yu*320+xr]) SHR 1;
  IF Col < 1 THEN Col := 1; IF Col > 189 THEN Col := 189;
  MEM[$A000:y*320+x] := Col;
 END;
END;

PROCEDURE SetRGB(Nr,r,g,b : BYTE);
BEGIN
 IF NR <> 0 THEN BEGIN
  PORT[$03C8] := Nr;
  PORT[$03C9] := r; PORT[$03C9] := g; PORT[$03C9] := b;
 END;
END;

PROCEDURE SetPal(j : BYTE);
VAR i : BYTE;
BEGIN
 FOR i := 1 TO 63 DO BEGIN
  SetRGB(i+j,0,63-i,i);
  SetRGB(i+63+j,i,0,63-i);
  SetRGB(i+126+j,63-i,i,0);
 END;
END;

PROCEDURE SubDivide(x1,y1,x2,y2 : WORD);
VAR Col : INTEGER;
    x,y : WORD;
BEGIN
 IF x2-x1 > 1 THEN BEGIN
  x := (x1+x2) SHR 1; y := (y1+y2) SHR 1;

  NewCol(x1,y1,x,y1,x2,y1);
  NewCol(x2,y1,x2,y,x2,y2);
  NewCol(x1,y2,x,y2,x2,y2);
  NewCol(x1,y1,x1,y,x1,y2);

  Col := (MEM[$A000:y1*320+x] + MEM[$A000:y*320+x2] +
          MEM[$A000:y2*320+x] + MEM[$A000:y*320+x1]) SHR 2;
  MEM[$A000:y*320+x] := Col;
  {WHILE NOT KeyPressed DO;
  IF ReadKey = #0 THEN;}

  SubDivide(x1,y1,x,y);
  SubDivide(x,y,x2,y2);
  SubDivide(x1,y,x,y2);
  SubDivide(x,y1,x2,y);

 END;
END;

BEGIN
 Randomize;
 SetMode($13);
 j := 0; SetPal(j); Inc(j);
 SubDivide(0,0,319,199);
 WHILE NOT KeyPressed DO BEGIN
  SetPal(j); Inc(j); Delay(10);
 END;
 SetMode($03);
END.