#ifndef __COMMON

#define __COMMON

#include "MAVLTree.h"
#include "SM_DemoScript.h"

struct GUILoadedEffect;


struct GUICommand
{
                GUICommand    ();
                ~GUICommand   ();

  int           Init          (SM_DemoScript::TCommand* pCommand, int iTick);
  int           Shutdown      ();

  SM_DemoScript::TCommand*    m_pCommand;
  int                         m_iTick;
};

struct GUICommandOrder
{
  bool operator<(const GUICommandOrder& opB) const;

  GUICommand*   m_pCommand;  
};


struct GUILoadedEffect
{
  GUILoadedEffect                            ();
  ~GUILoadedEffect                           ();
  int             Init                       (SM_DemoEffect* pDemoEffect, const char* pcLoadArguments);
  int             Shutdown                   ();
  
  SM_DemoEffect*  DemoEffect                 ();
  const char*     LoadArguments              ();
  int             SetArguments               (const char* pcArguments);
  int             First                      ();
  int             Last                       ();
  int             Next                       (int iIterator);
  int             Previous                   (int iIterator);
  int             Get                        (int iIterator, GUICommand*& pCommand);
  int             Insert                     (GUICommand* pCommand);
  int             Delete                     (int iID, bool bDeleteCommand = false);
  bool            IsTickInActiveRange        (int iTick);
  int             GetEndCommand              (int iStartCommand);
  int             GetStartCommand            (int iEndCommand);
  bool            CanMoveWithoutIntersection (int iCommand, int iToTick);
  void            SetActive                  (bool bActive);
  bool            GetActive                  ();


#ifdef _DEBUG
  void            TestIntegrity              ();
  void            Dump                       ();
#endif

protected:
  
  bool                                       m_bActive;
  SM_DemoEffect*                             m_pDemoEffect;
  char*                                      m_pcLoadArguments;
  MBStaticList<GUICommand*>                  m_Commands;
};


GUILoadedEffect* FindGUIEffect(MBStaticList<GUILoadedEffect*>* pslEntryList, SM_DemoEffect* pEffect);

#endif