#ifndef __MPIXELFORMATDESCRIPTOR

#define __MPIXELFORMATDESCRIPTOR

// Descriptor de formato de pixel
// Acepta hasta 32 Bits de color con R, G, B y Alpha, 
// Soporta paletizados y grises...

// Las mascaras de paletizados se representan con los log2(N) bits a 1, donde N es el numero de entradas de la paleta


struct MPixelFormatDescriptor
{
			    void		SetFrom							 (unsigned uBPP, unsigned uRMask, unsigned uGMask, unsigned uBMask, unsigned uAMask);
			    int		  operator==					 (MPixelFormatDescriptor& pfPixelFormatDescriptor);
			    void		GetFromMask          (unsigned int& uiShiftLeft, unsigned int& uiShiftRight, unsigned uiMask);

			    void		ConvertARGBToARGB32  (unsigned* puARGB32Destiny  , void* puLocalSource , unsigned uPixels);
			    void		ConvertARGBFromARGB32(void* puLocalDestiny	, unsigned* puARGB32Source, unsigned uPixels);


	unsigned int		m_uBPP;							    // Bits por pixel

	unsigned int		m_uRMask;						    // Mascara de rojo
	unsigned int		m_uGMask;						    // Mascara de verde
	unsigned int		m_uBMask;						    // Mascara de azul
	unsigned int		m_uAMask;						    // Mascara de Alpha
	
	unsigned int		m_uRShiftLeft;					// Shift izquierdo (posicion del bit menos significativo)
	unsigned int		m_uGShiftLeft;					// 
	unsigned int		m_uBShiftLeft;					// 
	unsigned int		m_uAShiftLeft;					// 

	unsigned int		m_uRShiftRight;					// Shift derecho para a partir de 8 bits convertir al valido
	unsigned int		m_uGShiftRight;					// 
	unsigned int		m_uBShiftRight;					// 
	unsigned int		m_uAShiftRight;					// 
};

enum eCommonPixelFormats
{
	E__PALET__256,
	E__RGB16__555,
	E__RGB16__565,
	E_ARGB16__444,
	E__RGB24__888,
  E__BGR24__888,
	E_ARGB32_8888,
	E__RGB32__888,
	E__BGR32__888,
  E_ARGB16__1555,
	E_NCOMMON
};

extern MPixelFormatDescriptor CommonPixelDescriptors[E_NCOMMON];


#endif
