#ifndef __SMVIEWPORT

#define __SMVIEWPORT

#include "SM_Vector3D.h"
#include "SM_Matrix4x4.h"
#include "SM_Quaternion.h"



struct Viewport
{
       Viewport();
       Viewport(const    Vector3D&   v3dPosition, 
                const    Quaternion& qRotation,
                float    fFOV,
                float    fAspectRatio,
                float    fZNear,
                float    fZFar);

  void Set    (const    Vector3D&   v3dPosition, 
              const    Quaternion& qRotation,
              float    fFOV,
              float    fAspectRatio,
              float    fZNear,
              float    fZFar);

  void  Set    (const    Vector3D&   v3dPosition, 
                const    Vector3D&   v3dTarget,
                const    Vector3D&   v3dUp,
                float    fFOV,
                float    fAspectRatio,
                float    fZNear,
                float    fZFar);

  void InverseViewMatrix    (Matrix4X4& m) const;
  void ViewMatrix           (Matrix4X4& m) const;
  void ProjectionMatrix     (Matrix4X4& m) const;
  

  Vector3D      m_v3dPosition;
  Quaternion    m_qRotation;
  float         m_fFOV;
  float         m_fAspectRatio;
  float         m_fZNear;
  float         m_fZFar;  
  
};


#endif
