#ifndef __SM_HELPERS

#define __SM_HELPERS

struct Matrix3X3;
struct Matrix4X4;
struct Quaternion;
struct Vector3D;


Matrix3X3* ToTransform          (Matrix3X3* pDest, const Quaternion* q);
Matrix4X4* ToTransform          (Matrix4X4* pDest, const Vector3D* v, const Quaternion* q);
Matrix4X4* ToTransform          (Matrix4X4* pDest, const Vector3D* v, const Quaternion* q, float fScale);
Matrix4X4* ToInverseTransform   (Matrix4X4* pDest, const Vector3D* v, const Quaternion* q);
void       GenerateFrustumPlanes(Matrix4X4* pView, const Matrix4X4* pProjection, Plane* pPlanes);

void GetFrame(Vector3D& v3dVPN, Vector3D& v3dUp, Vector3D& v3dRight);


#endif
