#ifndef _SM_COLOR
#define _SM_COLOR

struct Color
{
	Color() {};
	Color(const float* pf) 
	{
		r=pf[0]; g=pf[1]; b=pf[2]; a=pf[3];
	}

	Color(float _r, float _g, float _b, float _a)
		: r(_r)
		, g(_g)
		, b(_b)
		, a(_a)
	{
	}

	Color(DWORD dw)
	{
		a = ((dw >> 24) & 0xff)/255.0f;
		r = ((dw >> 16) & 0xff)/255.0f;
		g = ((dw >>  8) & 0xff)/255.0f;
		b = ( dw        & 0xff)/255.0f;		
	}

	// casting
	operator float* ()
	{
		return (&r);
	}
	operator const float* () const
	{
		return (&r);
	}
	operator DWORD() const
	{
		return (((DWORD)(a*255.f)&0xff)<<24) | 
			   (((DWORD)(r*255.f)&0xff)<<16) | 
			   (((DWORD)(g*255.f)&0xff)<<8) | 
			   ((DWORD)(b*255.f)&0xff);
	}

	// assignment operators
	Color& operator += ( const Color& v)
	{
		r += v.r;
		g += v.r;
		b += v.b;
		a += v.a;
		return *this;
	}

	Color& operator -= ( const Color& v)
	{
		r -= v.r;
		g -= v.r;
		b -= v.b;
		a -= v.a;
		return *this;
	}

	Color& operator *= (const float f)
	{
		r *= f;
		g *= f;
		b *= f;
		a *= f;
		return *this;
	}

	Color& operator /= (const float f)
	{
		const float of = 1.0f / f;
		r *= of;
		g *=of;
		b *=of;
		a *=of;
		return *this;
	}

	// unarg operators
  Color operator + () const
	{
		Color v(r,g,b,a);
		return (v);
	}

	Color operator - () const
	{
		Color v(-r,-g,-b,-a);
		return (v);
	}
  
	// binarg operators
	Color operator+( const Color& v) const
	{
		return Color (r+v.r,g+v.g,b+v.b,a+v.a);
	}

	Color operator-( const Color& v) const
	{
		
		return (Color(r-v.r,g-v.g,b-v.b,a-v.a));
	}

	Color operator*(const float f) const
	{
		Color v(r*f,g*f,b*f,a*f);
		return (v);
	}

	Color operator/(const float f) const
	{
		const float of = 1.0f / f;
		Color v(r*of, g*of, b*of, a*of);
		return (v);
	}

  friend Color operator * ( float f, const Color& v)
	{
		Color r(v.r*f,v.g*f,v.b*f,v.a*f);
		return (r);
	}
  
	bool operator == ( const Color& v) const
	{
		return (r==v.r && g==v.g && b==v.b && a==v.a);
	}

	bool operator != ( const Color& v) const
	{
		return (r!=v.r || g!=v.g || b!=v.b || a!=v.a);
	}

	static float Dot(const Color& vA, const Color& vB)
	{
		return (vA.r*vB.r+vA.g*vB.g+vA.b*vB.b+vA.a*vB.a);
	}

	float r,g,b,a;	
};

#endif