// Magic Software, Inc.
// http://www.magic-software.com
// Copyright (c) 2000, All Rights Reserved
//
// Source code from Magic Software is supplied under the terms of a license
// agreement and may not be copied or disclosed except in accordance with the
// terms of that agreement.  The various license agreements may be found at
// the Magic Software web site.  This file is subject to the license
//
// FREE SOURCE CODE
// http://www.magic-software.com/License/free.pdf

#ifndef MGCNATURALSPLINE3_H
#define MGCNATURALSPLINE3_H

#include "MgcMultipleCurve3.h"


class MgcNaturalSpline3 : public MgcMultipleCurve3
{
public:
    enum BoundaryType
    {
        BT_FREE,
        BT_CLAMPED,
        BT_CLOSED
    };

    MgcNaturalSpline3 (BoundaryType eType, int iSegments, float* afTime,
        Vector3D* akPoint);

    virtual ~MgcNaturalSpline3 ();

    const Vector3D* GetPoints () const;

    virtual Vector3D GetPosition (float fTime) const;
    virtual Vector3D GetFirstDerivative (float fTime) const;
    virtual Vector3D GetSecondDerivative (float fTime) const;
    virtual Vector3D GetThirdDerivative (float fTime) const;

protected:
    void CreateFreeSpline ();
    void CreateClampedSpline ();
    void CreateClosedSpline ();

    virtual float GetSpeed (int iKey, float fTime) const;
    virtual float GetLength (int iKey, float fDT0, float fDT1) const;
    virtual float GetVariation (int iKey, float fT0, float fT1,
        const Vector3D& rkA, const Vector3D& rkB) const;

    Vector3D* m_akA;
    Vector3D* m_akB;
    Vector3D* m_akC;
    Vector3D* m_akD;
};

#include "MgcNaturalSpline3.inl"

#endif
