#include "SM_GuiToolkitPch.h"
#include "SM_EventSuscriber.h"
#include "SM_EventListener.h"

EventSuscriber::EventSuscriber  ()
{
}

EventSuscriber::~EventSuscriber ()
{
  Shutdown();
}

int   EventSuscriber::Init            ()
{
  return m_Listeners.Init();
}

int   EventSuscriber::Shutdown        ()
{
  return m_Listeners.Shutdown();
}

int   EventSuscriber::AddListener(EventListener* pEventListener)
{
  if (m_Listeners.InsertTail(pEventListener) != -1)
  {
    return 0;
  }
  else
  {
    return -1;
  }
}

int   EventSuscriber::RemoveListener(EventListener* pEventListener)
{
  // TODO
  int             iIterator;
  EventListener* pStoredEventListener;

  for (iIterator = m_Listeners.First() ; iIterator != -1 ; iIterator = m_Listeners.Next(iIterator))
  {
    m_Listeners.Get(iIterator, pStoredEventListener);

    if (pEventListener == pStoredEventListener)
    {
      m_Listeners.Delete(iIterator);
      return 0;
    }
  }

  return -1;
}

void  EventSuscriber::PostEvent(Event* pEvent)
{
  int iIterator;
  EventListener* pStoredEventListener;

  for (iIterator = m_Listeners.First() ; iIterator != -1 ; iIterator = m_Listeners.Next(iIterator))
  {
    m_Listeners.Get(iIterator, pStoredEventListener);
    pStoredEventListener->ProcessEvent(pEvent);
  }
}