#include "SM_Renderable.h"


#define ROWSFFT       76
#define COLUMNSFFT    76
#define MAXTRISFFT    20000
#define ROWSFFTPERDP  (min(ROWSFFT, MAXTRISFFT/(COLUMNSFFT*2)))
#define NVERTICESFFT  ((ROWSFFT+1)*(COLUMNSFFT+1)) 
#define NPRIMITIVESFFT (COLUMNSFFT*ROWSFFT*2)


class SM_FFTBall : public IRenderable
{
public:
      SM_FFTBall          ();
      ~SM_FFTBall         ();

  int  Reset              ();
  int  Init               (int iShader, IKFAnimable* pAnimable);
  int  Shutdown           ();
  void Render             (RenderContext* pRenderContext, int iOutcode, float fTime); 

  
  Vector3D                m_v3dPosition;
  Quaternion              m_qRotation;
protected:
  int                     m_iShader;    
  IKFAnimable*            m_pAnimable;

  static bool             m_bIndices;
  static bool             m_bGeometries;
  static Vector3D         m_v3dPositions[NVERTICESFFT];
  static Vector3D         m_v3dNormals[NVERTICESFFT];  
  static Vector3D         m_v3dSource[NVERTICESFFT];
};
