#pragma once

class FXParamParser
{
public:

	FXParamParser() : m_str(0) {}
	~FXParamParser() { delete[] m_str; }

	void		Parse(const char* str);
	
	const char* GetStr(const char* var, const char* def);
	int			GetInt(const char* var, int def);
	float		GetFloat(const char* var, float def);
	bool		GetBool(const char* var, bool def);

protected:

	struct ltstr
	{
		bool operator()(const char* s1, const char* s2) const
		{
			return stricmp(s1, s2) < 0;
		}
	};

	typedef std::map<const char*, const char*, ltstr> StrStrMap;
	StrStrMap m_map;
	char* m_str;
};