#include "SM_CommonFXPCH.h"
#include "FXParamParser.h"

//-----------------------------------------------------------------------------
// Name: Parse
// Desc: 
//-----------------------------------------------------------------------------
void FXParamParser::Parse(const char* str)
{
	m_map.clear();

	const int len = strlen(str);
	m_str = new char[len+1];
	strcpy(m_str, str);

	int n=0;

	while (n < len)
	{
		// skip whitespace
		while (n < len && m_str[n] == ' ' || m_str[n] == '\t') m_str[n++] = 0;

		// read in var name
		if (n >= len) break;
		const char* pvar = &m_str[n];
		while (n < len && 
			   m_str[n] != ' ' && 
			   m_str[n] != '\t' && 
			   m_str[n] != '=') n++;

		// skip whitespace
		while (n < len && m_str[n] == ' ' || m_str[n] == '\t' || m_str[n] == '=') m_str[n++] = 0;

		// read in value
		if (n >= len) break;
		const char* pval = &m_str[n];
		while (n < len && 
			   m_str[n] != ' ' && 
			   m_str[n] != '\t') n++;
		if (n < len)
			m_str[n++] = 0;

		if (strlen(pvar) && strlen(pval))
			m_map[pvar] = pval;
	}
}


//-----------------------------------------------------------------------------
// Name: GetStr
// Desc: 
//-----------------------------------------------------------------------------
const char* FXParamParser::GetStr(const char* var, const char* def)
{
	StrStrMap::const_iterator it = m_map.find(var);
	return it != m_map.end() ? it->second : def;
}


//-----------------------------------------------------------------------------
// Name: GetInt
// Desc: 
//-----------------------------------------------------------------------------
int FXParamParser::GetInt(const char* var, int def)
{
	StrStrMap::const_iterator it = m_map.find(var);
	return it != m_map.end() ? atoi(it->second) : def;
}

//-----------------------------------------------------------------------------
// Name: GetFloat
// Desc: 
//-----------------------------------------------------------------------------
float FXParamParser::GetFloat(const char* var, float def)
{
	StrStrMap::const_iterator it = m_map.find(var);
	return it != m_map.end() ? atof(it->second) : def;
}

//-----------------------------------------------------------------------------
// Name: GetBool
// Desc: 
//-----------------------------------------------------------------------------
bool FXParamParser::GetBool(const char* var, bool def)
{
	StrStrMap::const_iterator it = m_map.find(var);
	return it != m_map.end() ? atof(it->second) != 0.0f : def;
}
