#pragma once
#define ASSERT assert

//-----------------------------------------------------------------------------
// FXMesh class
//-----------------------------------------------------------------------------
class FXMesh
{
	IDirect3DVertexBuffer8* m_vb;
	IDirect3DIndexBuffer8* m_ib;
	int	m_vertSize;
	DWORD m_fvf;
	int m_numverts, m_numindices;
	
	byte* m_pVerts;
	int m_nVerts;
	WORD* m_pIndices;
	int m_nIndices;

	D3DPRIMITIVETYPE m_pt;
	bool m_static;
public:

	FXMesh() : m_vb(0), m_ib(0), m_pVerts(0), m_pIndices(0), 
			 m_pt(D3DPT_TRIANGLELIST) {}
	~FXMesh() { Destroy(); }
	
	bool Init(int vertSize, DWORD fvf, bool bstatic);
	int AddVert(void* pv);
	void AddIndex(WORD ind);
	void ReserveVerts(int n);
	void ResizeVerts(int n);
	void ResetIndices();
	
	D3DPRIMITIVETYPE& PrimType() { return m_pt; }
	
	void LockVerts(bool resetNumVerts=true);
	void UnlockVerts();
	
	WORD GetIndex(int n) { ASSERT(m_pIndices && n < m_numindices); return m_pIndices[n]; }
	void* GetVert(int n) { ASSERT(m_pVerts && n < m_numverts); return &m_pVerts[n*m_vertSize]; }

	int NumIndices() const { return m_numindices; }
	int NumVerts() const { return m_numverts; }

	void Optimize(bool keepIndices=false);
	
	void Render();
	void Destroy();

	void TriStripIndices(int w, int h);
	void GenNormals(int w, int h, bool fixSeam);

	IDirect3DVertexBuffer8* GetVB() { return m_vb; }
};


