#ifndef __SM_RESOURCEMANAGER

#define __SM_RESOURCEMANAGER

#include "SM_D3d.h"

struct MSurface;

namespace ResourceManager 
{
  int Init                                   ();
  int Shutdown                               ();

  
  // Texture
  int                       CreateDepthTexture(unsigned uWidth, unsigned uHeight, D3DFORMAT Format);
  int                       CreateRenderTexture     (unsigned uWidth, unsigned uHeight, D3DFORMAT Format);
  int                       CreateTextureFromSurface(MSurface* pSurface, D3DFORMAT Format);
  int                       ReleaseTexture          (int iID);
  IDirect3DTexture8*        GetTextureFromID        (int iID);    
  IDirect3DSurface8*        GetSurfaceFromID        (int iID);

  // Vertex Buffer
  int                       CreateVertexBuffer        (UINT Length, DWORD Usage, DWORD FVF, D3DPOOL Pool);
  int                       ReleaseVertexBuffer       (int iID);
  IDirect3DVertexBuffer8*   GetVertexBufferFromID     (int iID);

  int                       CreateDynamicVertexBuffer (UINT Length, DWORD FVF);
  int                       GiveVBChunk                 (int iID, unsigned uLength, void** ppData);
  int                       DoneVBChunk                 (int iID);

  int                       CreateDynamicIndexBuffer (UINT Length, DWORD FVF);
  int                       GiveIBChunk                 (int iID, unsigned uLength, void** ppData);
  int                       DoneIBChunk                 (int iID);

  
  

  // Index Buffer
  int                       CreateIndexBuffer         (UINT Length, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool);
  int                       ReleaseIndexBuffer        (int iID);
  IDirect3DIndexBuffer8*    GetIndexBufferFromID      (int iID);

  int                       GetVertexStreamSize      ();
  int                       GetIndexStreamSize       ();

  extern int                m_iPosNormalDiffuseTex1Stream;
  extern int                m_iIndexStream;

};


#endif
