#include "SM_Engine3DPCH.h"


#define VERTEXSTREAMSIZE  20000
#define INDEXSTREAMSIZE   65536
namespace ResourceManager 
{

MSurface* LockD3DTexture(MSurface* pSurface, IDirect3DSurface8* pD3DSurface, unsigned uLevel);
MSurface* UnlockD3DTexture(MSurface* pSurface, IDirect3DSurface8* pD3DSurface, unsigned uLevel);

int m_iPosNormalDiffuseTex1Stream=-1;
int m_iIndexStream=-1;

struct ResourceTexture
{
  IDirect3DTexture8* pTexture;
  IDirect3DSurface8* pSurface;
};

struct ResourceVB
{
  IDirect3DVertexBuffer8* pVertexBuffer;
  unsigned                uLength;
  unsigned                uOffset;
};

struct ResourceIB
{
  IDirect3DIndexBuffer8* pIndexBuffer;
  unsigned                uLength;
  unsigned                uOffset;
};

MBStaticList<ResourceTexture> g_slTextureList;
MBStaticList<ResourceVB>      g_slVBList;
MBStaticList<ResourceIB>      g_slIBList;

int                           m_iMaxWidth;
int                           m_iMaxHeight;


MSurface* LockD3DTexture(MSurface* pSurface, IDirect3DSurface8* pD3DSurface, unsigned uLevel)
{
  D3DSURFACE_DESC Desc;
  D3DLOCKED_RECT  Locked;

  if (FAILED(pD3DSurface->GetDesc(&Desc)))
  {
    return (0);
  }


  if (FAILED(pD3DSurface->LockRect(&Locked, NULL, 0)))
  {
    return (0);
  }
     
  MPixelFormatDescriptor PixelFormat;
  switch (Desc.Format)
  {
  case D3DFMT_R8G8B8:
    PixelFormat=CommonPixelDescriptors[E__RGB24__888];
    break;
  case D3DFMT_A8R8G8B8:
    PixelFormat=CommonPixelDescriptors[E_ARGB32_8888];
    break;
  case D3DFMT_X8R8G8B8:
    PixelFormat=CommonPixelDescriptors[E__RGB32__888];
    break;
  case D3DFMT_R5G6B5:
    PixelFormat=CommonPixelDescriptors[E__RGB16__565];
    break;
  case D3DFMT_X1R5G5B5:
    PixelFormat=CommonPixelDescriptors[E__RGB16__555];
    break;
  case D3DFMT_A1R5G5B5:
    PixelFormat=CommonPixelDescriptors[E_ARGB16__1555];
    break;    
  case D3DFMT_A4R4G4B4:
    PixelFormat=CommonPixelDescriptors[E_ARGB16__444];
    break;    
  default:
    assert(!"Not supported yet");
    return (0);
  }

  MSurfaceDescriptor sd;
  sd.m_pfPixelFormat=PixelFormat;
  sd.m_uiByteStride =Locked.Pitch;
  sd.m_uiWidth      =Desc.Width;
  sd.m_uiHeight     =Desc.Height;


  if (pSurface->Init(sd, Locked.pBits, 0)!=0)
  {
    pD3DSurface->UnlockRect();
    return (0);
  }

  return (pSurface);
}

MSurface* UnlockD3DTexture(MSurface* pSurface, IDirect3DSurface8* pD3DSurface, unsigned uLevel)
{
  pD3DSurface->UnlockRect();
  return (pSurface);
}


int ResourceManager::Init()
{
  g_slTextureList.Init();
  g_slIBList.Init();
  g_slVBList.Init();

  D3DCAPS8 Caps;
  if (FAILED(SM_D3d::Device()->GetDeviceCaps(&Caps)))
  {
    return -1;
  }

  m_iMaxWidth =Caps.MaxTextureWidth;
  m_iMaxHeight=Caps.MaxTextureHeight;


  assert(m_iPosNormalDiffuseTex1Stream==-1);
  m_iPosNormalDiffuseTex1Stream = CreateDynamicVertexBuffer (VERTEXSTREAMSIZE*sizeof(FVF_PosNormalDiffuseTex1), FVF_POSNORMALDIFFUSETEX1);

  assert(m_iIndexStream==-1);
  m_iIndexStream= CreateDynamicIndexBuffer (INDEXSTREAMSIZE*sizeof(unsigned short), D3DFMT_INDEX16);

  return (0);
}

int ResourceManager::Shutdown()
{
  if (m_iIndexStream!=-1)
  {
    ReleaseIndexBuffer(m_iIndexStream);
    m_iIndexStream=-1;
  }

  if (m_iPosNormalDiffuseTex1Stream!=-1)
  {
    ReleaseVertexBuffer(m_iPosNormalDiffuseTex1Stream);
    m_iPosNormalDiffuseTex1Stream=-1;
  }
  
  assert(g_slTextureList.GetNumberElements()==0);
  g_slTextureList.Shutdown();

  assert(g_slVBList.GetNumberElements()==0);
  g_slVBList.Shutdown();

  assert(g_slIBList.GetNumberElements()==0);
  g_slIBList.Shutdown();

   


  return (0);
}

int ResourceManager::CreateDepthTexture(unsigned uWidth, unsigned uHeight, D3DFORMAT Format)
{
  IDirect3DSurface8* pVideoTexture =0;

  D3DFORMAT ZFormat;
  
  if (SUCCEEDED(SM_D3d::D3D()->CheckDeviceFormat(
      SM_D3d::GetCurrentMode()->uDevice,
      D3DDEVTYPE_HAL,
      SM_D3d::GetCurrentMode()->d3dFormat,
      D3DUSAGE_DEPTHSTENCIL ,
      D3DRTYPE_SURFACE,
      D3DFMT_D16_LOCKABLE)) &&
    
      SUCCEEDED(SM_D3d::D3D()->CheckDepthStencilMatch(
                  SM_D3d::GetCurrentMode()->uDevice,
                  D3DDEVTYPE_HAL,
                  SM_D3d::GetCurrentMode()->d3dFormat,
                  Format,
                  D3DFMT_D16_LOCKABLE)))
  {
    ZFormat=D3DFMT_D16_LOCKABLE;
  }
  else       
  if (SUCCEEDED(SM_D3d::D3D()->CheckDeviceFormat(
      SM_D3d::GetCurrentMode()->uDevice,
      D3DDEVTYPE_HAL,
      SM_D3d::GetCurrentMode()->d3dFormat,
      D3DUSAGE_DEPTHSTENCIL ,
      D3DRTYPE_SURFACE,
      D3DFMT_D16)) &&
    
      SUCCEEDED(SM_D3d::D3D()->CheckDepthStencilMatch(
                  SM_D3d::GetCurrentMode()->uDevice,
                  D3DDEVTYPE_HAL,
                  SM_D3d::GetCurrentMode()->d3dFormat,
                  Format,
                  D3DFMT_D16)))
  {
    ZFormat=D3DFMT_D16;
  }
  else
  if (SUCCEEDED(SM_D3d::D3D()->CheckDeviceFormat(
      SM_D3d::GetCurrentMode()->uDevice,
      D3DDEVTYPE_HAL,
      SM_D3d::GetCurrentMode()->d3dFormat,
      D3DUSAGE_DEPTHSTENCIL ,
      D3DRTYPE_SURFACE,
      D3DFMT_D32)) &&
    
      SUCCEEDED(SM_D3d::D3D()->CheckDepthStencilMatch(
                  SM_D3d::GetCurrentMode()->uDevice,
                  D3DDEVTYPE_HAL,
                  SM_D3d::GetCurrentMode()->d3dFormat,
                  Format,
                  D3DFMT_D32)))
  {
    ZFormat=D3DFMT_D32;
  }
  else
  {
    return false;
  }

  if (FAILED(SM_D3d::Device()->CreateDepthStencilSurface(uWidth, uHeight, ZFormat, D3DMULTISAMPLE_NONE, &pVideoTexture)))
  {
    goto FAIL;
  }

  ResourceTexture rTexture;

  rTexture.pSurface=pVideoTexture;;
  rTexture.pTexture=0;

  int iID;
  if ((iID=g_slTextureList.InsertTail(rTexture))==-1)
  {
    goto FAIL;
  }
  

  return (iID);

FAIL:
  if (pVideoTexture)        pVideoTexture->Release();
  
  return (-1);
}

int ResourceManager::CreateRenderTexture(unsigned uWidth, unsigned uHeight, D3DFORMAT Format)
{
  IDirect3DTexture8* pVideoTexture =0;
  
  if (FAILED(SM_D3d::Device()->CreateTexture(uWidth, uHeight, 0, D3DUSAGE_RENDERTARGET , Format, D3DPOOL_DEFAULT, &pVideoTexture)))
  {
    goto FAIL;
  }

  ResourceTexture rTexture;

  rTexture.pSurface=0;
  rTexture.pTexture=pVideoTexture;;

  int iID;
  if ((iID=g_slTextureList.InsertTail(rTexture))==-1)
  {
    goto FAIL;
  }
  

  return (iID);

FAIL:
  if (pVideoTexture)        pVideoTexture->Release();
  
  return (-1);
}

int ResourceManager::CreateTextureFromSurface(MSurface* pSurface, D3DFORMAT Format)
{    
  unsigned uWidth =pSurface->GetPSurfaceDescriptor()->m_uiWidth;
  unsigned uHeight=pSurface->GetPSurfaceDescriptor()->m_uiHeight;
  unsigned i=0;
  unsigned uLevels=0;
  MSurface* pMips=0;

  MSurface DeviceSize;
  if (uWidth>m_iMaxWidth || uHeight>m_iMaxHeight)
  {
    if (uWidth >m_iMaxWidth) uWidth=m_iMaxWidth;
    if (uHeight>m_iMaxHeight)uWidth=m_iMaxHeight;

    MSurfaceDescriptor sd;
    sd=pSurface->GetSurfaceDescriptor();

    sd.m_uiWidth =uWidth ;
    sd.m_uiHeight=uHeight;
    
    DeviceSize.Init(sd,0,0);

    DeviceSize.ScaleAndConvertFrom(*pSurface);
    
    pSurface=&DeviceSize;
  }

  if (((uWidth-1)&uWidth) ||  ((uHeight-1)&uHeight) )
  {
    SM_Main::OutputError("Texturas potencia de 2 por favor!");
  }


  IDirect3DTexture8* pSystemTexture=0;
  IDirect3DTexture8* pVideoTexture =0;
  IDirect3DSurface8* pSystemTextureLevel=0;
  IDirect3DSurface8* pVideoTextureLevel=0;

  if (FAILED(SM_D3d::Device()->CreateTexture(uWidth, uHeight, 0, 0, Format, D3DPOOL_SYSTEMMEM, &pSystemTexture)))
  {
    goto FAIL;
  }

  if (FAILED(SM_D3d::Device()->CreateTexture(uWidth, uHeight, 0, 0, Format, D3DPOOL_MANAGED , &pVideoTexture)))
  {
    goto FAIL;
  }

  // Fill textures with data
  uLevels=pSystemTexture->GetLevelCount();

  
  pMips=new MSurface[uLevels];

  for (i=0 ; i<uLevels ; i++)
  {
    if (FAILED(pSystemTexture->GetSurfaceLevel(i, &pSystemTextureLevel)))
    {
      goto FAIL;
    }

    if (FAILED(pVideoTexture->GetSurfaceLevel(i, &pVideoTextureLevel)))
    {
      goto FAIL;
    }
  
    // Lock Resource
    if (!LockD3DTexture(&pMips[i], pSystemTextureLevel, i))
    {
      goto FAIL;
    }

    pSystemTextureLevel->Release();
    pVideoTextureLevel->Release();
  }

  pSurface->GenerateMipMapChain(pMips, uLevels);
  /*for (i=0 ; i<uLevels ; i++)
  {
    pMips[i].ScaleAndConvertFrom(*pSurface);
  }*/


  for (i=0 ; i<uLevels ; i++)
  {
    if (FAILED(pSystemTexture->GetSurfaceLevel(i, &pSystemTextureLevel)))
    {
      goto FAIL;
    }

    if (FAILED(pVideoTexture->GetSurfaceLevel(i, &pVideoTextureLevel)))
    {
      goto FAIL;
    }

    UnlockD3DTexture(&pMips[i], pSystemTextureLevel, i);
        
    if (FAILED(SM_D3d::Device()->CopyRects(pSystemTextureLevel, NULL, 0, pVideoTextureLevel, 0)))
    {
      goto FAIL;
    }        
    
    pSystemTextureLevel->Release();
    pVideoTextureLevel->Release();
  }

  delete[] pMips;
  pMips=0;
  /*
  for (i=0 ; i<uLevels ; i++)
  {
    MSurface       Masquerade;
            

    if (FAILED(pSystemTexture->GetSurfaceLevel(i, &pSystemTextureLevel)))
    { 
      goto FAIL;
    }

    if (FAILED(pVideoTexture->GetSurfaceLevel(i, &pVideoTextureLevel)))
    {
      goto FAIL;
    }
  
    // Lock Resource
    if (!LockD3DTexture(&Masquerade, pSystemTextureLevel, i))
    {
      goto FAIL;
    }
    
    // Convert texture
    Masquerade.ScaleAndConvertFrom(*pSurface);

    // Unlock resource
    UnlockD3DTexture(pSurface, pSystemTextureLevel, i);
        
    if (FAILED(SM_D3d::Device()->CopyRects(pSystemTextureLevel, NULL, 0, pVideoTextureLevel, 0)))
    {
      goto FAIL;
    }    

    // Free References
    pSystemTextureLevel->Release()     ; pSystemTextureLevel=0;
    pVideoTextureLevel->Release()      ; pVideoTextureLevel=0;    
  }
  */

      
  assert(pSystemTexture);
  pSystemTexture->Release();
  pSystemTexture=0;

  ResourceTexture rTexture;

  rTexture.pTexture=pVideoTexture;;
  rTexture.pSurface=0;

  int iID;
  if ((iID=g_slTextureList.InsertTail(rTexture))==-1)
  {
    goto FAIL;
  }
  

  return (iID);

FAIL:
  if (pSystemTexture)       pSystemTexture->Release();
  if (pVideoTexture)        pVideoTexture->Release();
  if (pSystemTextureLevel)  pSystemTextureLevel->Release();
  if (pVideoTextureLevel)   pVideoTextureLevel->Release();

  return (-1);
}

IDirect3DTexture8* GetTextureFromID(int iID)
{
  ResourceTexture* pResource;

  if (g_slTextureList.Get(iID, pResource))
  {
    return (0);
  }
  else
  {
    return (pResource->pTexture);
  }  
}

IDirect3DSurface8* GetSurfaceFromID(int iID)
{
  ResourceTexture* pResource;

  if (g_slTextureList.Get(iID, pResource))
  {
    return (0);
  }
  else
  {
    return (pResource->pSurface);
  }  
}


int ReleaseTexture(int iID)
{
  IDirect3DTexture8* pTexture;
  IDirect3DSurface8* pSurface;

  pTexture=GetTextureFromID(iID);
  if (pTexture)
  {
    assert(pTexture);
    pTexture->Release(); pTexture=0;

    g_slTextureList.Delete(iID);
  }
  else
  {
    pSurface=GetSurfaceFromID(iID);
    assert(pSurface);
    pSurface->Release(); pSurface=0;    
  }

  g_slTextureList.Delete(iID);
  
  
  return (0);
}

int                     CreateVertexBuffer      (UINT Length, DWORD Usage, DWORD FVF, D3DPOOL Pool)
{
  ResourceVB VB;
  
  if (FAILED(SM_D3d::Device()->CreateVertexBuffer(Length, D3DUSAGE_WRITEONLY| Usage, FVF, Pool, &VB.pVertexBuffer)))
  {
    return (-1);
  }

  int iID;
  if ((iID=g_slVBList.InsertTail(VB))==-1)
  {
    VB.pVertexBuffer->Release();
    return (-1);
  }

  VB.uLength = Length;
  VB.uOffset = 0;
  
  return (iID);
}

int CreateDynamicVertexBuffer (UINT Length, DWORD FVF)
{
  ResourceVB VB;

  if (FAILED(SM_D3d::Device()->CreateVertexBuffer(
        Length, 
        D3DUSAGE_WRITEONLY| D3DUSAGE_DYNAMIC, 
        FVF, 
        D3DPOOL_DEFAULT, 
        &VB.pVertexBuffer)))
  {
    return (-1);
  }

  VB.uLength = Length;
  VB.uOffset = 0;


  int iID;
  if ((iID=g_slVBList.InsertTail(VB))==-1)
  {
    VB.pVertexBuffer->Release();
    return (-1);
  }
  return (iID);
}


int CreateDynamicIndexBuffer (UINT Length, DWORD FVF)
{
  ResourceIB IB;

  if (FAILED(SM_D3d::Device()->CreateIndexBuffer(
        Length, 
        D3DUSAGE_WRITEONLY| D3DUSAGE_DYNAMIC, 
        D3DFMT_INDEX16 , 
        D3DPOOL_DEFAULT, 
        &IB.pIndexBuffer)))
  {
    return (-1);
  }

  IB.uLength = Length;
  IB.uOffset = 0;


  int iID;
  if ((iID=g_slIBList.InsertTail(IB))==-1)
  {
    IB.pIndexBuffer->Release();
    return (-1);
  }

  

  return (iID);
}


int GiveIBChunk(int iID, unsigned uLength, void** ppData)
{
  ResourceIB* pResource;

  if (g_slIBList.Get(iID, pResource))
  {
    assert(!"Wrong ID");
    return (-1);
  }

  if (uLength > pResource->uLength)
  {
    assert(!"Requested more bytes than dynamic IB can hold");
    return (-1);
  }

  unsigned uFlags;
  if (pResource->uOffset+uLength > pResource->uLength)
  {
    pResource->uOffset = 0;
    uFlags  = D3DLOCK_DISCARD;        
  }
  else
  {
    uFlags = D3DLOCK_NOOVERWRITE;    
  }

  if (FAILED(pResource->pIndexBuffer->Lock(pResource->uOffset, uLength, (unsigned char**) ppData, uFlags)))
  {
    return (-1);
  }

  int iReturn=pResource->uOffset;

  pResource->uOffset+=uLength;
  
  return (iReturn);
}

int                     DoneIBChunk                 (int iID)
{
  ResourceIB* pResource;

  if (g_slIBList.Get(iID, pResource))
  {
    assert(!"Wrong ID");
    return (-1);
  }

  return (FAILED(pResource->pIndexBuffer->Unlock())?-1:0);
}



int GiveVBChunk(int iID, unsigned uLength, void** ppData)
{
  ResourceVB* pResource;

  if (g_slVBList.Get(iID, pResource))
  {
    assert(!"Wrong ID");
    return (-1);
  }

  if (uLength > pResource->uLength)
  {
    SM_Main::OutputError("en VB dinamico no caben %i bytes. Probablemente el objeto tenga demasiados poligonos");
    assert(!"Requested more bytes than dynamic vb can hold");
    return (-1);
  }

  unsigned uFlags;
  if (pResource->uOffset+uLength > pResource->uLength)
  {
    pResource->uOffset = 0;
    uFlags  = D3DLOCK_DISCARD;        
  }
  else
  {
    uFlags = D3DLOCK_NOOVERWRITE;    
  }

  if (FAILED(pResource->pVertexBuffer->Lock(pResource->uOffset, uLength, (unsigned char**) ppData, uFlags)))
  {
    return (-1);
  }

  int iReturn=pResource->uOffset;

  pResource->uOffset+=uLength;
  
  return (iReturn);
}

int                     DoneVBChunk                 (int iID)
{
  ResourceVB* pResource;

  if (g_slVBList.Get(iID, pResource))
  {
    assert(!"Wrong ID");
    return (-1);
  }

  return (FAILED(pResource->pVertexBuffer->Unlock())?-1:0);
}
  

int                     ReleaseVertexBuffer     (int iID)
{
  IDirect3DVertexBuffer8* pVB=GetVertexBufferFromID(iID);

  assert(pVB);
  pVB->Release(); pVB=0;

  g_slVBList.Delete(iID);

  return (0);
}


IDirect3DVertexBuffer8* GetVertexBufferFromID   (int iID)
{
  ResourceVB* pResource;

  if (g_slVBList.Get(iID, pResource))
  {
    return (0);
  }
  else
  {
    return (pResource->pVertexBuffer);
  }  
}

// Index Buffer
int                     CreateIndexBuffer      (UINT Length, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool)
{
  ResourceIB IB;
  
  if (FAILED(SM_D3d::Device()->CreateIndexBuffer(Length, Usage, Format, D3DPOOL_MANAGED, &IB.pIndexBuffer)))
  {
    return (-1);
  }

  int iID;
  if ((iID=g_slIBList.InsertTail(IB))==-1)
  {
    IB.pIndexBuffer->Release();
    return (-1);
  }

  return (iID);
}

int                     ReleaseIndexBuffer     (int iID)
{
  IDirect3DIndexBuffer8* pIB=GetIndexBufferFromID(iID);

  assert(pIB);
  pIB->Release(); pIB=0;

  g_slIBList.Delete(iID);

  return (0);
}

IDirect3DIndexBuffer8* GetIndexBufferFromID   (int iID)
{
  ResourceIB* pResource;

  if (g_slIBList.Get(iID, pResource))
  {
    return (0);
  }
  else
  {
    return (pResource->pIndexBuffer);
  }  
}

int GetVertexStreamSize()
{
  return (VERTEXSTREAMSIZE);
}

int GetIndexStreamSize()
{
  return (INDEXSTREAMSIZE);
}



}
