#include "SM_DemoScriptPCH.h"
#include "SM_DemoEffect.h"


SM_DemoEffect* EffectInstances=0;

namespace SM_DEData
{
  CVideoBuffer  VideoBuffer;  
}

SM_DemoEffect::SM_DemoEffect(char const* pcName)
{

  m_iLayer=0;

  // Linkamos a lista
  m_pNextEffect=EffectInstances;    
  EffectInstances=this;

  // asignamos nombre
  m_pcInstanceName=pcName;
  m_pParent=0;
}

SM_DemoEffect::~SM_DemoEffect()
{
  Shutdown();
}

int SM_DemoEffect::Init()
{
  return (0);
}

int SM_DemoEffect::Shutdown()
{
  return (0);
}

int SM_DemoEffect::Start(float fTime)
{
  return (0);
}

int SM_DemoEffect::Stop()
{
  return (0);
}

int SM_DemoEffect::Run(float fTime)
{

  return (1);
}

void SM_DemoEffect::RunPreStartFrame  (float fTime)
{
}

void SM_DemoEffect::RunPreRender      (float fTime)
{
}

void SM_DemoEffect::RunPostRender     (float fTime)
{
}

void SM_DemoEffect::RunPostEndFrame   (float fTime)
{
} 

void SM_DemoEffect::RunPreLayer(int iLayer, float fTime)
{
}

void SM_DemoEffect::RunPostLayer(int iLayer, float fTime)
{
}
  
void SM_DemoEffect::SetLayer(int iLayer)
{
    m_iLayer=iLayer;
}

int SM_DemoEffect::Command(float fTime, const char* pcCommand)
{
  char* pcCopy=new char[strlen(pcCommand)+1];
  strcpy(pcCopy, pcCommand);

  char* pcToken=strtok(pcCopy, " \t");

  if (strcmp(pcToken, "LAYER")==0)
  {

    pcToken=strtok(0, " \t");

    SetLayer(atoi(pcToken));
    
    if (m_iLayer<0 || m_iLayer>=MAX_LAYERS)
    {
      assert(!"Invalid layer. Must be between 0 and 7");
    }
  }
   
  delete[] pcCopy; pcCopy=0;

  return (0);
}

int SM_DemoEffect::SetParent(SM_DemoEffect* pDemoEffect)
{
  m_pParent=pDemoEffect;
  return 0;
}

SM_DemoEffect* GetEffect(const char* pcName)
{
  SM_DemoEffect* pEffect;

  for (pEffect=EffectInstances ; pEffect ; pEffect=pEffect->m_pNextEffect)
  {
    if (strcmp(pEffect->m_pcInstanceName, pcName)==0)
    {
      return (pEffect);
    }
  }

  return (0);
}


int SM_DemoEffect::m_iRandCount=0;

void* SM_DEData::CVideoBuffer::GetSurfacePointer()
{
  return (m_pVideo);
}

void* SM_DEData::CVideoBuffer::GetSurfacePointer(unsigned x, unsigned y)
{
  return ((void*)((char*)m_pVideo+
			x*(m_uBPP>>3)+
			y*(m_uByteStride)));
}



SM_DEData::CVideoBuffer VideoBuffer;
