/******************************

	Editor Utils
	code: pK

	Cosas utilies para el editor

 ******************************/

// Esto almacena info sobre el objeto selecionado en la lista de selecion
// tuve que hacer esta mierda cuando puse las camaras en la misma lista que los objetos...
// De esta forma, segun el index de la selecion, venimos aqui y savemos que es lo que esta selecionado ;)
#define EDITOR_TYPE_OBJECT				0	// Tipos de objetos de la lista de seleccin
#define EDITOR_TYPE_CAMERA_POSITION		1	// Las camaras tienen dos objetos (posicion i objetivo)
#define EDITOR_TYPE_CAMERA_TARGET		2
typedef struct
{

	int type;		// tipo de objeto
	int index;		// indice en su array correspondiente

} tEditorSelectionInfo;

tEditorSelectionInfo *EditorSelectionInfo=NULL;

// Aade un item a la lista de selecion
bool EditorSelectedListAdd(int type, int array_index, const char *strString, ...)
{

	char		strText[256];
	va_list		argumentPtr;

	if (strString == NULL) { return true; }
	
	va_start(argumentPtr, strString);
	vsprintf(strText, strString, argumentPtr);
	va_end(argumentPtr);

	char t[256];

	// Aade a la lista de objetos de la escena
	SendDlgItemMessage(hMain, IDC_LIST_OBJETOS, LB_ADDSTRING, 0,(LPARAM)strText	);

	// Seleciona la ultima entrada
	int total = SendDlgItemMessage(hMain, IDC_LIST_OBJETOS, LB_GETCOUNT, 0, 0);
	SendDlgItemMessage(hMain, IDC_LIST_OBJETOS, LB_SETCURSEL, total-1, 0);	
	int sel = SendDlgItemMessage(hMain, IDC_LIST_OBJETOS, LB_GETCURSEL, 0, 0);	

	sprintf(t, " AddItem:\n Type: %d\n Total lista: %d\n Array Obj pos: %d", type, total, array_index);
	//DDEBUG_Write("SelectedListAdd: Type: %d Total lista: %d Array Obj pos: %d", type, total, array_index);
	//MessageBox(NULL, t, "", MB_OK);

	// Redimensiona y guarda la info
	if (EditorSelectionInfo == NULL)
	{
		EditorSelectionInfo = (tEditorSelectionInfo *)malloc(total*sizeof(tEditorSelectionInfo));
	}
	else
	{
		EditorSelectionInfo = (tEditorSelectionInfo *)realloc(EditorSelectionInfo, total*sizeof(tEditorSelectionInfo));
	}

	EditorSelectionInfo[sel].type  = type;
	EditorSelectionInfo[sel].index = array_index;

	DDEBUG_Write("SelectedListAdd: ADD: SEL=%d, type: %d array_index: %d", sel, type, array_index);
/*
	for (int i=0; i<total ; i++)
	{
		DDEBUG_Write("SelectedListAdd: Type: %d Total lista: %d Array Obj pos: %d", EditorSelectionInfo[i].type, total, EditorSelectionInfo[i].index);
	}
*/
	return true;


}

// Dibuja un rectangulo de 20x20 para previsualizar un color
void DrawColorRectangle(HDC hDC, int cx, int cy, COLORREF color)
{

	for (int y=cy ; y<(cy+20) ; y++)
	{
		for (int x=cx ; x<(cx+20) ; x++)
		{
			SetPixel(hDC, x, y, color);
		}
	}

}

// Esta estructura contiene todos los pasos de generacion a lo largo del proyecto
/*
	[step][objetc]
	Ejemplo:
			[IGT_CREATE_OBJ][IGT_OBJTYPE_SPHERE][3]
			Crea un objeto -> esfera -> la info esta en Esfera[3]
	
*/

void DrawQuadricula()
{

	int x, y;

	glDisable(GL_LIGHTING);

	if (RenderPlano)
	{
		glBegin(GL_LINES);

			for (x=-100 ; x<100 ; x++)
			{
				// x
				glColor4f(0.5, 0.5, 0.5, 1);

				glVertex3f(-100, 0, x);
				glVertex3f(100, 0, x);

				glVertex3f(x, 0, -100);
				glVertex3f(x, 0, 100);
			}

		glEnd();
	}

	//glDisable(GL_DEPTH_TEST);

	if (RenderEjes)
	{
		glBegin(GL_LINES);

			glColor4f(1, 0, 0, 1);
			glVertex3f(0, 0, 0); // X
			glVertex3f(5, 0, 0);

			glColor4f(0, 1, 0, 1);
			glVertex3f(0, 0, 0); // Y
			glVertex3f(0, 5, 0);

			glColor4f(0, 0, 1, 1);
			glVertex3f(0, 0, 0); // Z
			glVertex3f(0, 0, -5);

		glEnd();

	}

	glColor4f(1, 1, 1, 1);

	//glEnable(GL_DEPTH_TEST);

	glColor4f(1, 1, 1, 1);
	glEnable(GL_LIGHTING);

}

void SetOrtho(int width, int height)
{
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();										
	glLoadIdentity();								
	glOrtho(0, width, height, 0, 0, 1);	// Set ortho
		
	glMatrixMode(GL_MODELVIEW);									
	glLoadIdentity();										
}

void UnsetOrtho()
{

	glMatrixMode( GL_PROJECTION );								
	glPopMatrix();												
	glMatrixMode( GL_MODELVIEW );							

}

void DrawCameraRectangleView()
{

	SetOrtho(200, 150); // da igual ya que RebGL hace resize ;)

	glPushMatrix();

		glLineWidth(1);
		glBegin(GL_LINE_STRIP);

			glColor4f(0, 1, 0, 1);

			// dos lineas transversales arriba
			glVertex3f(10, 10, 0);
			glVertex3f(190, 10, 0);
			glVertex3f(190, 140, 0);
			glVertex3f(10, 140, 0);
			glVertex3f(10, 10, 0);

		glEnd();

		glBegin(GL_LINE_STRIP);

			glColor4f(1, 0.5, 0, 1);

			// dos lineas transversales arriba
			glVertex3f(15, 15, 0);
			glVertex3f(185, 15, 0);
			glVertex3f(185, 135, 0);
			glVertex3f(15, 135, 0);
			glVertex3f(15, 15, 0);

		glEnd();

	glPopMatrix();

	glLineWidth(1);

	glColor4f(1, 1, 1, 1);

	UnsetOrtho();

}

void DrawPlayIcon()
{

	SetOrtho(200, 150); // da igual ya que RebGL hace resize ;)

	glPushMatrix();
		
		glBegin(GL_TRIANGLES);

			glColor4f(0, 1, 0, 1);

			// dos lineas transversales arriba
			glVertex3f(180, 10, 0);
			glVertex3f(180, 20, 0);
			glVertex3f(187, 15, 0);

		glEnd();

		glBegin(GL_LINE_STRIP);

			glColor4f(0, 1, 0, 1);

			// dos lineas transversales arriba
			glVertex3f(175, 7, 0);
			glVertex3f(190, 7, 0);			
			glVertex3f(190, 23, 0);			
			glVertex3f(175, 23, 0);
			glVertex3f(175, 7, 0);

		glEnd();

	glPopMatrix();	

	glColor4f(1, 1, 1, 1);

	UnsetOrtho();

}

// Dibuja un cubo de selecion alrededor de un objeto
void DrawSelectionCube(int ObjIndex)
{

	float x1=0;
	float x2=0; // positivo,negativo
	float y1=0;
	float y2=0;
	float z1=0;
	float z2=0;

	// Buscamos los vertices mas alejados para saver los limites del cubo
	for (int i=0 ; i<GlobalScene.Object[ObjIndex].NumVertex ; i++)
	{
		// Positivo
		if (x1 < GlobalScene.Object[ObjIndex].Vertex[i].x)
		{
			x1 = GlobalScene.Object[ObjIndex].Vertex[i].x;
		}
		// Negativo
		if (x2 > GlobalScene.Object[ObjIndex].Vertex[i].x)
		{
			x2 = GlobalScene.Object[ObjIndex].Vertex[i].x;
		}

		// Positivo
		if (y1 < GlobalScene.Object[ObjIndex].Vertex[i].y)
		{
			y1 = GlobalScene.Object[ObjIndex].Vertex[i].y;
		}
		// Negativo
		if (y2 > GlobalScene.Object[ObjIndex].Vertex[i].y)
		{
			y2 = GlobalScene.Object[ObjIndex].Vertex[i].y;
		}

		// Positivo
		if (z1 < GlobalScene.Object[ObjIndex].Vertex[i].z)
		{
			z1 = GlobalScene.Object[ObjIndex].Vertex[i].z;
		}
		// Negativo
		if (z2 > GlobalScene.Object[ObjIndex].Vertex[i].z)
		{
			z2 = GlobalScene.Object[ObjIndex].Vertex[i].z;
		}

	}
/*
	x1 += 0.0f; x2 -= 0.0f;	
	y1 += 0.0f; y2 -= 0.0f;	
	z1 += 0.0f; z2 -= 0.0f;	
*/
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	glPushMatrix();

		glBegin(GL_LINES);

			glColor4f(1, 1, 0, 1);

			// dos lineas transversales arriba
			glVertex3f(x1, y1, z1);
			glVertex3f(x2, y1, z1);			
			glVertex3f(x1, y1, z2);
			glVertex3f(x2, y1, z2);

			// otras dos abajo
			glVertex3f(x1, y2, z1);
			glVertex3f(x2, y2, z1);			
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y2, z2);

			// vertical izquerda
			glVertex3f(x1, y1, z1);
			glVertex3f(x1, y2, z1);
			glVertex3f(x2, y1, z1);
			glVertex3f(x2, y2, z1);

			// vertical derecha
			glVertex3f(x1, y1, z2);
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y1, z2);
			glVertex3f(x2, y2, z2);

			// hasta el fondo arriba
			glVertex3f(x1, y1, z1);
			glVertex3f(x1, y1, z2);
			glVertex3f(x2, y1, z1);
			glVertex3f(x2, y1, z2);

			glVertex3f(x1, y2, z1);
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y2, z1);
			glVertex3f(x2, y2, z2);

		glEnd();

	glPopMatrix();

	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);

	glColor4f(1, 1, 1, 1);

}

void DrawCamera(igtVector3 pos, igtVector3 target)
{

	float x1 = pos.x-0.5;
	float x2 = pos.x+0.5;

	float y1 = pos.y-0.5;
	float y2 = pos.y+0.5;

	float z1 = pos.z-0.5;
	float z2 = pos.z+0.5;

	glPushMatrix();

		// Posicion
		glBegin(GL_LINES);

			glColor4f(0, 1, 1, 1);

			// dos lineas transversales arriba
			glVertex3f(x1, y1, z1);
			glVertex3f(x2, y1, z1);			
			glVertex3f(x1, y1, z2);
			glVertex3f(x2, y1, z2);

			// otras dos abajo
			glVertex3f(x1, y2, z1);
			glVertex3f(x2, y2, z1);			
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y2, z2);

			// vertical izquerda
			glVertex3f(x1, y1, z1);
			glVertex3f(x1, y2, z1);
			glVertex3f(x2, y1, z1);
			glVertex3f(x2, y2, z1);

			// vertical derecha
			glVertex3f(x1, y1, z2);
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y1, z2);
			glVertex3f(x2, y2, z2);

			// hasta el fondo arriba
			glVertex3f(x1, y1, z1);
			glVertex3f(x1, y1, z2);
			glVertex3f(x2, y1, z1);
			glVertex3f(x2, y1, z2);

			glVertex3f(x1, y2, z1);
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y2, z1);
			glVertex3f(x2, y2, z2);

		glEnd();

		x1 = target.x-0.2;
		x2 = target.x+0.2;

		y1 = target.y-0.2;
		y2 = target.y+0.2;

		z1 = target.z-0.2;
		z2 = target.z+0.2;

		// Objetivo
		glBegin(GL_LINES);

			glColor4f(0, 1, 0, 1);

			// dos lineas transversales arriba
			glVertex3f(x1, y1, z1);
			glVertex3f(x2, y1, z1);			
			glVertex3f(x1, y1, z2);
			glVertex3f(x2, y1, z2);

			// otras dos abajo
			glVertex3f(x1, y2, z1);
			glVertex3f(x2, y2, z1);			
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y2, z2);

			// vertical izquerda
			glVertex3f(x1, y1, z1);
			glVertex3f(x1, y2, z1);
			glVertex3f(x2, y1, z1);
			glVertex3f(x2, y2, z1);

			// vertical derecha
			glVertex3f(x1, y1, z2);
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y1, z2);
			glVertex3f(x2, y2, z2);

			// hasta el fondo arriba
			glVertex3f(x1, y1, z1);
			glVertex3f(x1, y1, z2);
			glVertex3f(x2, y1, z1);
			glVertex3f(x2, y1, z2);

			glVertex3f(x1, y2, z1);
			glVertex3f(x1, y2, z2);
			glVertex3f(x2, y2, z1);
			glVertex3f(x2, y2, z2);

		glEnd();

		// Traza una linea entre la camara y el objetivo
		glBegin(GL_LINES);			
			
			glColor4f(0, 1, 1, 1);
			glVertex3f(pos.x, pos.y, pos.z);
			glColor4f(0, 1, 0, 1);
			glVertex3f(target.x, target.y, target.z);

		glEnd();

	glPopMatrix();

	glColor4f(1, 1, 1, 1);	

}

void RenderAnimRectangle()
{



	SetOrtho(200, 150); // da igual ya que RebGL hace resize ;)

	//glDisable(GL_TEXTURE_2D);
	//glDisable(GL_LIGHTING);

	glPushMatrix();

		glLineWidth(5);
		glBegin(GL_LINE_STRIP);

			glColor4f(1, 0, 0, 1);

			// dos lineas transversales arriba
			glVertex3f(0, 0, 0);
			glVertex3f(200, 0, 0);
			glVertex3f(200, 150, 0);
			glVertex3f(0, 150, 0);
			glVertex3f(0, 0, 0);

		glEnd();

	glPopMatrix();

	glLineWidth(1);

	//glEnable(GL_LIGHTING);
	//glEnable(GL_TEXTURE_2D);

	glColor4f(1, 1, 1, 1);

	UnsetOrtho();
}

// Funcion temporal de prueba de dialogs
LRESULT CALLBACK procTabChild(HWND hdwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

	switch (uMsg)
	{

		case WM_INITDIALOG:
		{						

		}
		break;


    case WM_DESTROY:
		{						
			EndDialog(hdwnd, 0);			
			return TRUE;
		}

	case WM_SYSCOMMAND: // Mensaje del sistema (no del usuario) a la ventana. Por ejemplo cuando se apaga el equipo, se manda que se cierre.
	{
		
		switch (LOWORD(wParam)) // Que mensaje es?
		{

			case 61536: // Cerrar la ventana (ALT+F4, System-Menu etc...)
			{
				SendMessage(hdwnd, WM_DESTROY, 0, 0);
				return TRUE;
			}
			break;
		}

		break;
	}


	};
	
	return FALSE;
};

// Textura temporal del editor
GLuint Textures[10];
void MakeTestTexture()
{
	unsigned char *data;
	long c=0;

	int x, y;

	data = (unsigned char *)malloc(256*256*3*sizeof(unsigned char));

	for (y=0 ; y<256 ; y++)
	{
		for (int x=0 ; x<256 ; x++)
		{

			long c = (x + (y*256))*3;

			
			data[c] = (x^y);
			data[c+1] = (x^y);
			data[c+2] = (x^y);

		}
	}

	/* // Flare : max(0.0,255.0-(my_sqrt( (x-32)*(x-32) + (y-32)*(y-32) )*8.0))/3;
	for (y=0 ; y<256 ; y++)
	{
		for (x=0 ; x<256 ; x++)
		{
			data[c] = max(0.0,255.0-(sqrt( (x-32)*(x-32) + (y-32)*(y-32) )*8.0))/3;

			data[c+1] = data[c];
			data[c+2] = data[c];

			c+=3;
		}
	}
	*/

	igtRegisterTexture(Textures, 0, 256, 256, 0, data);	

	free(data);
}

float CosineInterpolate(float a, float b, float x)
{

	return (float)a*(1-x) + b*x; // linear interpolation
/*
	// Cosine interpolation (more slow, but more smooth...)
	float ft = x * 3.1415927;
	float f = (1 - cos(ft)) * 0.5;

	return (float)a*(1-f) + b*f;
*/	
}

bool CheckFirstInstance()
{
	HWND pWndPrev;
	HWND pWndChild;

	// Determine if another window with our class name and Window title exists...
	// The title "Instance " is set up latter, in the InitDialog function.
	if (pWndPrev = FindWindow("#32770","Tool :: Solstice"))
	{
		pWndChild = GetLastActivePopup(pWndPrev); // if so, does it have any popups?

		if (IsIconic(pWndPrev)) 
		{
		   ShowWindow(pWndPrev, SW_RESTORE);      // If iconic, restore the main window
		}

		SetForegroundWindow(pWndChild);         // Bring the main window or it's popup to

		//MessageBox(pWndPrev, "Solo se permite una sola instancia de la aplicacion", "Tool", MB_OK | MB_ICONINFORMATION);
												  // the foreground
		// and we are done activating the previous one.
		return false;
	}

	return true;                              // First instance. Proceed as normal.

}

// Inicializa una escena a 0
void ResetProyect(HWND hdwnd, igtScene *Scene, igtSceneInfo *SceneInfo)
{
	Scene->NumObjects = 0;
	Scene->NumCameras = 0;	

	SceneInfo->NumCamaras = 0;
	SceneInfo->NumConos = 0;
	SceneInfo->NumCilindros = 0;
	SceneInfo->NumDiscos = 0;
	SceneInfo->NumEsferas = 0;
	SceneInfo->NumTorus = 0;

	if (SceneInfo->Camera	!= NULL) { free(SceneInfo->Camera); }
	if (SceneInfo->Cone		!= NULL) { free(SceneInfo->Cone); }
	if (SceneInfo->Cylinder	!= NULL) { free(SceneInfo->Cylinder); }
	if (SceneInfo->Disc		!= NULL) { free(SceneInfo->Disc); }
	if (SceneInfo->Sphere	!= NULL) { free(SceneInfo->Sphere); }
	if (SceneInfo->Torus	!= NULL) { free(SceneInfo->Torus); }

	if (EditorSelectionInfo != NULL) 
	{ 
		free(EditorSelectionInfo);
		EditorSelectionInfo = NULL;
	}

	// Parametros del editor
	GlobalRender_RotacionX=0;
	GlobalRender_RotacionY=30;
	GlobalRender_LastRotacionX=0;
	GlobalRender_LastRotacionY=0;

	// Posicion mediante el raton
	GlobalRender_PosicionX=0;
	GlobalRender_PosicionY=0;
	GlobalRender_PosicionZ=-10;
	GlobalRender_LastPosicionX=0;
	GlobalRender_LastPosicionY=0;
	GlobalRender_LastPosicionZ=0;

	AnimationFrames=100;			// Numero de frames en la animacion
	AnimationFrameRate=25;			// Velocidad de la animacion
	RenderMode=0;					// 0: Polis, 1: wire
	RenderPlano=true;				// Dibujar plano de referencia
	RenderEjes=true;				// Dibujar ejes
	AnimationMode=false;			// Para saver si estamos animando o no
	RenderCamara=0;					// Vistas del render -> 0: Perspectiva, 1, 2, 3 etc indice de la camara a renderizar
	SelectedCamera=-1;				// Camara seleccionada actualmente (-1=ninguna)

	// Limpiamos la lista de seleccion	
	SendMessage(GetDlgItem(hdwnd, IDC_LIST_OBJETOS), LB_RESETCONTENT, 0, 0);

}

/***********************************

  Funciones de informacion de
  generacion de la escena

 ***********************************/

/*
	bool igtAddSphere(igtScene *Scene, float radio, char segmentos_alto, char segmentos_ancho)
	bool igtAddTorus(igtScene *Scene, float radio_interior, float radio_exterior, char segmentos_alto, char segmentos_ancho)
	bool igtAddCone(igtScene *Scene, float radio, float alto, char segmentos_alto, char segmentos_ancho)
	bool igtAddDisc(igtScene *Scene, float radio, char lonchas)
	bool igtAddCylinder(igtScene *Scene, float radio, float alto, char segmentos_alto, char segmentos_ancho)
	bool igtAddCamera(igtScene *Scene, igtVector3 Position, igtVector3 Target)
*/

bool SceneInfo_AddSphere(igtSceneInfo *SceneInfo, float radio, char segmentos_alto, char segmentos_ancho)
{

	if (SceneInfo->NumEsferas == 0)
	{
		SceneInfo->NumEsferas=1;		
		if ( (SceneInfo->Sphere = (igtObjSphere *)malloc(sizeof(igtObjSphere))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}
	else
	{
		SceneInfo->NumEsferas++;
		if ( (SceneInfo->Sphere = (igtObjSphere *)realloc(SceneInfo->Sphere, SceneInfo->NumEsferas*sizeof(igtObjSphere))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}

	SceneInfo->Sphere[SceneInfo->NumEsferas-1].index = GlobalScene.NumObjects-1;
	SceneInfo->Sphere[SceneInfo->NumEsferas-1].radio = radio;
	SceneInfo->Sphere[SceneInfo->NumEsferas-1].segmentos_alto = segmentos_alto;
	SceneInfo->Sphere[SceneInfo->NumEsferas-1].segmentos_ancho = segmentos_ancho;

	return true;
}

bool SceneInfo_AddTorus(igtSceneInfo *SceneInfo, float radio_interior, float radio_exterior, char segmentos_alto, char segmentos_ancho)
{

	if (SceneInfo->NumTorus == 0)
	{
		SceneInfo->NumTorus=1;		
		if ( (SceneInfo->Torus = (igtObjTorus *)malloc(sizeof(igtObjTorus))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}
	else
	{
		SceneInfo->NumTorus++;
		if ( (SceneInfo->Torus = (igtObjTorus *)realloc(SceneInfo->Torus, SceneInfo->NumTorus*sizeof(igtObjTorus))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}

	SceneInfo->Torus[SceneInfo->NumTorus-1].index = GlobalScene.NumObjects-1;
	SceneInfo->Torus[SceneInfo->NumTorus-1].radio_interior = radio_interior;
	SceneInfo->Torus[SceneInfo->NumTorus-1].radio_exterior = radio_exterior;
	SceneInfo->Torus[SceneInfo->NumTorus-1].segmentos_alto = segmentos_alto;
	SceneInfo->Torus[SceneInfo->NumTorus-1].segmentos_ancho = segmentos_ancho;

	return true;
}

bool SceneInfo_AddCone(igtSceneInfo *SceneInfo, float radio, float alto, char segmentos_alto, char segmentos_ancho)
{

	if (SceneInfo->NumConos == 0)
	{
		SceneInfo->NumConos=1;		
		if ( (SceneInfo->Cone = (igtObjCone *)malloc(sizeof(igtObjCone))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}
	else
	{
		SceneInfo->NumConos++;
		if ( (SceneInfo->Cone = (igtObjCone *)realloc(SceneInfo->Cone, SceneInfo->NumConos*sizeof(igtObjTorus))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}

	SceneInfo->Cone[SceneInfo->NumConos-1].index = GlobalScene.NumObjects-1;
	SceneInfo->Cone[SceneInfo->NumConos-1].radio = radio;
	SceneInfo->Cone[SceneInfo->NumConos-1].alto = alto;
	SceneInfo->Cone[SceneInfo->NumConos-1].segmentos_alto = segmentos_alto;
	SceneInfo->Cone[SceneInfo->NumConos-1].segmentos_ancho = segmentos_ancho;

	return true;
}

bool SceneInfo_AddDisc(igtSceneInfo *SceneInfo, float radio, char segmentos)
{

	if (SceneInfo->NumDiscos == 0)
	{
		SceneInfo->NumDiscos=1;		
		if ( (SceneInfo->Disc = (igtObjDisc *)malloc(sizeof(igtObjDisc))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}
	else
	{
		SceneInfo->NumDiscos++;
		if ( (SceneInfo->Disc = (igtObjDisc *)realloc(SceneInfo->Disc, SceneInfo->NumDiscos*sizeof(igtObjDisc))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}

	SceneInfo->Disc[SceneInfo->NumDiscos-1].index = GlobalScene.NumObjects-1;
	SceneInfo->Disc[SceneInfo->NumDiscos-1].radio = radio;
	SceneInfo->Disc[SceneInfo->NumDiscos-1].segmentos = segmentos;

	return true;
}

bool SceneInfo_AddCylinder(igtSceneInfo *SceneInfo, float radio, float alto, char segmentos_alto, char segmentos_ancho)
{

	if (SceneInfo->NumCilindros == 0)
	{
		SceneInfo->NumCilindros=1;		
		if ( (SceneInfo->Cylinder = (igtObjCylinder *)malloc(sizeof(igtObjCylinder))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}
	else
	{
		SceneInfo->NumCilindros++;
		if ( (SceneInfo->Cylinder = (igtObjCylinder *)realloc(SceneInfo->Disc, SceneInfo->NumCilindros*sizeof(igtObjCylinder))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}

	SceneInfo->Cylinder[SceneInfo->NumCilindros-1].index = GlobalScene.NumObjects-1;
	SceneInfo->Cylinder[SceneInfo->NumCilindros-1].radio = radio;
	SceneInfo->Cylinder[SceneInfo->NumCilindros-1].alto = alto;
	SceneInfo->Cylinder[SceneInfo->NumCilindros-1].segmentos_alto = segmentos_alto;
	SceneInfo->Cylinder[SceneInfo->NumCilindros-1].segmentos_ancho = segmentos_ancho;

	return true;
}

bool SceneInfo_AddCamera(igtSceneInfo *SceneInfo, igtVector3 Position, igtVector3 Target)
{

	if (SceneInfo->NumCamaras == 0)
	{
		SceneInfo->NumCamaras=1;		
		if ( (SceneInfo->Camera = (igtCamera *)malloc(sizeof(igtCamera))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}
	else
	{
		SceneInfo->NumCamaras++;
		if ( (SceneInfo->Camera = (igtCamera *)realloc(SceneInfo->Camera, SceneInfo->NumCamaras*sizeof(igtCamera))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}

	SceneInfo->Camera[SceneInfo->NumCamaras-1].index = GlobalScene.NumObjects-1;

	SceneInfo->Camera[SceneInfo->NumCamaras-1].Position.x = Position.x;
	SceneInfo->Camera[SceneInfo->NumCamaras-1].Position.y = Position.y;
	SceneInfo->Camera[SceneInfo->NumCamaras-1].Position.z = Position.z;

	SceneInfo->Camera[SceneInfo->NumCamaras-1].Target.x = Target.x;
	SceneInfo->Camera[SceneInfo->NumCamaras-1].Target.y = Target.y;
	SceneInfo->Camera[SceneInfo->NumCamaras-1].Target.z = Target.z;

	return true;
}