#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
#include "Instruments.h"

extern float g_y[FREQ_ANALYZE_SAMPLES];

namespace Buzzic
{
	/// <summary> 
	/// Summary for OutputAnalyzer
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class OutputAnalyzer : public System::Windows::Forms::Form
	{
	public: 
		OutputAnalyzer(void)
		{
			InitializeComponent();
		}
        
	protected: 
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}
	private: System::Windows::Forms::PictureBox *  pic;
	private: System::Windows::Forms::Timer *  timer1;
	private: System::ComponentModel::IContainer *  components;

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>


		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = new System::ComponentModel::Container();
			this->pic = new System::Windows::Forms::PictureBox();
			this->timer1 = new System::Windows::Forms::Timer(this->components);
			this->SuspendLayout();
			// 
			// pic
			// 
			this->pic->Dock = System::Windows::Forms::DockStyle::Fill;
			this->pic->Location = System::Drawing::Point(0, 0);
			this->pic->Name = S"pic";
			this->pic->Size = System::Drawing::Size(292, 273);
			this->pic->TabIndex = 0;
			this->pic->TabStop = false;
			this->pic->Resize += new System::EventHandler(this, pic_Resize);
			this->pic->Paint += new System::Windows::Forms::PaintEventHandler(this, pic_Paint);
			// 
			// timer1
			// 
			this->timer1->Enabled = true;
			this->timer1->Interval = 50;
			this->timer1->Tick += new System::EventHandler(this, timer1_Tick);
			// 
			// OutputAnalyzer
			// 
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->ClientSize = System::Drawing::Size(292, 273);
			this->Controls->Add(this->pic);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::SizableToolWindow;
			this->Name = S"OutputAnalyzer";
			this->ShowInTaskbar = false;
			this->Text = S"Output Analyzer";
			this->ResumeLayout(false);

		}		


		protected: 
			// Close by ESC key
			bool ProcessCmdKey ( Message* msg, Keys keyData ) {
				if ( keyData == Keys::Escape ) {
					Close ( );
					return true;
				}
				return Form::ProcessCmdKey ( msg, keyData );
			}

	private:
			// Paints window
			System::Void pic_Paint ( System::Object *  sender, System::Windows::Forms::PaintEventArgs *  e ) {
				int w = pic->Width;
				int h = pic->Height / 2;
				int x0 = 0, x1;
				int y0 = ( 1.0 - g_y[0] ) * h, y1;
				for ( int i = 1; i < FREQ_ANALYZE_SAMPLES; i++ ) {
					x1 = w * i / (FREQ_ANALYZE_SAMPLES-1);
					y1 = ( 1.0 - g_y[i] ) * h;
					e->Graphics->DrawLine ( Pens::Black, x0, y0, x1, y1 );
					x0 = x1;
					y0 = y1;
				}
			}

	private: System::Void pic_Resize(System::Object *  sender, System::EventArgs *  e)
			 {
				 pic->Invalidate ( );
			 }

	private: System::Void timer1_Tick(System::Object *  sender, System::EventArgs *  e)
			 {
				 // Copy array not to block playing thread
				EnterCriticalSection ( &g_anCs );
				CopyMemory ( g_y, g_freqAnSamples, FREQ_ANALYZE_SAMPLES*sizeof(float) );
				LeaveCriticalSection ( &g_anCs );
				// Draw results
				pic->Invalidate ( );
				pic->Update ( );
			 }

	};
}