#ifndef __INSTRUMENTS_H__
#define __INSTRUMENTS_H__

const int MAX_SEQUENCES = 64;
const int MAX_TEMPLATE_MELODY_LEN = 256;
const int MAX_PATTERNS = 64;
const int SAMPLE_FREQUENCY	= 44100;
const int FREQ_ANALYZE_SAMPLES = 2048;
const int MAX_OPERATIONS = 64;
const int MAX_OPER_STACK_SIZE = 1024;

#include "Operations.h"

// WAV structures
struct WaveHeader {
	DWORD riff, fileSize, wave, format, formatLength;
};
struct WaveFormat {
	WORD formatTag;
	WORD channels;
	DWORD samplesPerSec;
	DWORD avgBytesPerSec;
	WORD blockAlign;
	WORD bitsPerSample;
};
struct ChunkHeader {
	DWORD type, len;
};

// Declares all instrument properties
struct Instrument { 
	// Display data
	char name[128];
	char mute;
	// Instrument description
	char note;
	char noteLen;
	char volume;
	// Operations
	Operation* oper[MAX_OPERATIONS];
	int operCount;
	// Connections between operations
	OperConnection operConn[MAX_OPERATIONS*10];
	int operConnCount;
	// Operation stack
	char stack[MAX_OPER_STACK_SIZE];
	int programLen;
	char unused[128];
};
extern Instrument g_instruments[128];
extern int g_instrumentCount;
extern int ROW_SIZE_SAMPLES;

extern void PlayOneNote ( Instrument* ins, float* amplitude );
extern int FillNoteBuffer ( float* data, int maxLenSamples, Instrument* ins, int rowPos );
extern float CutLevel ( float x, float lvl );
extern char g_buf[1024];
extern float g_masterVolume;

// Sequences
extern char g_bytePatterns[MAX_PATTERNS][16];
extern short g_bitPatterns[MAX_PATTERNS];
extern char g_byteSequences[MAX_SEQUENCES][MAX_TEMPLATE_MELODY_LEN];
extern char g_bitSequences[MAX_SEQUENCES][MAX_TEMPLATE_MELODY_LEN];
extern int g_bytePatternsCount;
extern int g_byteSequencesCount;

extern float g_freqAnSamples[FREQ_ANALYZE_SAMPLES];
extern CRITICAL_SECTION	g_anCs;
extern CRITICAL_SECTION	g_stackCs;

#endif  // __INSTRUMENTS_H__