#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
#include "Instruments.h"
#include "fourier.h"

extern float g_x[FREQ_ANALYZE_SAMPLES];

namespace Buzzic
{
	/// <summary> 
	/// Summary for FreqAnalyzer
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class FreqAnalyzer : public System::Windows::Forms::Form
	{
	public: 
		FreqAnalyzer(void)
		{
			InitializeComponent();
			maxAmpl = 1.0;
			linePen = new System::Drawing::Pen ( Brushes::DarkGreen );
			linePen->DashStyle = System::Drawing::Drawing2D::DashStyle::Dot;
		}
        
	protected: 
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}
	private: double maxAmpl;
	private: System::Windows::Forms::PictureBox *  pic;
	private: System::Windows::Forms::Timer *  timer1;
	private: System::ComponentModel::IContainer *  components;
	private: System::Drawing::Pen* linePen;

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>


		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = new System::ComponentModel::Container();
			this->pic = new System::Windows::Forms::PictureBox();
			this->timer1 = new System::Windows::Forms::Timer(this->components);
			this->SuspendLayout();
			// 
			// pic
			// 
			this->pic->BackColor = System::Drawing::SystemColors::Control;
			this->pic->Dock = System::Windows::Forms::DockStyle::Fill;
			this->pic->Location = System::Drawing::Point(0, 0);
			this->pic->Name = S"pic";
			this->pic->Size = System::Drawing::Size(672, 432);
			this->pic->TabIndex = 0;
			this->pic->TabStop = false;
			this->pic->Resize += new System::EventHandler(this, pic_Resize);
			this->pic->Paint += new System::Windows::Forms::PaintEventHandler(this, pic_Paint);
			// 
			// timer1
			// 
			this->timer1->Enabled = true;
			this->timer1->Interval = 50;
			this->timer1->Tick += new System::EventHandler(this, timer1_Tick);
			// 
			// FreqAnalyzer
			// 
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->ClientSize = System::Drawing::Size(672, 432);
			this->Controls->Add(this->pic);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::SizableToolWindow;
			this->Name = S"FreqAnalyzer";
			this->ShowInTaskbar = false;
			this->StartPosition = System::Windows::Forms::FormStartPosition::CenterScreen;
			this->Text = S"Frequency Analyzer";
			this->ResumeLayout(false);

		}		


protected: 
			// Close by ESC key
			bool ProcessCmdKey ( Message* msg, Keys keyData ) {
				if ( keyData == Keys::Escape ) {
					Close ( );
					return true;
				}
				return Form::ProcessCmdKey ( msg, keyData );
			}

	private: 
			// Redraws window
			System::Void pic_Paint ( System::Object *  sender, System::Windows::Forms::PaintEventArgs *  e ) {
				int w = pic->Width;
				int h = pic->Height;
				int x0 = 0, x1;
				int y0 = ( 1.0 - g_x[0]/maxAmpl ) * h, y1;
				for ( int i = 1; i < FREQ_ANALYZE_SAMPLES/2; i++ ) {
					//x1 = w * i / (FREQ_ANALYZE_SAMPLES/2-1);	// Linear scale
					x1 = w*0.05 + log10 ( (float)i /FREQ_ANALYZE_SAMPLES * SAMPLE_FREQUENCY / 20.0 ) / 3.0 * w * 0.9;
					y1 = ( 1.0 - g_x[i]/maxAmpl ) * h;
					e->Graphics->DrawLine ( Pens::Black, x0, y0, x1, y1 );
					x0 = x1;
					y0 = y1;
				}
				// Draw X-axis marks
				double freqs[] = { 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000 };
				for ( int i = 0; i < 10; i++ ) {
					float x = w*0.05 + log10 ( freqs[i] / 20.0 ) / 3.0 * w * 0.9;
					e->Graphics->DrawLine ( linePen, x, 0.0f, x, (float)h );
					e->Graphics->DrawString ( Convert::ToString ( freqs[i] ), Font, Brushes::DarkGreen, x, 0 );
				}
			}

	private: 

		// Analyzes signal and repaints window
		System::Void timer1_Tick ( System::Object *  sender, System::EventArgs *  e ) {
			// Copy array not to block playing thread
			EnterCriticalSection ( &g_anCs );
			CopyMemory ( g_x, g_freqAnSamples, FREQ_ANALYZE_SAMPLES*sizeof(float) );
			LeaveCriticalSection ( &g_anCs );

			// Get FFT
			float ro[FREQ_ANALYZE_SAMPLES];
			float io[FREQ_ANALYZE_SAMPLES];
			fft_float ( FREQ_ANALYZE_SAMPLES, FALSE, g_x, NULL, ro, io );
			// Calculate amplitude spectrum
			maxAmpl = 0;
			for ( int i = 0; i < FREQ_ANALYZE_SAMPLES; i++ ) {
				g_x[i] = sqrtf ( sqrtf ( ro[i]*ro[i] + io[i]*io[i] ) );
				if ( !_finite ( g_x[i] ) || g_x[i] > 1e4 )
					g_x[i] = 1e4;
				else
					if ( g_x[i] > maxAmpl )
						maxAmpl = g_x[i];
			}
			if ( !maxAmpl  )
				maxAmpl = 1.0;
                
			// Draw results
			pic->Invalidate ( );
			pic->Update ( );
		}

	private: System::Void pic_Resize(System::Object *  sender, System::EventArgs *  e)
			 {
				 pic->Invalidate ( );
			 }

};
}