
class ParticleJelly
{
  int index;
  
//  int len;            // number of elements in position array
//  Vector3[] loc;        // array of position vectors
//  Vector3 startLoc;     // just used to make sure every loc[] is initialized to the same position
  Vector3 pos;          // position point
  Vector3 oldPos;
  Vector3 _vel;          // velocity vector
  Vector3 _accel;        // acceleration vector
  float radius;       // particle's size
  float age;          // current age of particle
  float lifeSpan;       // max allowed age of particle
  float agePer;       // range from 1.0 (birth) to 0.0 (death)
  int gen;            // number of times particle has been involved in a SPLIT
  boolean _isDead;     // if age == lifeSpan, make particle die

  int _particleTexID;
  int _nebulaTexID;
  int _tailTexID;
  
  float angleStart;
  float angleEnd;
  
  int numFrames;
  int animFrame;
  float animFramef;    // currframe of our animation (float)
  
  float seaLevel = 350.0;

  Ribbon rib;
  Vector3[] _tailCopy;
  Vector3[] _tailCopy2;
  Vector3[] _tailCopy3;
  Vector3[] _tailCopy4;

//  Nebula neb;


  ParticleJelly( int idx, int gen, Vector3 loc, Vector3 vel )
  {
    index = idx;
    
    //int len = 10;
    //startLoc = loc;
    //this.loc = new Vector3[len];

    pos = loc.copy();
    oldPos = loc.copy();

    _vel = vel.copy();
//    pos = new Vector3(random(-0.52, 0.52), random(-0.2, 0.2), 0);
//    _vel = new Vector3(random(-.52, .52), random(-.2, .2), 0);
//    _vel = new Vector3();
    _accel = new Vector3(random(-.052, .052), random(-.2, .532), random(-.052, .0532)); //new Vector3();

    radius = 60; //30;

    age = 0; //2+random(5);  // birth
    lifeSpan = 112+random(85); // death

    _isDead = false;
    
    angleStart = 0;
    angleEnd = 0;

//    rib = new Ribbon( (int)random(20, 40), 1.0, 8.0, false );
    rib = new Ribbon( (int)random(40,70), 1.0, 8.0, false );
    //rib.loadHeadTexture( "flare2.png" );
    rib.setHead( pos.x, pos.y, pos.z );
    rib.setTimeToLive( lifeSpan );
    rib.computeTail(); 

    _tailCopy = new Vector3[rib._tailSize];
    _tailCopy2 = new Vector3[rib._tailSize];
    _tailCopy3 = new Vector3[rib._tailSize];
    _tailCopy4 = new Vector3[rib._tailSize];
    for( int i=0; i<_tailCopy.length; i++ )
    {
      _tailCopy[i] = new Vector3();
      _tailCopy[i] = rib._tail[i].copy();

      _tailCopy2[i] = new Vector3();
      _tailCopy2[i] = rib._tail[i].copy();

      _tailCopy3[i] = new Vector3();
      _tailCopy3[i] = rib._tail[i].copy();

      _tailCopy4[i] = new Vector3();
      _tailCopy4[i] = rib._tail[i].copy();
    }

//    neb = new Nebula( loc, radius*0.5, false );
    
    numFrames = jellys._numFrames;
    animFrame = (int)random( 0, numFrames-1 );
    animFramef = animFrame;
  }

  void computeAndRender( float time )
  {
    draw( time );
    update( time );
  }
  
  void setTexture( int id )
  {
    //_particleTexID = id;
    _particleTexID = jellys._jellyAnim[animFrame].getId();
  }

  void draw( float time )
  {
    float depthAlpha = 0.75; //(pos.z/154.0);
    
    vgl.setAdditiveBlend();
    
    //
    // Draw the attached tails/ribbons
    //
    //rib.addHead( 0, cos(time*1.06)*6, sin(time*3.4)*8 );
    rib.setHead( pos.x, pos.y, pos.z );
    rib.updateJelly( time );
    if( _tailTexID > 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _tailTexID );
      rib._tailTexID = _tailTexID;
    }
    for( int i=0; i<_tailCopy.length; i++ )
    {
      _tailCopy[i] = rib._tail[i].copy();      
      _tailCopy2[i] = rib._tail[i].copy();
      _tailCopy3[i] = rib._tail[i].copy();
      _tailCopy4[i] = rib._tail[i].copy();

      // offseting tails
      float tailOffset = 1.94;
      _tailCopy[i].x += tailOffset;
      _tailCopy[i].z += tailOffset;
      _tailCopy2[i].x -= tailOffset;
      _tailCopy2[i].z -= tailOffset;
      _tailCopy3[i].x += tailOffset;
      _tailCopy3[i].z -= tailOffset;
      _tailCopy4[i].x -= tailOffset;
      _tailCopy4[i].z += tailOffset;

      float vel = rib._add.y + .21;
//      _tailCopy[i].x += cos(vel*-7*time+rib._head.y*.15) * i*0.1 * 1;
//      _tailCopy[i].z += cos(vel*-7*time+rib._head.y*.15) * i*0.1 * 1;
//      _tailCopy2[i].x += sin(vel*7*time+rib._head.y*.15) * i*0.1 * 1;
//      _tailCopy2[i].z += sin(vel*7*time+rib._head.y*.15) * i*0.1 * 1;
      _tailCopy[i].x += cos(vel*7*time+i*.01+index) * i*0.05 * 1;
      //_tailCopy[i].y -= vel;
      //_tailCopy[i].z += cos(vel*7*time+i*.01) * i*0.1 * 1;
      _tailCopy2[i].x -= cos(vel*7*time+i*.01+index) * i*0.05 * 1;
      //_tailCopy2[i].y -= vel;
      //_tailCopy2[i].z -= cos(vel*7*time+i*.01+index+2) * i*0.1 * 1;
      _tailCopy3[i].x -= cos(vel*7*time+i*.01+index) * i*0.05 * 1;
      //_tailCopy3[i].z -= cos(vel*7*time+i*.01+index+3) * i*0.1 * 1;
      _tailCopy4[i].x -= cos(vel*7*time+i*.01+index) * i*0.05 * 1;
      //_tailCopy4[i].z -= cos(vel*7*time+i*.01+index+4) * i*0.1 * 1;
    }
    //rib.draw( time );
    rib.renderTailFromBuffer( rib._tail, 1, depthAlpha );
    rib.renderTailFromBuffer( _tailCopy, 1, depthAlpha );
    rib.renderTailFromBuffer( _tailCopy2, 1, depthAlpha );
    rib.renderTailFromBuffer( _tailCopy3, 1, depthAlpha );
    rib.renderTailFromBuffer( _tailCopy4, 1, depthAlpha );

/*
    //
    // Render the original point NEBULA (grows on initial position)
    //
    if( _nebulaTexID >= 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _nebulaTexID );
    }
    neb.computeAndRender();
*/



    //
    // Render back "nebula" image
    //
    if( _nebulaTexID >= 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _nebulaTexID );
    }
    vgl.pushMatrix();
    vgl.translate( this.pos );
    glReverseCamera( jellys.eye, jellys.target );
    //vgl.rotateZ( time*20+age );
    vgl.fill( 1, 1-(0.3+0.2*sin(time*2.2+index+agePer)) );
//    gl.fill( 1, agePer*2 );
//    gl.fill( 1, agePer );
//    gl.fill( 1 - ffthelper.band[index*4%255]*5, agePer*2 );
    vgl.rect( radius*.5+time*0.05, radius*.3+time*.05 );
//    vgl.rect( radius*.4+time*0.5, radius*.2+time*.5 );
    vgl.popMatrix();


    //
    // Render the actual particle (jellyfish)
    //
    if( _particleTexID > 0 )
    {
      //vgl.gl().glDisable( GL.GL_CULL_FACE );
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _particleTexID );
    }
    
/***    float deltaX = this.oldPos.x - this.pos.x; 
    float deltaY = this.oldPos.y - this.pos.y; 
    float deltaZ = this.oldPos.z - this.pos.z; 
    angleEnd = degrees(atan2( deltaY, deltaX ));

    angleStart += (angleEnd-angleStart)*0.01;
    float angle = ((angleStart)+90)*3;
    if( angle < -30 ) angle = -30;
    if( angle > 30 ) angle = 30;***/

    vgl.pushMatrix();
    vgl.translate( pos.x, pos.y-radius*0.1, pos.z );
    glReverseCamera( jellys.eye, jellys.target );
//    vgl.rotateZ( angle );
    vgl.scale( 1, -1, 1 );
    vgl.fill( 1, (1-(0.3+0.2*sin(time*2.2+index+agePer)))*(1-(agePer*2)) );
    //vgl.fill( .96, 1-(agePer*4) ); //*0.1f );
//    gl.fill( .65, 1-agePer*2 ); //*0.1f );
//    gl.quad( radius *.5 + ffthelper.band[(index)%255]*5 );
//    gl.quad( radius *.5 );
    vgl.rect( radius*.5, radius*.4 );
    vgl.rect( radius*.5, radius*.4 );
    vgl.popMatrix();
    
  }


  void update( float time )
  {
    // keep track on last frame's position
    oldPos = pos.copy();

    // simple physics
    pos.add( _vel );
    _vel.add( _accel );
    _accel.mul( 0 );
//    _vel.mul( 0.95 );
    _vel.mul( 0.88 );//+ ffthelper.band[(index)%255]*0.1 );


    // add some noise to acceleration
    Vector3 noi = new Vector3();
//    noi.y = (-0.5 + noise( _vel.x*0.5, _vel.y*.03, time*0.01 )) * .5;

/*
    noi.x = (-0.5 + noise( pos.x*0.03, pos.y*0.1+pos.z*0.03, time*0.1)) * 2.499;
//    noi.x = (-0.5 + noise( pos.x*0.3, pos.y*0.1+pos.z*0.3, time*0.1)) * 2.499;
    noi.y = (-0.235 + noise( 10+pos.x*0.1, 100+pos.x*.01, time*1 )) * 1.495;
    noi.z = (-0.55 + noise( 10+pos.y*0.1, 100+pos.x*.01, time*1 )) * 1.495;
//    noi.z = -(-0.45 + noise( 10+pos.y*0.1, 100+pos.x*.01, time*1 )) * 1.495;
    noi.mul( 0.35 );*/
    noi.x = (-0.5 + noise( pos.x*0.03, pos.y*0.1+pos.z*0.03, time*0.1)) * 0.13;
//    noi.x = (-0.5 + noise( pos.x*0.3, pos.y*0.1+pos.z*0.3, time*0.1)) * 2.499;
    noi.y = (-0.235 + noise( 10+pos.x*0.1, 100+pos.x*.01, time*1 )) * 0.6; //0.65;
    noi.z = (-0.55 + noise( 10+pos.y*0.1, 100+pos.x*.01, time*1 )) * 1.8;
//    noi.z = -(-0.45 + noise( 10+pos.y*0.1, 100+pos.x*.01, time*1 )) * 1.495;
    noi.mul( 0.65 ); //0.85 );

    _accel.add( noi );

    // check for age
    age += 0.05;
/*    if( age < 0 )
    {
      ISDEAD = true;
      age = 0;
    }*/

//    if( pos.y > seaLevel )
    if( age > lifeSpan )
    {
      _isDead = true;
    } 
    else 
    {
      agePer = (age/(float)lifeSpan);
//      agePer = 1.0 - (age/(float)lifeSpan);
    }


    // Update animation frames
    animFramef += 0.2+abs(_vel.y*0.5); //0.5;
    animFrame = floor(animFramef);
    if( animFrame >= numFrames )
    {
      animFramef = 0.0f;
      animFrame = 0;
    }
  }
}
