class EmitterPlankton
{
  Vector3 loc;
  Vector3 vel;
  Vector3 accel;

  float radius;

  Vector3 myColor;

  ArrayList particles;
  int maxParticles;

  int _particleTexID;  

  FloatBuffer _planktonPos;
  FloatBuffer _planktonTexCoords;


  EmitterPlankton( Vector3 pos, int maxPoints )
  {
    loc        = pos;
    vel        = new Vector3();
    accel      = new Vector3();

    maxParticles = maxPoints;

    radius     = 30;

    myColor    = new Vector3( 1, 1, 1 );

    particles  = new ArrayList();

    int numberElements = 300 * 18;
    _planktonPos = BufferUtil.newFloatBuffer(numberElements);
//    _planktonPos.limit( numberElements );
    _planktonPos.rewind();
//    _planktonPos.flip();

    _planktonTexCoords = BufferUtil.newFloatBuffer(numberElements);
//    _planktonTexCoord.limit( numberElements );
    _planktonTexCoords.rewind();
  }

/*  void update( float time )
  {
    findAccel( time );
    vel.add( accel );
    accel.mul( 0 ); 
    vel.mul( 0.75 );
  }

  void findAccel( float time )
  {
    Vector3 noi = new Vector3();
    noi.x = (noise( time*0.1, cos(time*.25)*1, time*0.2 ) - 0.5) * 2;
    noi.y = (noise( time*0.1, sin(time*.25)*1, time*0.2 ) - 0.5) * 2;
    accel.add( noi );
  }*/
   
/*   void setPosition(){
   loc.addSelf( vel );
   
   if( ALLOWFLOOR ){
   if( loc.y > floorLevel ){
   loc.y = floorLevel;
   vel.y = 0;
   }
   }
   }*/

  void draw( float time )
  {
    int mylength = particles.size(); 

    // Set texture for all textures
    if( _particleTexID > 0 )
    {
      //vgl.gl().glDisable( GL.GL_CULL_FACE );
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _particleTexID );
    }

    for( int i=mylength-1; i>=0; i-- )
    { 
      ParticlePlankton p = ( ParticlePlankton )particles.get(i); 

      if ( !p._isDead )
      {
        p._particleTexID = _particleTexID;
        p.exist( time );
      }
      else
      {
        particles.set( i, particles.get( particles.size() - 1 ) );
        particles.remove( particles.size() - 1 );
      }
    }
  }


  void drawUsingVertexArray( float time )
  {
    if( _particleTexID > 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _particleTexID );
    }
//    vgl.gl().glDisable( GL.GL_FOG );
//    vgl.enableLighting( false );
//    vgl.enableTexture( false );
//    vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, 0 );

    int index = 0;
    int indextc = 0;
    boolean anyParticleDead = false;
    for( int i=0; i<particles.size(); i++ )
    {
      ParticlePlankton p = ( ParticlePlankton )particles.get( i ); 

      if( !p._isDead )
      {
        p._particleTexID = _particleTexID;
        //p.render( time );
        p.update( time );

          // create the particles shape
          float xs = p.radius*0.5;
          float ys = p.radius*0.5; //.25;
          
          // TRI 1
          _planktonPos.put( index+0, p.pos.x-xs );
          _planktonPos.put( index+1, p.pos.y+ys );
          _planktonPos.put( index+2, p.pos.z );
          _planktonPos.put( index+3, p.pos.x+xs );
          _planktonPos.put( index+4, p.pos.y+ys );
          _planktonPos.put( index+5, p.pos.z );
          _planktonPos.put( index+6, p.pos.x-xs );
          _planktonPos.put( index+7, p.pos.y-ys );
          _planktonPos.put( index+8, p.pos.z );
          _planktonTexCoords.put( indextc+0, 0 );
          _planktonTexCoords.put( indextc+1, 0 );
          _planktonTexCoords.put( indextc+2, 1 );
          _planktonTexCoords.put( indextc+3, 0 );
          _planktonTexCoords.put( indextc+4, 0 );
          _planktonTexCoords.put( indextc+5, 1 );
  
          // TRI 2
          _planktonPos.put( index+9, p.pos.x+xs );
          _planktonPos.put( index+10, p.pos.y+ys );
          _planktonPos.put( index+11, p.pos.z );
          _planktonPos.put( index+12, p.pos.x+xs );
          _planktonPos.put( index+13, p.pos.y-ys );
          _planktonPos.put( index+14, p.pos.z );
          _planktonPos.put( index+15, p.pos.x-xs );
          _planktonPos.put( index+16, p.pos.y-ys );
          _planktonPos.put( index+17, p.pos.z );
          _planktonTexCoords.put( indextc+6, 1 );
          _planktonTexCoords.put( indextc+7, 0 );
          _planktonTexCoords.put( indextc+8, 1 );
          _planktonTexCoords.put( indextc+9, 1 );
          _planktonTexCoords.put( indextc+10, 0 );
          _planktonTexCoords.put( indextc+11, 1 );
  
          index += 18; // 6 vertices of 3 components = 18      
          indextc += 12;   // 6 vertices of 2 components = 12
        
      }
      else
      {
        //particles.set( i, particles.get( particles.size() - 1 ) );
        //particles.remove( particles.size() - 1 );
        //anyParticleDead = true;
        p.reset( random(250, 380), random(-200, -300), random(0, 200) );
      }
    }

    _planktonPos.rewind();
    _planktonTexCoords.rewind();
    vgl.gl().glEnableClientState( GL.GL_VERTEX_ARRAY );
    vgl.gl().glEnableClientState( GL.GL_TEXTURE_COORD_ARRAY ); 
    vgl.gl().glVertexPointer( 3, GL.GL_FLOAT, 0, _planktonPos );
    vgl.gl().glTexCoordPointer( 2, GL.GL_FLOAT, 0, _planktonTexCoords );
    vgl.gl().glDrawArrays( GL.GL_TRIANGLES, 0, particles.size()*2*3 );
    vgl.gl().glDisableClientState( GL.GL_VERTEX_ARRAY );
    vgl.gl().glDisableClientState( GL.GL_TEXTURE_COORD_ARRAY ); 
  }

/*  void render()
  {
    flare3.enable();
    
    gl.pushMatrix();
    gl.translate( loc );
    glReverseCamera( eye, target );
    gl.fill( 1 ); //myColor.x, myColor.y, myColor.z, 1 );
    gl.quad( radius );
    gl.popMatrix();    

    flare3.disable();
  }*/

  /*  void renderReflection(){
   float altitude           = floorLevel - loc.y;
   float reflectMaxAltitude = 300.0;
   float yPer               = 1.0 - altitude/reflectMaxAltitude;
   
   if( yPer > .05 )
   renderImageOnFloor( new Vec3D( loc.x, floorLevel, loc.z ), radius * 10.0, color( 0.5, 1.0, yPer*.25 ), yPer );
   
   if( mousePressed )
   renderImageOnFloor( new Vec3D( loc.x, floorLevel, loc.z ), radius + ( yPer + 1.0 ) * radius * random( 2.0, 3.5 ), color( 1.0, 0, 0 ), yPer );
   }
   
   void iterateListRenderTrails()
   {
   for( Iterator it = particles.iterator(); it.hasNext(); )
   {
   Particle p = (Particle) it.next();
   p.renderTrails();
   }
   }*/

/*
  void addParticles( int _amt )
  {
    //Vector3 v = new Vector3(random(-.52, .52), random(-.2, .2), 0);

    for( int i=0; i<_amt; i++ )
    {
      particles.add( new ParticlePlankton( 1, loc, vel ) );
    }

    //    if( ALLOWNEBULA ){
    //      nebulae.add( new Nebula( loc, 40.0, false ) );
    //      nebulae.add( new Nebula( loc, 100.0, false ) );
    //    }
  }
*/
  void addParticle( Vector3 pos )
  {
    particles.add( new ParticlePlankton( 1, pos, vel ) );
  }

/*
  void addParticles( ParticlePlankton _p )
  {
    // play with amt if you want to control how many particles spawn when splitting
    int amt = (int)( _p.radius * .15 );
    for( int i=0; i<amt; i++ )
    {
      particles.add( new ParticlePlankton( _p.gen + 1, _p.pos, _p._vel ) );

      //      particles.add( new Particle( _p.gen + 1, _p.loc[0], _p.vel ) );
      //      if( ALLOWNEBULA )
      //        nebulae.add( new Nebula( _p.loc[0], random( 5.0, 50.0 ), true ) );
    }
  }*/
}
