import java.util.Collections;  
import java.util.ArrayList;  
import java.util.Comparator; 


class CylinderRoll
{
  CylinderRoll()
  {
    minNoise = 0.499;
    maxNoise = 0.501;
    
    _doRenderHead = true;
    _doUpdate = true;

    _tailSize = 100;
    _tailRenderSegments = 0;
    _tailWidth = 11.0;

    _initPos = new Vector3();
    
    _headSize = 8*3;
    _head = new Vector3();
    _target = new Vector3();
    _right = new Vector3();

    _usePerlin = false;
    _perlin = new Vector3();
    
    _add = new Vector3();
    
    _damp = 0.95;

    _age = 0;
    _agePer = 0;
    _timeToLive = 100;
    _invTimeToLive = 1.0 / _timeToLive;
    
    _facets = 5;
    
    _colour = new Vector4( 1, 1, 1, 1 );
    
    _flowerCount = 0;
    _numFlowers = 20;
    _flowers = new ArrayList();
    _flowersSizeValue = new ArrayList();
    _flowersDir = new ArrayList();

    _dispoffset = 0;
    _displaces = 0;
    _dispscale = 9;
  }

  CylinderRoll( int tailSize, float tailWidth, float headSize, boolean renderHead )
  {

    _doRenderHead = renderHead;
    _doUpdate = true;

    _tailSize = tailSize;
    _tailRenderSegments = 0;
    _tailWidth = tailWidth;

    _initPos = new Vector3();

    _headSize = headSize;
    _head = new Vector3();
    _target = new Vector3();
    _right = new Vector3();

    _usePerlin = false;
    _perlin = new Vector3();
    
    _add = new Vector3();    

    _damp = 0.95;

    _age = 0;
    _agePer = 0;
    _timeToLive = 100;
    _invTimeToLive = 1.0 / _timeToLive;

    _colour = new Vector4( 1, 1, 1, 1 );

    _facets = 8;
    
    _dispoffset = 0;
    _displaces = 0;
    _dispscale = 9;
  }
  
  float getRads(float val1, float val2, float mult, float div)
  {
    float rads = noise(val1/div, val2/div, frameCount/div );
    
    if (rads < minNoise) minNoise = rads;
    if (rads > maxNoise) maxNoise = rads;
    
    rads -= minNoise;
    rads *= 1.0/(maxNoise - minNoise);
  
    return rads * mult;
  }


  void setCylinderDetail( int d )
  {
    _facets = d;
  }
  
  void setCylinderRadius( int r )
  {
    _tailWidth = r;
  }   

/*  void loadHeadTexture( String file )
  {
    _headTex = new XTexture( file );
  }*/

  void findPerlin()
  {
    float xyRads = getRads( _head.x, _head.z, 5.0, 15.0 );
    float yRads = getRads( _head.x, _head.y, 5.0, 15.0 );
//    _perlin.set( cos(xyRads), sin(yRads), sin(xyRads) );

//    _perlin.set( cos(1.2*xyRads), sin(4*yRads), sin(1.2*xyRads) );
//    _perlin.mul( 2.85 );

    _perlin.set( cos(5.2*xyRads), sin(4*yRads), sin(5.2*xyRads) );
    _perlin.mul( 2.85 );

//    _perlin.set( cos(10.2*xyRads), sin(4*yRads), sin(10.2*xyRads) );
//    _perlin.mul( 2.85 );
  }

  void computeTail()
  {
    if( _tail == null )
    {
      _tail = new Vector3[_tailSize];
    }

    for( int i=0; i<_tailSize; i++ )
    {
      _tail[i] = new Vector3();
      _tail[i] = _head.copy();
    }

    yTable = new int[_tailSize];
    for( int i=0; i<_tailSize; i++ )
      yTable[i] = i * (_facets+1);
    _vertices = new Vector3[ ((_tailSize)*(_facets+1)) ];
    _normals = new Vector3[ ((_tailSize)*(_facets+1)) ];
    _texcoords = new Vector3[ ((_tailSize)*(_facets+1)) ]; 
    for( int i=0; i<((_tailSize)*(_facets+1)); i++ )
    {
      _vertices[i] = new Vector3();
      _normals[i] = new Vector3();
      _texcoords[i] = new Vector3(); 
    }
  }
  

  boolean isDead()
  {
    if( _age >= _timeToLive )
      return true;

    return false;
  }

  void setTailSize( int t )
  {
    _tailSize = t;
    computeTail();
  }

  void setTimeToLive( float t )
  {
    _timeToLive = t;
    _invTimeToLive = 1.0 / _timeToLive;
  }

  void setHeadY( float y )
  {
    _head.y = y;
    _initPos = _head.copy();
  }

  void setHead( float x, float y )
  {
    _head.set( x, y, 0 );
    _initPos = _head.copy();
    _target = _head.copy();
  }

  void setHead( float x, float y, float z )
  {
    _head.set( x, y, z );
    _initPos = _head.copy();
  }

  void setHead( Vector3 h )
  {
    _head = h;
    _initPos = _head.copy();
  }

  void addHead( float x, float y )
  {
    //if( _doUpdate )
    if( !_usePerlin )
    {
      _head.add( x, y, 0 );
    }
  }

  void addHead( float x, float y, float z )
  {
    //if( _doUpdate )
    if( !_usePerlin )
    {
      _head.x += x;
      _head.y += y;
      _head.z += z;
    }
  }

  void addHead( Vector3 a )
  {
    //if( _doUpdate )
    if( !_usePerlin )
    {
      _head.add( a );
    }
  }

  void renderHead( boolean f )
  {
    _doRenderHead = f;
  }


  void update( float time )
  {
    if( _age < _timeToLive )
    {
      if( _tailRenderSegments < _tailSize )
      {        
//        for( int i=_tailSize-1; i>0; i-- )
        for( int i=_tailRenderSegments; i>0; i-- )
        {
          _tail[i] = _tail[i-1];
        }
        _tail[0] = _head.copy();
        _tailRenderSegments++;
      }
      else
      {
        _doUpdate = false;
      }
    }

    if( _usePerlin )
    {
/*      findPerlin();
      _add.add( _perlin );
      _head.add( _add );
      _add.mul( _damp );*/
      
      float target_distance = 200.0;
      float redirect_distance = 60.0;
      float d = Vector3.distance( _head, _target );//dist( _head.x, _head.y, _head.z, tx, ty, tz );
      if( d < target_distance )
      {
        _target.x += random(-redirect_distance, redirect_distance);
        _target.y += random(-redirect_distance, redirect_distance);
        _target.z += random(-redirect_distance, redirect_distance);
        //tx = global.constrainX(tx);
        //ty = global.constrainY(ty);
        //tz = 0;
      }
      _add.x += (_target.x-_head.x) * 0.002;
      _add.y += (_target.y-_head.y) * 0.002;
      _add.z += (_target.z-_head.z) * 0.002;
      _add.mul( 0.97 );
      _head.add( _add );      
    }
    else
    {
      if( _doUpdate) 
        _head.add( _add );
    }
    
    _age ++;
    _agePer = _age * _invTimeToLive;
  }


  void draw( float time )
  {
    if( _age < _timeToLive )
    {
/*      if( _doRenderHead )
      {
        _headTex.enable();
        renderHead();
        _headTex.disable();
      }*/

/*      vgl.gl().glDisable( GL.GL_CULL_FACE );
      vgl.setDepthWrite( true );
//      vgl.setDepthMask( false );
      vgl.setAlphaBlend();*/

//      renderTail();      
      renderTailCylinder();


      // Stop head motion once it completes its growth      
      if( !_doUpdate )
        _head = _tail[0].copy();


      // Render base of each tail (not needed for most cases)
//      renderBase();
    }
  }

  void drawCylinder( float time )
  {
    if( _age < _timeToLive )
    {
      vgl.gl().glDisable( GL.GL_CULL_FACE );
      vgl.setDepthWrite( true );
//      vgl.setDepthMask( false );
      vgl.setAlphaBlend();
      
      renderTailCylinder();
    }
  }

  void renderBase()
  {
/*    activeNoteTex.enable();

    // Draw activator center 
    vgl.setAlphaBlend();
    vgl.fill( 1, 1.0-_agePer );
    vgl.pushMatrix();
    vgl.translate( _initPos );
    vgl.rotateX( 90 );
    vgl.quad( 20 );
    vgl.popMatrix();

    activeNoteTex.disable();*/
  }


  void renderHead()
  {
    // Draw activator center 
    vgl.setDepthWrite( false );
    vgl.setAlphaBlend();
    //activeNoteTex.enable();
    vgl.fill( 1, 1.0-_agePer );
    vgl.pushMatrix();
    vgl.translate( _head.x, _head.y, _head.z );
    vgl.rotateX( 90 );
    vgl.quad( _headSize );
    vgl.popMatrix();

    vgl.setDepthWrite( true );
  }


  void renderTail( float time )
  {
    float per;
    float xp, yp, zp;
    float xOff, yOff, zOff;

    ///////////////////////////////////////
    ///////////////////////////////////////
    vgl.gl().glBegin( GL.GL_QUAD_STRIP );
    for ( int i=0; i<_tailSize-1; i++ )
    {
      per           = (((float)i/(float)(_tailSize))); // ratio
//      per           = 1.0-(((float)i/(float)(_tailSize)));

      per *= 1.5;

      {
        Vector3 dir = Vector3.sub( _tail[i+1], _tail[i] );
        dir.normalize();
        Vector3 V = dir.cross( new Vector3( 0, 1, 0 ) );
        V.normalize();
        Vector3 U = dir.cross( V );
        U.normalize();
        V = U.cross( dir );
        V.normalize();
        
        _right = V.copy();

//        xp = _tail[i].x;
//        yp = _tail[i].y;
//        zp = _tail[i].z;
        xp = _tail[i].x + _right.x*sin(i*.2+time*8)*3*(_tailSize-i)*.053;
        yp = _tail[i].y - 30;// + _right.y*sin(i*.2+time*8)*3*(_tailSize-i)*.053;
        zp = _tail[i].z + _right.z*sin(i*.2+time*8)*3*(_tailSize-i)*.053;
        

        xOff = V.x * _tailWidth * per;
        yOff = V.y * _tailWidth * per;
        zOff = V.z * _tailWidth * per;

        vgl.gl().glColor4f( 0, 0, 0, 1-_agePer );
        vgl.gl().glVertex3f( xp - xOff, yp - yOff, zp - zOff );
        vgl.gl().glVertex3f( xp + xOff, yp + yOff, zp + zOff );
      }
    }
    vgl.gl().glEnd();
  }


  void transformRect( Vector3 up, Vector3 V, Vector3 offset, Vector3[] rect ) 
  {
	for( int i=0; i<4; i++ )
	{
		Vector3 v = rect[i];
		Vector3 P = new Vector3( v.x, v.y, v.z );

		Vector3 NY = up.copy();
		NY.normalize();
		Vector3 NV = V.copy();
		NV.normalize();

		Vector3 N = NY.cross( NV );	// axis of rotation
		N.normalize();

		float dot = NY.dot( NV );	// cos angle
		float rad = ( acos(dot) );	// angle of rotation (radians)

		// quat from an angle and a rotation axis
		Quaternion quat = new Quaternion();

		quat.rotateAxis( N, rad );
//                Vector3 axis = Vector3.sub( N, NY );
//		quat.rotateAxis( axis, rad );

		// transform vertex
		Vector3 dv = quat.mul( P );

		v.set( dv );
                // translate to right position
                
//                Vector3 disp = N.copy();
//                disp.mul( _tailWidth*0.125 );
//                offset.add( disp );
                
		v.add( offset );
	}
  }

  void renderTailCylinder()
  {
    float invsteps = 1.0 / (float)(_tailSize-1);
    float invfacets = 1.0 / (float)(_facets);

    float pi2OverSteps = TWO_PI / (_tailSize-1);
    float pi2OverFacets = TWO_PI / _facets;
    float pi2MulInvsteps = TWO_PI * invsteps;
    float pi2MulInvfacets = TWO_PI * invfacets;

//    float _p = 5;
//    float _q = 5;
//    float _scale = 20;
//    float _thickness = 10;


    ///////////////////////////////////////////////////////////
    // Draw vine mesh
    ///////////////////////////////////////////////////////////

//    int hlen = (int)((_tailSize-1)*0.5);
//    for( int jj=-hlen; jj<hlen; jj++ )    
//    for ( int j=0; j<_tailSize-1; j++ )
    for ( int j=0; j<_tailRenderSegments-1; j++ )
    {
//      int j = jj+hlen;

/*      // draw textured quads along the path
      activeNoteTex.enable();
      // Draw activator center 
      vgl.setAlphaBlend();
      vgl.setDepthWrite( false );
      vgl.fill( .3 );//, 1.0-_agePer );
      vgl.pushMatrix();
      vgl.translate( _tail[j].x, _tail[j].y, _tail[j].z );
//      vgl.rotateX( 90 );
      vgl.quad( 15 );
      vgl.popMatrix();
      activeNoteTex.disable();*/

      float per = 0.0;
//      per = 1.0 - (((float)(abs(jj))/(float)(hlen)));
//      per = 1.0-(((float)(j)/(float)(_tailSize)));
//      per = j / (float)_tailRenderSegments; //_tailSize;
  
    
      float dthd1 = 10;
      float th = _tailWidth;
      float dthd2 = _tailSize;
      float dthm = 1 * _tailWidth;
      
/*      if( j < 10 )
      {
        per = 1.0-(dthm-min(dthm*(j)/dthd1,dthm)); //(dthm-min(dthm*(min(_tailSize,_tailRenderSegments)-(j))/dthd2,dthm));
        per = max( per, 0 );
      }
      else    */  
      {
        per = (dthm-min(dthm*(min(_tailSize,_tailRenderSegments)-(j))/dthd2,dthm));
        //per = max( per, 0 );
      }


      // first point
      Vector3 center = new Vector3();
      center = _tail[j];//.copy();

      // next point
      Vector3 nextPoint = new Vector3();
      nextPoint = _tail[j+1];//.copy();

      // get TBN matrix for transformation
      Vector3 T = new Vector3();
      T.x = nextPoint.x - center.x;
      T.y = nextPoint.y - center.y;
      T.z = nextPoint.z - center.z;
      T.normalize();

      Vector3 N = new Vector3(0,1,0); // use vector on y axis. it should work just fine here

      Vector3 B = T.cross( N );
      B.normalize();
      N = B.cross( T );

      // normalize vectors
      B.normalize();
      N.normalize();

      if( j == 0 )
      {
        _right = N.copy();
      }

      // go through facets and tweak a bit with some distortions
      for( int i=0; i<_facets+1; i++ )
      {
        float x = (sin(i * pi2OverFacets) * per);
        float y = (cos(i * pi2OverFacets) * per);        
//        float x = (sin(i * pi2OverFacets) * _tailWidth * per);
//        float y = (cos(i * pi2OverFacets) * _tailWidth * per);
        // distort knot along the curve
        if( _displaces != 0.0 )
        {
          x *= (1 + (sin(_dispoffset + _displaces * j * pi2OverSteps) * _dispscale));
          y *= (1 + (cos(_dispoffset + _displaces * j * pi2OverSteps) * _dispscale));
        }

        int idx = yTable[j] + i;
        _vertices[ idx ].x = N.x * x + B.x * y + center.x;
        _vertices[ idx ].y = N.y * x + B.y * y + center.y;
        _vertices[ idx ].z = N.z * x + B.z * y + center.z;

        _texcoords[ idx ].x = ((float)i / (float)_facets) * 1;
        _texcoords[ idx ].y = ((float)(j) / (float)_tailRenderSegments) * 10; 
//        _texcoords[ idx ].y = ((float)(j-_tailSize) / (float)_tailSize) * 10; 
//        _texcoords[ idx ].y = ((float)j / (float)_tailSize-1) * 10; 
        
        // get vertex normal
        _normals[ idx ].x = _vertices[ idx ].x - center.x;
        _normals[ idx ].y = _vertices[ idx ].y - center.y;
        _normals[ idx ].z = _vertices[ idx ].z - center.z;
        // normalize
        _normals[ idx ].normalize();
      }

      // duplicate sideways vertices/normals
      int idxSrc = yTable[j] + 0;
      int idxDest = yTable[j] + _facets;

      _vertices[ idxDest ].x = _vertices[ idxSrc ].x;
      _vertices[ idxDest ].y = _vertices[ idxSrc  ].y;
      _vertices[ idxDest ].z = _vertices[ idxSrc ].z;
      _texcoords[ idxDest ].x = _texcoords[ idxSrc ].x;
      _texcoords[ idxDest ].y = _texcoords[ idxSrc ].y;
      _normals[ idxDest ].x = _normals[ idxSrc ].x;
      _normals[ idxDest].y = _normals[ idxSrc ].y;
      _normals[ idxDest ].z = _normals[ idxSrc ].z;
    }


    // Increase color as it grows
//    _colour.x += 0.01;
//    _colour.y += 0.01;
//    _colour.z += 0.01;

    vgl.enableLighting( false );
    vgl.enableTexture( false );
/*    CGpass pass = diffuseSpecularCG.getTechniqueFirstPass( "Technique_Diffuse" );
    while( pass != null ) 
    {
      CgGL.cgSetPassState( pass );     

      diffuseSpecularCG.setTextureParameter( "ColorSampler", hll4.getId() );
      diffuseSpecularCG.setParameter3f( "lightPos", lightPos );
      diffuseSpecularCG.setParameter3f( "cameraPos", eye );
      diffuseSpecularCG.setParameter4x4f( "WorldViewProjection", CgGL.CG_GL_MODELVIEW_PROJECTION_MATRIX, CgGL.CG_GL_MATRIX_IDENTITY );
      diffuseSpecularCG.setParameter4x4f( "World", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_INVERSE_TRANSPOSE );
*/

      int j = 0;
      float umul= 1;
      float vmul = 10;
      float u, v1, v2;
      v1 = vmul*j * invsteps;
      v2 = vmul*(j+1) * invsteps;

/*      vgl.gl().glBegin( GL.GL_TRIANGLE_STRIP );
      for( int i=0; i<_facets+1; i+=1 )
      {
        u = umul*i * invfacets; 

        vgl.gl().glColor4f( _colour.x, _colour.y, _colour.z, 1.0 );//-_agePer );
//        vgl.gl().glColor4f( _colour.x-_agePer, _colour.y-_agePer, _colour.z-_agePer, 1 );//-_agePer );

        vgl.gl().glNormal3f( _normals[yTable[j]+i].x, _normals[yTable[j]+i].y, _normals[yTable[j]+i].z );
        vgl.gl().glTexCoord2f( u, v1 ); 
        vgl.gl().glVertex3f( _vertices[yTable[j]+i].x, _vertices[yTable[j]+i].y, _vertices[yTable[j]+i].z );

        vgl.gl().glNormal3f( _normals[yTable[j+1]+i].x, _normals[yTable[j+1]+i].y, _normals[yTable[j+1]+i].z );
        vgl.gl().glTexCoord2f( u, v2 );         
        vgl.gl().glVertex3f( _vertices[yTable[j+1]+i].x, _vertices[yTable[j+1]+i].y, _vertices[yTable[j+1]+i].z );
      }      
      vgl.gl().glEnd();*/

//    for ( j=0; j<_tailSize-2; j++ )
    for ( j=0; j<_tailRenderSegments-2; j++ )
    {
//      v1 = vmul*j / (float)_tailRenderSegments;//* invsteps;
//      v2 = vmul*(j+1) / (float)_tailRenderSegments;// * invsteps; 

      vgl.gl().glBegin( GL.GL_TRIANGLE_STRIP );
      for( int i=0; i<_facets+1; i++ )
      {
//        u = umul*i * invfacets; 

        vgl.gl().glColor4f( _colour.x, _colour.y, _colour.z, 1 );//1-noiseAmp );
//        vgl.gl().glColor4f( _colour.x-_agePer, _colour.y-_agePer, _colour.z-_agePer, 1 );//-_agePer );

        vgl.gl().glNormal3f( _normals[yTable[j]+i].x, _normals[yTable[j]+i].y, _normals[yTable[j]+i].z );
//        vgl.gl().glTexCoord2f( u, v1 ); 
        vgl.gl().glTexCoord2f( _texcoords[yTable[j]+i].x, _texcoords[yTable[j]+i].y ); 
        vgl.gl().glVertex3f( _vertices[yTable[j]+i].x, _vertices[yTable[j]+i].y, _vertices[yTable[j]+i].z );

        vgl.gl().glNormal3f( _normals[yTable[j+1]+i].x, _normals[yTable[j+1]+i].y, _normals[yTable[j+1]+i].z );
//        vgl.gl().glTexCoord2f( u, v2 );         
        vgl.gl().glTexCoord2f( _texcoords[yTable[j+1]+i].x, _texcoords[yTable[j+1]+i].y ); 
        vgl.gl().glVertex3f( _vertices[yTable[j+1]+i].x, _vertices[yTable[j+1]+i].y, _vertices[yTable[j+1]+i].z );
      }      
      vgl.gl().glEnd();
    }

//      CgGL.cgResetPassState( pass );
//      pass = CgGL.cgGetNextPass( pass );
//    }     

  }


  void reset( Vector3 newPos, float ttl )
  {
    setHead( newPos );
    computeTail();
    setTimeToLive( ttl );
    _tailRenderSegments = 0;
    _age = 0;
    _doUpdate = true;  
    
    if( random(100) > 50 )
      _colour.set( 1, 1, 1, 1 );
    else
      _colour.set( 0, 0, 0, 1 );

  }

  float minNoise, maxNoise;
 
  int _facets;
  int[] yTable;
  Vector3[] _vertices;
  Vector3[] _texcoords; 
  Vector3[] _normals;
  
//  XTexture _headTex;
  
  Vector4  _colour;

  boolean _doRenderHead;
  boolean _doUpdate;

  float _age;
  float _agePer;
  float _timeToLive;
  float _invTimeToLive;

  Vector3 _initPos;
  
  float _headSize;
  Vector3 _head;
  Vector3 _right;
  Vector3 _target;

  Vector3  _add;
  
  float _damp;
  
  boolean _usePerlin;
  Vector3 _perlin;
  
  float _dispoffset;
  float _displaces;
  float _dispscale;
  

  float _tailWidth;
  int  _tailRenderSegments;    // counts number of tail segments to render  
  int  _tailSize;
  Vector3[] _tail;

  int _flowerCount;
  int _numFlowers;
  ArrayList _flowers;
  ArrayList _flowersSizeValue;
  ArrayList _flowersDir;
}

