; Shrink.asm
; This fairly uninspiring function takes a "screenshot"
; then shrinks it away on a preset background colour.
; Makes a more interesting transition than a hard cut.

.module Shrink
.using noname
.varloc variable_free, free_space
_scale_rate_a = 96
Shrink
	ld (_exit_colour+1),a
	call take_screenshot
	ld hl,plotSScreen
	ld de,saveSScreen
	ld bc,768
	ldir
	
	ld a,96
	ld (_size_count+1),a

_loop

_size_count
	ld a,32
	
	ld b,a
	srl b
	srl b
	srl b
	srl b
	jr nz,{+}
	ld b,1
+

	sub b
	jr nz,{+}
	ret
+
	ld (_size_count+1),a
	

	ld (_final_size_a+1),a
	ld (_final_size_b+1),a	

	
	; To get the start row, we need to perform the calculation:
	; Total height = (size * 64) / 96
	; Half height = total height / 2
	; Top = 32 - half height
	; Therefore, top = 32 - (size * 64) / 192
	; Adjust... 
	; top = 32 - (size * 86) / 256
	
	; So, size * 86... 64+16+4+2
	; (Thinking aloud, sorry).
	
	ld l,a
	ld h,0
	add hl,hl
	push hl ; *2
	add hl,hl
	push hl ; *4
	add hl,hl
	add hl,hl
	push hl ; *16
	add hl,hl
	add hl,hl
	pop de
	add hl,de
	pop de
	add hl,de
	pop de
	add hl,de
	
	ld a,32
	sub h
	
	; A is our start height...
	call a_times_12	
	
	; hl->start of scanline
	; We need to shunt HL along a few columns to accomodate the X-centre-ing as well.
	
	ld a,(_size_count+1)
	ld b,a
	ld a,96
	sub b
	srl a
	ld b,a	; We'll need it in a minute
	srl a
	srl a
	srl a
	ld e,a
	ld d,0
	add hl,de
	ld de,plotSScreen
	add hl,de
	ld (_start_row+1),hl
	
	; We put a->b, and we do indeed need it!
	; We need to preload the destination bitmask, as %10000000 will always start
	; in pixel 0 of the byte-- if we are to fine-scroll the horizontal centre, we need
	; to shunt it along a few pixels first.
	
	ld a,b
	and 7
	ld b,%10000000
	
	or a
	jr z,{+}
-	srl b
	dec a
	jr nz,{-}
+	ld a,b
	ld (_start_fine+1),a
	
_exit_colour
	ld a,0
	ld hl,plotSScreen
	ld bc,768
	bcall(_MemSet)


	ld de,saveSScreen
	ld ixh,64
	
_horiz_counter_primer
	ld a,_scale_rate_a
	ld (_horiz_counter+1),a

_render_next_scanline
_start_row
	ld hl,0

_start_fine
	ld b,%01000000	; Dest
	ld c,%10000000	; Source
	
_scale_counter_primer	
	ld a,_scale_rate_a
	ld (_scale_counter+1),a

	
	ld ixl,12
	
--

	ld a,(de)
	and c
	jr z,{+}
	ld a,(hl)
	or b
	ld (hl),a
	jr _pixel_set
+
	ld a,b
	cpl
	and (hl)
	ld (hl),a
_pixel_set

_scale_counter
	ld a,0
	sub _scale_rate_a
	jp p,_no_advance_source
	

-	; Skip source
	srl c
	jr nc,{+}
	ld c,%10000000	
	inc de
	
	dec ixl
	jr z,_done_scanline
_final_size_a
+	add a,0
	jp m,{-}

_no_advance_source
	ld (_scale_counter+1),a

	; Skip dest
	srl b
	jr nc,{+}
	ld b,%10000000
	inc hl
+
	jp {--}
	
_done_scanline
	
	ld bc,12
	ld hl,(_start_row+1)
	add hl,bc
	ld (_start_row+1),hl
	
	ld h,d
	ld l,e	
	
	ld bc,-12
	add hl,bc
	ld bc,12
	
_horiz_counter
	ld a,0
	sub _scale_rate_a
-	add hl,bc
	dec ixh
	jr z,_done_frame
_final_size_b
	add a,0
	jp m,{-}

_no_advance_horiz
	ld (_horiz_counter+1),a
	ld d,h
	ld e,l
	jp _render_next_scanline

_done_frame
	
	call ionFastCopy
	
	ld a,(_scale_counter+1)
	ld (_scale_counter_primer+1),a
	ld a,(_horiz_counter+1)
	ld (_horiz_counter_primer+1),a

	call scene_countdown
	jp _loop
	
.endmodule