; Lens.asm
; The distortion technique used can be modified (by
; altering the transformation table) to perform
; a variety of interesting effects.

; Revision 1: Reduced the look-up table to an eighth (!)
; of the original size, added key presses.

.module Lens
.using noname
.varloc variable_free, free_space
.var 32*8, _old_value
.var 1,_lens_ry
.var 1,_lens_dy
.var 1,_lens_y
.var 1,_lens_rx
.var 1,_lens_dx
.var 1,_lens_x
.var 12*8*2,_copy_in
.var 1,_copy_in_index
.var 1,_copy_in_timer
.var 1,_image_index
_image_delay = 128

Lens
	call take_screenshot
	ld hl,plotSScreen


	xor a
	ld (_image_index),a

	ld a,12*8
	ld (_copy_in_index),a
	
	ld a,_image_delay
	ld (_copy_in_timer),a

	
	ld hl,plotSScreen
	ld ix,_copy_in
	ld de,12*7
	ld a,8
--	ld b,12
-	ld (ix+0),l
	ld (ix+1),h
	inc ix
	inc ix	
	inc hl
	djnz {-}
	add hl,de
	dec a
	jr nz,{--}
	
	call _shuffle_intro

	ld b,(96-33)*2
	call ionRandom
	ld (_lens_rx),a
	srl a
	ld (_lens_x),a
	
	ld b,(64-33)*2
	call ionRandom
	ld (_lens_ry),a
	srl a
	ld (_lens_x),a
	
	ld a,3
	ld (_lens_dx),a
	ld a,2
	ld (_lens_dy),a
_loop

	; Do we need to copy in a new tile of our background image?

	ld ixl,3
--
	ld a,(_copy_in_index)
	cp 12*8
	jp z,_no_tile_to_copy
	ld l,a
	ld h,0
	inc a
	ld (_copy_in_index),a
	add hl,hl
	ld de,_copy_in
	add hl,de
	ld e,(hl)
	inc hl
	ld d,(hl)
	; de->dest
	ld hl,saveSScreen-plotSScreen
	add hl,de
	; hl->source
	ld b,8	
-	ld a,(hl)
	ld (de),a
	push de
	ld de,12
	add hl,de
	pop de
	push hl
	ld hl,12
	add hl,de
	ld d,h
	ld e,l
	pop hl
	djnz {-}
	dec ixl
	jp nz,{--}
	jp _am_copying_in_new_image

_no_tile_to_copy


	ld a,(_copy_in_timer)
	dec a
	ld (_copy_in_timer),a
	jp nz,_am_copying_in_new_image

	; We must preload a new image!
	xor a
	ld (_copy_in_index),a
	ld a,(_image_index)
	inc a
	cp 3
	jr nz,{+}
	xor a
+	ld (_image_index),a
	ld l,a
	ld h,0
	add hl,hl
	ld de,_images
	add hl,de
	ld e,(hl)
	inc hl
	ld d,(hl)
	ld hl,saveSScreen
	ex de,hl
	ld bc,768
	call disprlel
	ld a,_image_delay
	ld (_copy_in_timer),a
	call _shuffle_intro

_am_copying_in_new_image

	; Move the lens
	
	ld ix,_lens_rx
	ld b,(96-32)*2
	call _move_lens

	ld ix,_lens_ry
	ld b,(64-32)*2
	call _move_lens
		
	; Preload the x-offset fine scroll
	ld b,%10000000
	ld hl,13-4
	ld a,(_lens_x)
	and 7
	ld (_copy_lens_fine_offset_a+1),a
	ld (_copy_lens_fine_offset_b+1),a	
	jp z,{+}
	ld hl,12-4
-	srl b
	dec a
	jp nz,{-}
+	ld a,b
	ld (_destination_preload+1),a
	ld (_row_advancer+1),hl
	
	; Take the area around the lens and save it away:
	
	ld a,(_lens_y)
	call a_times_12
	ld de,plotSScreen
	add hl,de
	ld a,(_lens_x)
	srl a
	srl a
	srl a
	ld e,a
	ld d,0
	add hl,de
	push hl	; IMPORTANT!
	push hl
	
		ld de,_old_value
		ld a,32
-		ld bc,8
		ldir
		ld bc,12-8
		add hl,bc
		dec a
		jp nz,{-}
	
		; Copy it back on to the display, warping it:
	
	pop hl
	

	ld bc,17
	ld (_row_increment+1),bc
	
	ld a,$D2 ; JP NC
	ld (_adjust_y_offset),a
	
	ld de,_transformation
	ld ixh,32	
_draw_next_lens_row

	ld a,$13 ; INC DE
	ld (_horiz_mirror),a
	ld a,$D2 ; JP NC
	ld (_adjust_x_offset),a

	ld ixl,32
_destination_preload
	ld b,%10000000 ; Destination
_next_lens_pixel
	ld a,(de)

; NEW----------
	; a = y << 4
	and $F0
	srl a
_adjust_y_offset
	jp c,{+}
	srl a
	srl a
	srl a
	neg
	add a,31
	add a,a
	add a,a
	add a,a
+
	ld c,a
; ----------NEW

; OLD----------
	; a = y
;	add a,a
;	add a,a
;	add a,a
;	ld c,a
;	inc de
; ----------OLD

	ld a,(de)
	
; NEW----------
	and $0F
_adjust_x_offset
	jp c,{+} ; Carry flag will ALWAYS be cleared!
	neg
	add a,31
+
	ld (_adjusted_x_offset+1),a
; ----------NEW

_copy_lens_fine_offset_a
	add a,3
	
	; a = x
	srl a
	srl a
	srl a
	add a,c
	; a = offset into sprite
	
	push bc
		push hl
			ld hl,_old_value
			
			ld b,0
			ld c,a
			add hl,bc
			; hl->transformed source byte.
			ld b,%10000000
			; OLD----------
			ld a,(de)
			; ----------OLD
			; NEW----------
_adjusted_x_offset
			ld a,0
			; ----------NEW

_copy_lens_fine_offset_b
			add a,3
			and 7
			jp z,{+}
-			srl b
			dec a
			jp nz,{-}
+
			; b = bitmask
			ld a,(hl)
			and b
		pop hl
	pop bc	

_horiz_mirror
	inc de
	
	jp nz,_set_black
	ld a,b
	cpl
	and (hl)
	jp _set_white
_set_black
	ld a,b
	or (hl)
_set_white	
	ld (hl),a
	
	dec ixl
	jp z,_done_lens_row

; NEW----------
	ld a,ixl
	cp 16
	jp nz,{+}
	ld a,$1B ; DEC DE
	ld (_horiz_mirror),a
	ld a,$DA ; JP C
	ld (_adjust_x_offset),a
	dec de
+
; ----------NEW
	
	srl b
	jp nc,_no_need_advance_dest

	ld b,%10000000
	inc hl
_no_need_advance_dest

	jp _next_lens_pixel
	
	
_done_lens_row
	dec ixh
	jp z,_finished_lens
_row_advancer
	ld bc,12-4
	add hl,bc
; NEW----------
	push hl
	
_row_increment
	ld hl,17
	add hl,de
	ld d,h
	ld e,l

	ld a,ixh
	cp 16
	jp nz,{+}
	ld hl,-15
	ld (_row_increment+1),hl
	ld a,$DA ; JP C
	ld (_adjust_y_offset),a
	dec hl
	add hl,de
	ld d,h
	ld e,l
+



	pop hl
; ----------NEW
	jp _draw_next_lens_row
_finished_lens


	; Copy to LCD
	call ionFastCopy

	; Now we can restore the dirty area our lens has created:
	pop hl
	ld de,_old_value
	ld a,32
-	ld bc,8
	ex de,hl
	ldir
	ex de,hl
	ld bc,12-8
	add hl,bc
	dec a
	jp nz,{-}
	
	ld a,$FF
	out (1),a
	ld a,KeyRow_Pad
	out (1),a
	in a,(1)
	
	ld hl,_lens_dx
	bit 1,a
	jr nz,{+}
	dec (hl)
+	bit 2,a
	jr nz,{+}
	inc (hl)
+	

	ld hl,_lens_dy
	bit 3,a
	jr nz,{+}
	dec (hl)
+	bit 0,a
	jr nz,{+}
	inc (hl)
+
	

	call scene_countdown
	jp _loop

_shuffle_intro


	ld ixl,6*8
--

-	ld b,12*8
	call ionRandom
	ld e,a
	ld b,12*8
	call ionRandom
	cp e
	jr z,{-}
	; a->e...
	ld bc,_copy_in
	ld l,a
	ld h,0
	add hl,hl
	add hl,bc
	; hl->item A
	push hl
	
	ld l,e
	ld h,0
	add hl,hl
	add hl,bc
	pop de
	; We need to swap from (hl)<->(de)
	ld c,2
-	ld a,(hl)
	ld b,a
	ld a,(de)
	ld (hl),a
	ld a,b
	ld (de),a
	inc hl
	inc de
	dec c
	jr nz,{-}
	dec ixl
	ret z
	jp {--}
	
_move_lens
	ld a,(ix+0)
	add a,(ix+1)
	ld (ix+0),a
	cp b
	jr c,{+}
	ld a,(ix+1)
	neg
	ld (ix+1),a
	
	; Now, which way were we going?
	jp m,_not_above
	xor a
	jr _set_border_position
_not_above
	ld a,b
	dec a
	dec a
_set_border_position
	ld (ix+0),a
+	srl a
	ld (ix+2),a
	ret
	
.endmodule