.module Lens

_images
.dw _image_0, _image_1, _image_2

_image_0
.incbmp "Resources/Lens/moustache.gif", rle
_image_1
.incbmp "Resources/Lens/beard.gif", rle
_image_2
.incbmp "Resources/Lens/both.gif", rle

; How to generate a transformation table, the Ben Ryves way.
; 1: Draw lots of sketches of rays intersecting spheres.
; 2: Give up, download some notes on the demoscene lens effect.
; 3: Get utterly, utterly confused.
; 4: Write a script to generate a 32x32 bitmap, where each pixel
;    is coloured as a function of the (x,y) it is on the bitmap.
; 5: Blow it up to 3200x3200 in Photoshop, run a spherize filter
;    on it (twice), scale back down to 32x32 (scale up to avoid
;    colour filtering).
; 6: Read the resulting bitmap back, and turn the pixel colours
;    back into (x,y).
; 7: Copy and paste into here. Not one piece of maths required!

; Revision 1:
; Transformation now only references the UPPER-LEFT quadrant. This
; reduces a 2KB table to a 256 byte table! (One-eighth of the size).
; .define linear_transform uses a straight "neutral" transformation,
; to test that my code was handling the 4 quadrants correctly.
; The nybbles are packed into a single byte: $YX
; The two values ($EF and $FE) marked with arrows were manually 
; "corrected" from $FF. With $FF there, the lens effect caused a
; noticably weird diamond at the centre.

_transformation
.ifdef linear_transform
	.db $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	.db $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
	.db $20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F
	.db $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F
	.db $40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F
	.db $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,$5F
	.db $60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F
	.db $70,$71,$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F
	.db $80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F
	.db $90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F
	.db $A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF
	.db $B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,$BE,$BF
	.db $C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF
	.db $D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF
	.db $E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF
	.db $F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF
.else
	.db $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$4D,$5E,$5F,$5F
	.db $10,$11,$12,$13,$14,$15,$16,$17,$18,$5B,$6C,$7D,$7D,$7E,$7F,$7F
	.db $20,$21,$22,$23,$24,$25,$26,$59,$7B,$7C,$8C,$8D,$8E,$8E,$8F,$8F
	.db $30,$31,$32,$33,$34,$35,$79,$8A,$8B,$9C,$9D,$9D,$9E,$9E,$9F,$9F
	.db $40,$41,$42,$43,$44,$89,$9A,$9B,$9C,$AC,$AD,$AD,$AE,$AE,$AF,$AF
	.db $50,$51,$52,$53,$98,$99,$AA,$AB,$AC,$AC,$AD,$BD,$BE,$BE,$BF,$BF
	.db $60,$61,$62,$97,$A9,$AA,$BB,$BB,$BC,$BC,$BD,$BD,$BE,$BE,$BF,$BF
	.db $70,$71,$95,$A8,$B9,$BA,$BB,$BB,$CC,$CD,$CD,$CE,$CE,$CE,$CF,$CF
	.db $80,$81,$B7,$B8,$C9,$CA,$CB,$CC,$CC,$CD,$CD,$CE,$CE,$CE,$CF,$CF
	.db $90,$B5,$C7,$C9,$CA,$CA,$CB,$DC,$DC,$DD,$DD,$DE,$DE,$DE,$DF,$DF
	.db $A0,$C6,$C8,$D9,$DA,$DA,$DB,$DC,$DC,$DD,$DD,$DE,$DE,$DE,$DF,$DF
	.db $B0,$D7,$D8,$D9,$DA,$DB,$DB,$EC,$EC,$ED,$ED,$EE,$EE,$EE,$EF,$EF
	.db $D4,$D7,$E8,$E9,$EA,$EB,$EB,$EC,$EC,$ED,$ED,$EE,$EE,$EE,$EF,$EF
	.db $E5,$E7,$E8,$E9,$EA,$EB,$EB,$EC,$EC,$ED,$ED,$EE,$EE,$EE,$EF,$EF ; <- (b)
	.db $F5,$F7,$F8,$F9,$FA,$FB,$FB,$FC,$FC,$FD,$FD,$FE,$FE,$FE,$FF,$FF
	.db $F5,$F7,$F8,$F9,$FA,$FB,$FB,$FC,$FC,$FD,$FD,$FE,$FE,$FE,$FF,$FF
	                                                       ; ^
	                                                       ; | (a)
.endif
.endmodule