; ===============================================================
; [ µHz ] [ Microhertz ]
; ===============================================================
; A graphical demo for the TI-83 [Plus] series calculator by
; Ben Ryves. See readme.htm for further information.
; ===============================================================
; The code/data split (.asm/.inc pairs) is to ensure that code
; doesn't spill over the 8KB executable boundary.
; Because Ion sticks routines at the end of the executable,
; the Ion routines are inaccessible. (Thanks Patrick_D for this
; info!) Hence, only a TI-83 Ion version. MirageOS handles the
; Ion binary correctly, but Ion wouldn't.
; ===============================================================

.asciimap '$', $C3
.include "Includes/headers.inc"

.asciimap $00, $FF, {*}-' '


.if platform == ti8x
variable_table = appBackUpScreen
variable_space = 768
.else
variable_table = statVars
variable_space = 531
.endif


.varloc variable_table, variable_space
.var 1, LastKey
.var 2, DemoTimer
.varfree variable_free
free_space = variable_space-(variable_free-variable_table)


; ===============================================================
; Main entry point
; ===============================================================

.define Blobs
.define Tunnel
.define Flip
.define Title
.define Cylinder
.define Lens

main
	ld a,$FF
	ld (LastKey),a
		
	; Switch off interrupts
	di
	
	.define exit_black() ld a,$FF\ call Shrink
	.define exit_white() xor a\ call Shrink
	.define time(x) ld hl,x\ ld (DemoTimer),hl
	
	.ifdef Title
	time(2000)
	call Title
	exit_black()
	.endif
	
	.ifdef Tunnel
	time(180)
	call Tunnel
	.endif

	.ifdef Flip
	time(1200)
	call Flip
	exit_white()
	.endif
	
	.ifdef Cylinder
	time(520)
	call Cylinder
	exit_black()
	.endif

	.ifdef Blobs
	time(600)
	call Blobs
	.endif
	
	.ifdef Lens
	time(700)
	call Lens
	exit_white()
	.endif	
		
	bcall(_GrBufClr)
	call ionFastCopy

	; Switch interrupts back on, and quit.
	ei
	ret
	
; ===============================================================
; General global functions
; ===============================================================

.module GlobalFunctions

scene_countdown
	; Call this function each frame of the scene
	
	
	; Is the time up?
	ld hl,(DemoTimer)
	dec hl
	ld a,h
	or l
	jp z,_break
	
	; So, we have time left..?
	inc hl
	ld a,h
	or l
	jp z,_infinite_time
	dec hl
	ld (DemoTimer),hl
_infinite_time ; No countdown

	ld a,$FF
	out (1),a
	ld a,(LastKey)
	bit 1,a ; [+]
	jp z,_contrast_up
	bit 2,a ; [-]
	jp z,_contrast_down
_done_contrast

	ld a,(LastKey)
	bit 6,a
	jp z,_countdown_clear

	ld a,$FF
	out (1),a
	nop
	ld a,KeyRow_5
	out (1),a
	in a,(1)
	
	bit 0,a
	jp nz,{+}
	ld hl,0
	ld (DemoTimer),hl
+
	
	ld (LastKey),a
	ld a,$FF
	out (1),a
	ret
_countdown_clear
	ld a,KeyRow_5
	out (1),a
	in a,(1)
	
	bit 0,a
	jr nz,{+}
	jp _break
	ld hl,0
	ld (DemoTimer),hl
+
	bit 6,a
	ret z
	ld (LastKey),a
_break
	ld a,$FF
	ld (LastKey),a
	ld hl,0
	ld (DemoTimer),hl
	pop hl
	ld a,$FF
	out (1),a
	; Leave the LCD driver in a happy state!
	ld a,$05
	call safe_lcd_pause
	out ($10),a
	ld a,$20
	call safe_lcd_pause
	out ($10),a
	ld a,$80
	call safe_lcd_pause
	out ($10),a
	ret

_contrast_up
	ld b,1
	jr {+}
_contrast_down
	ld b,-1
+	
	ld a,(contrast)
	add a,b
	jp m,_done_contrast
	cp $28
	jp z,_done_contrast
	ld (contrast),a
	; Now we've altered the contrast, we need to send it to the display driver...
	add a,$18
	or $C0
	call safe_lcd_pause
	out ($10),a
	jp _done_contrast

; ===============================================================

safe_lcd_pause
	; Probably a bit excessive...
	push af
	inc hl
	dec hl
	pop af
	ret
; ===============================================================

	; 'Read' the LCD:
take_screenshot
	ld a,$07
	call safe_lcd_pause
	out ($10),a
	
	ld a,$80
	ld (_read_height+1),a
	ld hl,plotSScreen
_read_height
	ld a,0
	call safe_lcd_pause
	out ($10),a

	ld a,$20
	call safe_lcd_pause
	out ($10),a
	
	call safe_lcd_pause
	in a,($11) ; Dummy
	
	ld b,12
	
-	call safe_lcd_pause
	in a,($11)
	ld (hl),a
	inc hl
	djnz {-}
	
	ld a,(_read_height+1)
	inc a
	ld (_read_height+1),a
	cp $80+64
	jr nz,_read_height
	ld a,$05
	call safe_lcd_pause
	out ($10),a	
	ret

; ===============================================================

put_double_byte
	; Take a single byte, stretch it to twice the width,
	; and OR it to ->hl
	; eg %00101101 -> %00001100, %11110011
	; Byte is in a, outputs to hl+0 and hl+1.
	; Destroys: af,bc,d.
	; Affects: hl.

	ld d,a
	ld c,%10000000	
	ld b,%11000000
-	ld a,d
	and c
	jr z,_db_off
	ld a,(hl)
	or b
	ld (hl),a
_db_off
	srl b
	srl b
	jr nc,_not_overflowed_second_byte
	inc hl
	ld b,%11000000
_not_overflowed_second_byte
	srl c
	ret c
	jr {-}
	
; ===============================================================	
	
get_char	; Get pointer to font data from character index.
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	ld de,font
	add hl,de
	ret

; ===============================================================

a_times_12
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	ld d,h
	ld e,l
	add hl,hl
	add hl,de	
	ret
	
; ===============================================================

.if shell != mirageos
disprlel
-	ld a,(hl)
	cp $91
	jr z,_is_run
	ldi
_done_rle
	ret po
	jr {-}
_is_run
	inc hl
	inc hl
	ld a,(hl)
-
	dec hl
	dec a
	ldi
	jr nz,{-}
	inc hl
	jr _done_rle
.endif


.endmodule

.if platform == ti83
.include "Routines/TI83.asm"
.endif

; ===============================================================
; Code
; ===============================================================

.ifdef Blobs
.include "Scenes/Blobs.asm"
.endif

.ifdef Tunnel
.include "Scenes/Tunnel.asm"
.endif

.ifdef Flip
.include "Scenes/Flip.asm"
.endif

.ifdef Title
.include "Scenes/Title.asm"
.endif

.ifdef Cylinder
.include "Scenes/Cylinder.asm"
.endif

.ifdef Lens
.include "Scenes/Lens.asm"
.endif

; Standard exit:
.include "Scenes/Shrink.asm"


; ===============================================================
; Data
; ===============================================================

.ifdef Blobs
.include "Resources/Blobs.inc"
.endif

.ifdef Tunnel
.include "Resources/Tunnel.inc"
.endif

.ifdef Flip
.include "Resources/Flip.inc"
.endif

.ifdef Title
.include "Resources/Title.inc"
.endif

.ifdef Cylinder
.include "Resources/Cylinder.inc"
.endif

.ifdef Lens
.include "Resources/Lens.inc"
.endif

font .incbin "Resources/Font.bin"