package demoOrDie;

import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;

import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JFrame;

//======================================================================

//import demoOrDie.LevitateChars;

//======================================================================


@SuppressWarnings("serial")
public class Scroller extends JFrame {

	static int xsize = 900; // set window size
	static int ysize = 600; // set window size
	static int charsizX = 73; // IS being globally used for x-aspect and stuff
	static int charsizY = 73; // IS being globally used for y-aspect and stuff
	static BufferedImage bufImgCharset;
	static ArrayList<Integer> sinArray = new ArrayList<Integer>();
	static final int sinTabDimensions = 1098 * 8; // dimensions of sinetable(s)
	
	public static int sinOffset = 10; 			  // advance steps through the sine
												  // --> distance between sin samples
	public static int sinRotate = -90;			  // how far and in which direction will the sine progress
	public static int scrollYOffset = (ysize / 4) - charsizY / 2 ; // half amplitude is = half of screen 
																  // y size minus half of character height
	public static int centerAdjust = (ysize / 4);
	
	public static int scrollSpeed = -8;		  // general scrolling speed
	public static boolean running = true;

	public static long initial = 0;				  // used for tick counting
	public static int refreshRate;
	
	public static int zoomFader = 0;
	public static boolean doZoom = false;
	public static int zoomOffset = 50;			  // advance steps through the sine
												  // --> distance between sin samples
	public static int zoomRotate = -90;			  // how far and in which direction will the sine progress
	static ArrayList<Integer> zoomArray = new ArrayList<Integer>();
	
	// ----------------------------------------------------------

	static { // initialize sine array
		double jj = 0;
		for (int ii = 0; ii < sinTabDimensions; ii++) {
			sinArray.add((int) (scrollYOffset * Math.sin(Math.toDegrees(jj / 1000 / 8))));
			zoomArray.add((int) (100 * Math.sin(Math.toDegrees(jj / 1000 / 8))));

			jj = jj + 0.1;
		}

	}


	// ------------------------------------------------------------------------------------------------------------------------------------
	// ------------------------------------------------------------------------------------------------------------------------------------

	public static void main(String[] args) { // main method generates new
												// Scroller Object and Opens new
												// Window

		Scroller frame = new Scroller(); 								// instanciate scroller object
		frame.setIgnoreRepaint(true);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLocation(20, 20);
//		frame.addKeyListener(new KeyAdapter() { 						// Add ESC listener to quit...
//			public void keyPressed(KeyEvent e) {
//				System.out.println(e.getKeyCode());
//				if (e.getKeyCode() == KeyEvent.VK_ESCAPE){
//					running = false;
//				}
//			}
//		});

		Canvas canvas = new Canvas();
		canvas.setIgnoreRepaint(true);
		canvas.setSize(xsize, ysize);

		frame.add(canvas);
		frame.pack(); // init gfx
		frame.setVisible(true); // and show the objects frame

		canvas.createBufferStrategy(2);
		BufferStrategy buffer = canvas.getBufferStrategy();

		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();		// Get graphics configuration...
		GraphicsDevice gd = ge.getDefaultScreenDevice();

		DisplayMode dm = gd.getDisplayMode();	//###tickcalc stuff
		refreshRate = dm.getRefreshRate();		//###tickcalc stuff

		GraphicsConfiguration gc = gd.getDefaultConfiguration();
		BufferedImage bi = gc.createCompatibleImage(xsize, ysize);		// Create off-screen drawing surface
		BufferedImage ci = gc.createCompatibleImage(xsize, ysize);		// Create off-screen drawing surface
		BufferedImage di = gc.createCompatibleImage(xsize, ysize);		// Create off-screen drawing surface

		
		frame.render(buffer, bi, ci, di); 			// trigger render loop

	} // end main

	// ------------------------------------------------------------------------------------------------------------------------------------
	// ------------------------------------------------------------------------------------------------------------------------------------

	public Scroller() { 													// constructor for the scroller object

		//----- load charset image --------------------------------------------------------------
		URL url = this.getClass().getResource("workspacce.png");		// PATH is relative to
																		// the class (bin) folder
			try {
				Scroller.bufImgCharset = ImageIO.read(url); 				// Load Buffered Image charset
			} catch (IOException e) {
				e.printStackTrace();
			}

		//----- load charset image --------------------------------------------------------------
		boolean SoundOn = true; 											// easiest way to temporarily enable/disable sound
		if (SoundOn) {
			URL yourFile = this.getClass().getResource("birthdaywav.wav");// PATH is relative to
																		  // the class (bin) folder
			try {
				AudioInputStream stream;
				AudioFormat format;
				DataLine.Info info;
				Clip clip;

				stream = AudioSystem.getAudioInputStream(yourFile);
				format = stream.getFormat();
				info = new DataLine.Info(Clip.class, format);
				clip = (Clip) AudioSystem.getLine(info);
				clip.open(stream);
				clip.loop(Clip.LOOP_CONTINUOUSLY);
				clip.start();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	} // end constructor scroller

	// ------------------------------------------------------------------------------------------------------------------------------------
	// ------------------------------------------------------------------------------------------------------------------------------------

	public void render(BufferStrategy buffer, BufferedImage bi, BufferedImage ci, BufferedImage di) {

		Graphics2D g = null;
		Graphics graphics = null;
		boolean newstyle=true;

		// make sure there is a first initialized char
		LevitateChars.initNewLetter(ScrollTextStream.getScrolltext(), xsize,(ysize / 2));

									    // Variables for counting frames per seconds
									    int fps = 0;
									    int frames = 0;
									    long totalTime = 0;
									    long curTime = System.currentTimeMillis();
									    long lastTime = curTime;

						    			// Variables for FPS-Capping
									    int TICKS_PER_SECOND = refreshRate-1;
									    int SKIP_TICKS = 1000 / TICKS_PER_SECOND;
									    int MAX_FRAMESKIP = 5;
									    long next_frame_tick = GetTickCount();
									    int loops;

		while (running) { // begin endless loop
			try {
			//fps capping
			loops = 0;
			while( GetTickCount() > next_frame_tick && loops < MAX_FRAMESKIP) {

								        // count Frames per second...
								        lastTime = curTime;
								        curTime = System.currentTimeMillis();
								        totalTime += curTime - lastTime;
								        if( totalTime > 1000 ) {
								          totalTime -= 1000;
								          fps = frames;
								          frames = 0;
								        }
								        ++frames;

				//--------------------------------
	if (newstyle){
				g = bi.createGraphics();					// get old frame contents
				g.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.5F)); //set composite of old frame to xF
				g.drawImage(ci, 0, 0, null);				// paint the new gfx over the old gfx
				g.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1.0F)); //set composite of newly constructed
																						   //frame back to normal so all is painted
																						   //ontop solidly
			}

	else	{
				g = bi.createGraphics();					// get old frame contents
				Color background = new Color(0, 0, 0, 128); // 255 = erase what was on screen, 128 = 50%
				g.setColor(background);						//
				g.fillRect(0, 0, xsize, ysize);				//
			}
				//--------------------------------
					LevitateChars.moveDems(xsize+charsizX, (ysize / 2)); // move all chars and add new text and destroy ofscreen text
					LevitateChars.scaleDems();				// add some scaling to all chars
					copyCharsToScreenZoomed(g);				// copies all prepared char tiles from image to current buffer
						if (doZoom) { fadeInZoom(); }		// zooming is enabled = fade animation (scaling amount) in
						else { fadeOutZoom(); }				// zooming is disabled = fade animation (scaling amount) out
					rollSin(); 								// roll the values in the y-coords sine table for wave animation
					rollZoom();								// roll the values in the zooming sine table for scaling animation
					displayDebugInfo(g, fps);				// put the debug info FPS, RR, Chars on screen
				//--------------------------------

//					tvfuzz(g,bi,di);

				//--------------------------------
				graphics = buffer.getDrawGraphics();		// get reference to buffer
				graphics.drawImage(bi, 0, 0, null);			// paint the composed image to buffer
				if (!buffer.contentsLost())
					buffer.show();

										//fps capping...
							            next_frame_tick += SKIP_TICKS;
							            loops++;
			} // end fps capped loop

				Thread.yield();							//give le system some time

			} finally {									//finally, do some cleaning up
				if (g != null) {
					g.dispose();						//nicely throw away gfx
				}
				if (graphics != null) {
					graphics.dispose();					//nicely throw away gfx
				}
			}
		} // end endless loop
	} // end render method

	// ------------------------------------------------------------------------------------------------------------------------------------
	// ------------------------------------------------------------------------------------------------------------------------------------

//	private static void copyCharsToScreen(final Graphics2D dst) {
//
//		ArrayList<aCharacterOnScreen> charControlCopy = LevitateChars.getCharControl();
//		for (int aa = 0; aa < (charControlCopy.size()); aa++) {
//			aCharacterOnScreen cCObj = charControlCopy.get(aa);
//			BufferedImage img = (bufImgCharset.getSubimage(cCObj.getTileCoordsX(), cCObj.getTileCoordsY(), charsizX,charsizY));
//			dst.drawImage(img, cCObj.getLevitPosX(), cCObj.getLevitPosY(), null);
//			img.flush();
//		}
//	} // end copychars

	// ------------------------------------------------------------------------------------------------------------------------------------

	private void tvfuzz(Graphics2D g, BufferedImage bi, BufferedImage di) {

//		di = deepCopy(bi);

		Graphics2D ok = bi.createGraphics();


		
		Random fuzz = new Random();


		Color newColor = new Color(fuzz.nextInt(255),fuzz.nextInt(255),fuzz.nextInt(255),0); // R G B Alpha
//		ok.setXORMode(newColor);
		ok.setColor(newColor);
		ok.setComposite(AlphaComposite.getInstance(AlphaComposite.DST_OVER, 1.0F));
		ok.fillRect(0, 0, xsize, ysize);
//		ok.drawImage(di,0,1,null);

		ok.dispose();
		

//		Random nummerz = new Random();
		
		// Get 3 copies of the image data to create the R-only, G-only, B-only images.
//		int pixData[]=new int[4];

//		 for (int yy=0; yy<200;yy++){
//			 for (int xx=0;xx<800;xx++){
//					bi.getRaster().getPixel(xx, yy, pixData);
//			 }
//		 }
//		 nummerz.nextInt(2);
//
////		 System.out.println(pixData.length);



    }
	
	static BufferedImage deepCopy(BufferedImage bi) {
		 ColorModel cm = bi.getColorModel();
		 boolean isAlphaPremultiplied = true;// cm.isAlphaPremultiplied();
		 WritableRaster raster = bi.copyData(null);
		 return new BufferedImage(cm, raster, isAlphaPremultiplied, null);

		}
	
	// ------------------------------------------------------------------------------------------------------------------------------------

	private static void copyCharsToScreenZoomed(final Graphics2D g) {

		for (int aa = 0; aa < (LevitateChars.charControl.size()); aa++) {
			aCharacterOnScreen cCObj = LevitateChars.charControl.get(aa);	// get a reference to all aCharacterOnScreen Objects in cCobj 
			BufferedImage img = (bufImgCharset.getSubimage(cCObj.getTileCoordsX(), cCObj.getTileCoordsY(), charsizX,charsizY));

			double limited = ((double)cCObj.getZoomScale() +(double)100)/(double)100;

			// xlimited = (currentvalue / (highest value/ desired maximum)) + desired lower limit
			double highest = 2.0;
			double lower_limit = 0.0;
			double upper_limit = 1.3;
			   limited = (limited / ( highest / (upper_limit - lower_limit)) + lower_limit);

			   			//			  %		max / 100
			   			// 1.9       100 * (1.9 / 100)
			   limited = ( 1 + (zoomFader * (limited / 200)));
			int scaled = (int) (charsizX*limited);

			g.drawImage(img, cCObj.getLevitPosX()-scaled/2, cCObj.getLevitPosY()-scaled/2, scaled, scaled, null);
			img.flush();
		}
	} // end copychars

	// ------------------------------------------------------

	private static void rollSin() {				// rotates the sine array so we have wavy animation
		Collections.rotate(sinArray, sinRotate);
	}

	// ------------------------------------------------------

	private static void rollZoom() {			// rotates the zoom array so we have wavy animation
		Collections.rotate(zoomArray, zoomRotate);
	}

	// ------------------------------------------------------

	private static long GetTickCount() {
		long time=System.currentTimeMillis();	// get current system time
		long calced = time - initial; 			// calculate how much time has passed since the last call
		time = initial;							// update the comparator
	    return calced;							// return how much netto time has passed
    }

	//------------------------------------------------------------------------------

	public void fadeOutZoom() { // if there is no more zooming activity, return values to normal, slowly
		zoomFader --;
		if (zoomFader < 1){
			zoomFader = 0;
		}
	}

	//------------------------------------------------------------------------------

	public void fadeInZoom() { // if there is no more zooming activity, return values to normal, slowly
		zoomFader ++;
		if (zoomFader > 100){
			zoomFader = 100;
		}
	}

	//------------------------------------------------------------------------------	
	
	// ------------------------------------------------------
	//THIS BE GONE LATER ------------------------------------------------------->
	private static void displayDebugInfo(Graphics2D g, int fps) {
		// display frames per second...
		g.setFont( new Font( "Courier New", Font.PLAIN, 12 ) );
		g.setColor( Color.GREEN );
		g.drawString( String.format( "FPS: %s", fps ), 20, 20 );
		g.setColor( Color.YELLOW );
		g.drawString( String.format( "RR: %s", refreshRate ), 20, 35);
		//---------------------

		// display all currently used char objects...
		String dispElements = "";
		ArrayList<aCharacterOnScreen> tempObj = LevitateChars.getCharControl();
	    for (int ii = 0; ii < LevitateChars.getCharControl().size()-1 ; ii++){
		    aCharacterOnScreen tempCoS = tempObj.get(ii);
			dispElements=dispElements+tempCoS.getCurrChar();
	    }
	    g.setColor( Color.RED );
	    g.drawString( String.format( "Actif: %s", dispElements), 20, 50);
	}
	//THIS BE GONE LATER <-------------------------------------------------------


	// ------------------------------------------------------------------------------------------------------------------------------------
	// ------------------------------------------------------------------------------------------------------------------------------------
}// end class
