
; ---------------------------------------------------------------------------
;   fmath.asm - float math code, visual c++ 6.0 version.
;   copyright (c) 2001. remage / fresh!mindworkz.
; ---------------------------------------------------------------------------

; ===========================================================================
    SECTION .code
; ===========================================================================

GLOBAL _Fmath_Pi
GLOBAL _Fmath_2Pi

GLOBAL _Fabs@4

GLOBAL _Fsqr@4
GLOBAL _Fsqrt@4

GLOBAL _Fsin@4
GLOBAL _Fcos@4
GLOBAL _Fpatan@8

GLOBAL _Fround@4

GLOBAL _Fln@4
GLOBAL _Fexp@4

; ---------------------------------------------------------------------------
;   float Fabs( float )
; ---------------------------------------------------------------------------

_Fabs@4:
    fld dword [ esp+4 ]
    fabs
    ret 4

; ---------------------------------------------------------------------------
;   float Fsqr( float )
; ---------------------------------------------------------------------------

_Fsqr@4:
    fld dword [ esp+4 ]
    fmul st0, st0
    ret 4

; ---------------------------------------------------------------------------
;   float Fsqrt( float )
; ---------------------------------------------------------------------------

_Fsqrt@4:
    fld dword [ esp+4 ]
    fsqrt
    ret 4

; ---------------------------------------------------------------------------
;   float Fsin( float )
; ---------------------------------------------------------------------------

_Fsin@4:
    fld dword [ esp+4 ]
    fsin
    ret 4

; ---------------------------------------------------------------------------
;   float Fcos( float )
; ---------------------------------------------------------------------------

_Fcos@4:
    fld dword [ esp+4 ]
    fcos
    ret 4

; ---------------------------------------------------------------------------
;   float Fpatan( float, float )
; ---------------------------------------------------------------------------

_Fpatan@8:
    fld dword [ esp+4 ]
    fld dword [ esp+8 ]
    fpatan
    ret 8

; ---------------------------------------------------------------------------
;   int Fround( float )
; ---------------------------------------------------------------------------

_Fround@4:
    fld dword [ esp+4 ]
    fistp dword [ _Fmath_Temp ]
    mov eax, dword [ _Fmath_Temp ]
    ret 4

; ---------------------------------------------------------------------------
;   float Ftrunc( float )
; ---------------------------------------------------------------------------

    GLOBAL _Ftrunc@4

_Ftrunc@4:
    fstcw word [ _Fmath_Control ]
    fstcw word [ _Fmath_Control+2 ]
    or byte [ _Fmath_Control+3 ], 0x0C
    fldcw word [ _Fmath_Control+2 ]
    fld dword [ esp+4 ]
    frndint
    fldcw word [ _Fmath_Control ]
    ret 4


; ---------------------------------------------------------------------------
;   float Frac( float )
; ---------------------------------------------------------------------------

        GLOBAL _Frac@4

_Frac@4:
        fstcw word [ _Fmath_Control ]
        fstcw word [ _Fmath_Control+2 ]
        or byte [ _Fmath_Control+3 ], 0x0C
        fldcw word [ _Fmath_Control+2 ]
        fld dword [ esp+4 ]
        fld st0
        frndint
        fsubp st1, st0
        fldcw word [ _Fmath_Control ]
        ret 4

; ---------------------------------------------------------------------------
;   float Fln( float )
; ---------------------------------------------------------------------------

_Fln@4:
    fld dword [ _Fmath_Log2E ]
    fld dword [ _Fmath_1 ]
    fld dword [ esp+4 ]
    fyl2x
    fdivrp st1, st0
    ret 4

; ---------------------------------------------------------------------------
;   float Fexp( float )  = e ^ x = 2 ^ ( x * log2( e ))
; ---------------------------------------------------------------------------

_Fexp@4:
    fstcw word [ _Fmath_Control ]
    fstcw word [ _Fmath_Control+2 ]
    or byte [ _Fmath_Control+3 ], 0x0C
    fldcw word [ _Fmath_Control+2 ]
    fld dword [ esp+4 ]
    fld dword [ _Fmath_Log2E ]
    fmulp st1, st0
    fld st0
    frndint
    fxch st0, st1
    fsub st0, st1
    f2xm1
    fld1
    faddp st1, st0
    fxch st1, st0
    fld dword [ _Fmath_1 ]
    fscale
    fstp st1
    fmulp st1, st0
    fldcw word [ _Fmath_Control ]
    ret 4

; ===========================================================================
    SECTION .data
; ===========================================================================
                
_Fmath_QNAN dd 0xFFC04800    ; 1 11111111 1000000 01001000 00000000
_Fmath_SNAN dd 0xFF804800    ; 1 11111111 0000000 01001000 00000000
_Fmath_PInf dd 0x7F800000    ; 0 11111111 0000000 00000000 00000000
_Fmath_NInf dd 0xFF800000    ; 1 11111111 0000000 00000000 00000000

_Fmath_E dd 2.71828182845904523536028747135266
_Fmath_Log2E dd 1.4426950408889634073599246810019
_Fmath_Pi dd 3.14159265358979323846264338327950
_Fmath_2Pi dd 6.28318530717958647692528676655901

_Fmath_1 dd 1.0
_Fmath_05 dd 0.5

; ===========================================================================
    SECTION .bss
; ===========================================================================

_Fmath_Status resd 1
_Fmath_Control resd 1
_Fmath_Temp resd 1    
