/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef SHADEREDITORWIDGET_HH
#define SHADEREDITORWIDGET_HH

#include <QtGui>

namespace Ui {
    class ShaderEditorWidget;
}

class ShaderEditorWidget : public QDockWidget
{
    Q_OBJECT

public:
    explicit ShaderEditorWidget(QWidget *parent = 0);
    ~ShaderEditorWidget();

    QString getVertexText(void);
    QString getFragmentText(void);
    QString getVertexPostText(void);
    QString getFragmentPostText(void);

public slots:
    void setVertexText(QString str);
    void setFragmentText(QString str);
    void setVertexPostText(QString str);
    void setFragmentPostText(QString str);


    void prepareCompilationFireup();
    void preparePostCompilationFireup();
    void fireupCompilation();
    void fireupPostCompilation();

    void setAutoUpdate(bool mu);
    void setSceneStatus(QString str);
    void setPostStatus(QString str);

signals:
    void shaderChanged(QString vert, QString frag);
    void shaderPostChanged(QString vert, QString frag);

private:
    Ui::ShaderEditorWidget *ui;

    static QString colorSyntax(QString in);

    bool _autoUpdate;

    QTimer* _compileTimer,*_compilePostTimer;
};

#endif // SHADEREDITORWIDGET_HH
