/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef SCENEEDITORWIDGET_HH
#define SCENEEDITORWIDGET_HH

#include <QtGui>

namespace Ui {
    class SceneEditorWidget;
}

class SceneEditorTreeModel;
class SceneEditorTreeItem;
class RenderWidget;

class SceneEditorWidget : public QDockWidget {
    Q_OBJECT
public:
    SceneEditorWidget(RenderWidget *rw, QWidget* parent = NULL);
    ~SceneEditorWidget();

    QStringList& getAllParameters(SceneEditorTreeItem* root = NULL);
    QList<float*>& getAllMappedValues(SceneEditorTreeItem* root = NULL);
    QList<float>& getAllDefaultValues(SceneEditorTreeItem* root = NULL);

    void setSceneTree(SceneEditorTreeItem* root);

public slots:
    void emitSceneParameterSelectionChanged(const QModelIndex& index);
    void emitDemoSizeRTTChanged();
    void emitDemoCameraChanged(int);
    void emitMakeWaypoint();
    void setFPSLabel(QString str);
    void setTexture0();
    void setTexture1();
    void setTexture2();
    void setTexture3();

signals:
    void sceneParameterSelectionChanged(QString varName);
    void demoSizeRTTChanged(int, int);
    void demoCameraChanged(int);
    void makeWaypoint();

private:
    Ui::SceneEditorWidget *ui;
    SceneEditorTreeItem*  _treeRoot;
    SceneEditorTreeModel* _model;
    RenderWidget *_rw;

private slots:
    void on_SceneEditorWidget_allowedAreasChanged(Qt::DockWidgetAreas allowedAreas);
};

#endif // SCENEEDITORWIDGET_HH
