/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include "sceneeditorwidget.hh"
#include "ui_sceneeditorwidget.h"

#include "sceneeditortreeitem.hh"
#include "sceneeditortreemodel.hh"
#include "renderwidget.hh"
SceneEditorWidget::SceneEditorWidget(RenderWidget *rw, QWidget* parent) : QDockWidget(parent), ui(new Ui::SceneEditorWidget)
{
    ui->setupUi(this);

    _rw = rw;
    _model = NULL;

    /*SceneEditorTreeItem* root = new SceneEditorTreeItem(QString(), NULL);
      root->appendChild(new SceneEditorTreeItem(QString("Camera"), NULL));
        root->child("Camera")->appendChild(new SceneEditorTreeItem(QString("Position"), NULL));
          root->child("Camera.Position")->appendChild(new SceneEditorTreeItem(QString("X"), NULL));
          root->child("Camera.Position")->appendChild(new SceneEditorTreeItem(QString("Y"), NULL));
          root->child("Camera.Position")->appendChild(new SceneEditorTreeItem(QString("Z"), NULL));
        root->child("Camera")->appendChild(new SceneEditorTreeItem(QString("Target"), NULL));
          root->child("Camera.Target")->appendChild(new SceneEditorTreeItem(QString("X"), NULL));
          root->child("Camera.Target")->appendChild(new SceneEditorTreeItem(QString("Y"), NULL));
          root->child("Camera.Target")->appendChild(new SceneEditorTreeItem(QString("Z"), NULL));
        root->child("Camera")->appendChild(new SceneEditorTreeItem(QString("Roll"), NULL));
        root->child("Camera")->appendChild(new SceneEditorTreeItem(QString("Time"), NULL));
      root->appendChild(new SceneEditorTreeItem(QString("Rendering"), NULL));
        root->child("Rendering")->appendChild(new SceneEditorTreeItem(QString("Mandelbox"), NULL));
          root->child("Rendering.Mandelbox")->appendChild(new SceneEditorTreeItem(QString("Color"), NULL));
            root->child("Rendering.Mandelbox.Color")->appendChild(new SceneEditorTreeItem(QString("R"), NULL));
            root->child("Rendering.Mandelbox.Color")->appendChild(new SceneEditorTreeItem(QString("G"), NULL));
            root->child("Rendering.Mandelbox.Color")->appendChild(new SceneEditorTreeItem(QString("B"), NULL));
          root->child("Rendering.Mandelbox")->appendChild(new SceneEditorTreeItem(QString("Scale"), NULL));
          root->child("Rendering.Mandelbox")->appendChild(new SceneEditorTreeItem(QString("Box"), NULL));
        root->child("Rendering")->appendChild(new SceneEditorTreeItem(QString("Fog"), NULL));
          root->child("Rendering.Fog")->appendChild(new SceneEditorTreeItem(QString("Intensity"), NULL));
          root->child("Rendering.Fog")->appendChild(new SceneEditorTreeItem(QString("Color"), NULL));
            root->child("Rendering.Fog.Color")->appendChild(new SceneEditorTreeItem(QString("R"), NULL));
            root->child("Rendering.Fog.Color")->appendChild(new SceneEditorTreeItem(QString("G"), NULL));
            root->child("Rendering.Fog.Color")->appendChild(new SceneEditorTreeItem(QString("B"), NULL));
        root->child("Rendering")->appendChild(new SceneEditorTreeItem(QString("Lighting"), NULL));
          root->child("Rendering.Lighting")->appendChild(new SceneEditorTreeItem(QString("Light"), NULL));
            root->child("Rendering.Lighting.Light")->appendChild(new SceneEditorTreeItem(QString("Position"), NULL));
              root->child("Rendering.Lighting.Light.Position")->appendChild(new SceneEditorTreeItem(QString("X"), NULL));
              root->child("Rendering.Lighting.Light.Position")->appendChild(new SceneEditorTreeItem(QString("Y"), NULL));
              root->child("Rendering.Lighting.Light.Position")->appendChild(new SceneEditorTreeItem(QString("Z"), NULL));
            root->child("Rendering.Lighting.Light")->appendChild(new SceneEditorTreeItem(QString("Color"), NULL));
              root->child("Rendering.Lighting.Light.Color")->appendChild(new SceneEditorTreeItem(QString("R"), NULL));
              root->child("Rendering.Lighting.Light.Color")->appendChild(new SceneEditorTreeItem(QString("G"), NULL));
              root->child("Rendering.Lighting.Light.Color")->appendChild(new SceneEditorTreeItem(QString("B"), NULL));
      root->appendChild(new SceneEditorTreeItem(QString("Post-processing"), NULL));
        root->child("Post-processing")->appendChild(new SceneEditorTreeItem(QString("White fade"), NULL));
        root->child("Post-processing")->appendChild(new SceneEditorTreeItem(QString("Black fade"), NULL));
        root->child("Post-processing")->appendChild(new SceneEditorTreeItem(QString("RGB effect"), NULL));
        root->child("Post-processing")->appendChild(new SceneEditorTreeItem(QString("Antialiasing"), NULL));

    setSceneTree(root);*/

    connect(ui->treeView, SIGNAL(clicked(QModelIndex)), this, SLOT(emitSceneParameterSelectionChanged(QModelIndex)));
}

SceneEditorWidget::~SceneEditorWidget()
{
    delete ui;
}

void SceneEditorWidget::setSceneTree(SceneEditorTreeItem* root)
{
    _model = new SceneEditorTreeModel();
    _treeRoot = root;
    _model->setup(root);
    ui->treeView->setModel(_model);
}

QStringList& SceneEditorWidget::getAllParameters(SceneEditorTreeItem* root) {
    QStringList* lst = new QStringList();
    if(!root) root = _treeRoot;
    for(int i = 0; i < root->children().size(); i++) {
        SceneEditorTreeItem* seti = root->children().at(i);
        if(!seti->childCount()) lst->append(seti->longVarName());
        else {
            QStringList l2(getAllParameters(seti));
            lst->append(l2);
        }
    }
    return *lst;
}

QList<float*>& SceneEditorWidget::getAllMappedValues(SceneEditorTreeItem* root) {
    QList<float*>* lst = new QList<float*>();
    if(!root) root = _treeRoot;
    for(int i = 0; i < root->children().size(); i++) {
        SceneEditorTreeItem* seti = root->children().at(i);
        if(!seti->childCount()) lst->append(seti->mappedValue());
        else {
            QList<float*> l2(getAllMappedValues(seti));
            lst->append(l2);
        }
    }
    return *lst;
}

QList<float>& SceneEditorWidget::getAllDefaultValues(SceneEditorTreeItem* root) {
    QList<float>* lst = new QList<float>();
    if(!root) root = _treeRoot;
    for(int i = 0; i < root->children().size(); i++) {
        SceneEditorTreeItem* seti = root->children().at(i);
        if(!seti->childCount()) lst->append(seti->defaultValue());
        else {
            QList<float> l2(getAllDefaultValues(seti));
            lst->append(l2);
        }
    }
    return *lst;
}

void SceneEditorWidget::emitSceneParameterSelectionChanged(const QModelIndex& index) {
    if(index.isValid()) {
        SceneEditorTreeItem* item = (SceneEditorTreeItem*)(index.internalPointer());
        if(!(item->childCount())) {
            emit sceneParameterSelectionChanged(item->longVarName());
        }
    }
}

void SceneEditorWidget::emitDemoSizeRTTChanged()
{
    emit demoSizeRTTChanged(ui->spinBox_width->value(), ui->spinBox_heigth->value());
}

void SceneEditorWidget::emitDemoCameraChanged(int a)
{
    emit demoCameraChanged(a);
}

void SceneEditorWidget::emitMakeWaypoint()
{
    emit makeWaypoint();
}

void SceneEditorWidget::setFPSLabel(QString str)
{
    ui->fpsLabel->setText("FPS : " + str);
}


void SceneEditorWidget::on_SceneEditorWidget_allowedAreasChanged(Qt::DockWidgetAreas allowedAreas)
{

}


void SceneEditorWidget::setTexture0()
{
    QString path = QFileDialog::getOpenFileName(NULL, QString("Open image"), QString("Textures/"), QString("Image files (*.png *.bmp *.jpg)"));
    QImage tex1, buf;
    if( !buf.load(path) )
    {
        QMessageBox::critical(this, "Texture manager", "Can't load"+path);

    }
    tex1 = QGLWidget::convertToGLFormat( buf );

    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, _rw->getTexture(0));
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);

    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, tex1.width(), tex1.height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, tex1.bits());
    glBindTexture(GL_TEXTURE_2D, 0);

    ui->tex0LineEdit->setText(path);
}


void SceneEditorWidget::setTexture1()
{
    QString path = QFileDialog::getOpenFileName(NULL, QString("Open image"), QString("Textures/"), QString("Image files (*.png *.bmp *.jpg)"));
    QImage tex1, buf;
    if( !buf.load(path) )
    {
        QMessageBox::critical(this, "Texture manager", "Can't load"+path);

    }
    tex1 = QGLWidget::convertToGLFormat( buf );

    glBindTexture(GL_TEXTURE_2D, _rw->getTexture(1));
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);

    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, tex1.width(), tex1.height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, tex1.bits());
    glBindTexture(GL_TEXTURE_2D, 0);

    ui->tex1LineEdit->setText(path);
}

void SceneEditorWidget::setTexture2()
{
    QString path = QFileDialog::getOpenFileName(NULL, QString("Open image"), QString("Textures/"), QString("Image files (*.png *.bmp *.jpg)"));
    QImage tex1, buf;
    if( !buf.load(path) )
    {
        QMessageBox::critical(this, "Texture manager", "Can't load"+path);

    }
    tex1 = QGLWidget::convertToGLFormat( buf );

    glBindTexture(GL_TEXTURE_2D, _rw->getTexture(2));
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);

    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, tex1.width(), tex1.height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, tex1.bits());
    glBindTexture(GL_TEXTURE_2D, 0);

    ui->tex2LineEdit->setText(path);
}

void SceneEditorWidget::setTexture3()
{
    QString path = QFileDialog::getOpenFileName(NULL, QString("Open image"), QString("Textures/"), QString("Image files (*.png *.bmp *.jpg)"));
    QImage tex1, buf;
    if( !buf.load(path) )
    {
        QMessageBox::critical(this, "Texture manager", "Can't load"+path);

    }
    tex1 = QGLWidget::convertToGLFormat( buf );

    glBindTexture(GL_TEXTURE_2D, _rw->getTexture(3));
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);

    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, tex1.width(), tex1.height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, tex1.bits());
    glBindTexture(GL_TEXTURE_2D, 0);

    ui->tex3LineEdit->setText(path);
}



