/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include "sceneeditortreemodel.hh"
#include "sceneeditortreeitem.hh"

SceneEditorTreeModel::SceneEditorTreeModel(QObject* parent) : QAbstractItemModel(parent)
{
}

QModelIndex SceneEditorTreeModel::index(int row, int column, const QModelIndex& parent) const
{
    SceneEditorTreeItem* parentItem;

    if (!parent.isValid())
        parentItem = _rootItem;
    else
        parentItem = static_cast<SceneEditorTreeItem*>(parent.internalPointer());

    SceneEditorTreeItem* childItem = parentItem->child(row);
    if (childItem)
        return createIndex(row, column, childItem);
    else
        return QModelIndex();
}

QModelIndex SceneEditorTreeModel::parent(const QModelIndex& index) const
{
    if (!index.isValid())
        return QModelIndex();

    SceneEditorTreeItem* childItem = static_cast<SceneEditorTreeItem*>(index.internalPointer());
    SceneEditorTreeItem* parentItem = childItem->parent();

    if (parentItem == _rootItem)
        return QModelIndex();

    return createIndex(parentItem->row(), 0, parentItem);
}

int SceneEditorTreeModel::rowCount(const QModelIndex& parent) const
{
    SceneEditorTreeItem* parentItem;

    if (!parent.isValid())
        parentItem = _rootItem;
    else
        parentItem = static_cast<SceneEditorTreeItem*>(parent.internalPointer());

    return parentItem->childCount();
}

int SceneEditorTreeModel::columnCount(const QModelIndex&) const {
    return 1;
}

QVariant SceneEditorTreeModel::data(const QModelIndex& index, int role) const
{
    if (!index.isValid())
         return QVariant();

     if (role != Qt::DisplayRole)
         return QVariant();

     SceneEditorTreeItem* item = static_cast<SceneEditorTreeItem*>(index.internalPointer());

     return QVariant(item->varName());
}

void SceneEditorTreeModel::setup(SceneEditorTreeItem* root)
{
    _rootItem = root;
}
