/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef SCENEEDITORTREEITEM_HH
#define SCENEEDITORTREEITEM_HH

#include <QMap>
#include <QList>
#include <QString>

class SceneEditorTreeItem
{
public:
    SceneEditorTreeItem(QString varName, float* mappedValue, float defaultValue = 0.0f, SceneEditorTreeItem* parent = NULL);
    ~SceneEditorTreeItem();

    SceneEditorTreeItem* parent() const;
    QList<SceneEditorTreeItem*> children() const;
    SceneEditorTreeItem* child(QString longVarName);
    SceneEditorTreeItem* child(int index);
    void appendChild(SceneEditorTreeItem* child);
    void setParent(SceneEditorTreeItem* parent);

    int totalChildCount() const;
    int childCount() const;
    int row() const;

    QString varName() const;
    QString longVarName() const;
    float* mappedValue() const;
    float defaultValue() const;

private:
    QList<SceneEditorTreeItem*> _childItems;
    SceneEditorTreeItem* _parent;

    QString _varName, _longVarName;
    float* _mappedValue;
    float _defaultValue;
    SceneEditorTreeItem* _parentItem;
};


#endif // SCENEEDITORTREEITEM_HH
