/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef QFMODEX_HH
#define QFMODEX_HH

#include <QtCore>
#include <QImage>
#include <fmodex/fmod.h>

class QFmodEx : public QObject
{
    Q_OBJECT
public:
    enum State
    {
        Idle = 0,
        Loading,
        Stopped,
        Playing,
        Paused,

        Error = 0xff
    };

    enum SeekDirection
    {
        Backward = 0,
        Forward
    };

    static QFmodEx* instance();

    State state();
    QImage* audiogram(float lTime, float rTime, int width, int height);

signals:
    void started();
    void paused();
    void stopped();
    void stateChanged(QFmodEx::State oldState, QFmodEx::State newState);
    void tick(unsigned int time);

public slots:
    void loadMusicFile(QString filename);
    void play();
    void pause();
    void togglePlay();
    void stop();
    void seek(unsigned int time);
    void seekRelative(unsigned int time, SeekDirection dir);

private:
    static QFmodEx* _instance;

    QTimer* _timer;
    State _state;

    FMOD_SYSTEM*       _system;
    FMOD_SOUND*        _sound;
    FMOD_CHANNELGROUP* _masterChannel;
    FMOD_CHANNEL*      _playingChannel;

    QFmodEx(QObject* parent = NULL);
    ~QFmodEx();

    void setState(State newState);

private slots:
    void timerCallback();
};

#endif /* QFMODEX_HH */
