/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include "playerwidget.hh"
#include "ui_playerwidget.h"

#include "qfmodex.hh"

PlayerWidget::PlayerWidget(QWidget* parent) : QWidget(parent), ui(new Ui::PlayerWidget)
{
    ui->setupUi(this);
    QFile f(":/res/css/playerwidget.css"); f.open(QFile::ReadOnly);
    setStyleSheet(f.readAll()); f.close();

    QStyle* st = QApplication::style();
    ui->btnBegin->setIcon(st->standardIcon(QStyle::SP_MediaSkipBackward));
    ui->btnSeekBackward->setIcon(st->standardIcon(QStyle::SP_MediaSeekBackward));
    ui->btnPlayPause->setIcon(st->standardIcon(QStyle::SP_MediaPlay));
    ui->btnSeekForward->setIcon(st->standardIcon(QStyle::SP_MediaSeekForward));
    ui->btnEnd->setIcon(st->standardIcon(QStyle::SP_MediaSkipForward));

    _songTime = 0.0f;

    _fmodEx = QFmodEx::instance();
    connect(_fmodEx, SIGNAL(tick(unsigned int)), this, SLOT(updateTime(unsigned int)));
    connect(_fmodEx, SIGNAL(stateChanged(QFmodEx::State,QFmodEx::State)), this, SLOT(changeButtonsState(QFmodEx::State, QFmodEx::State)));
    changeButtonsState(QFmodEx::Idle, QFmodEx::Idle);
}

PlayerWidget::~PlayerWidget()
{
    delete ui;
}

void PlayerWidget::openMusicFile()
{
    QStyle* st = QApplication::style();
    //QString filename = "/home/xt95/Téléchargements/YouTube        - Dub Fiend - Tetris Dubstep.mp3";
    QString filename = QFileDialog::getOpenFileName(NULL, QString("Open song"), QString("Music"), QString("Music files (*.mp3 *.ogg)"));

    if(!filename.isEmpty())
    {
        ui->btnPlayPause->setIcon(st->standardIcon(QStyle::SP_MediaPlay));
        updateTime(0);
        ui->txtMusicPath->setText(filename);
        _fmodEx->loadMusicFile(filename);

        emit newAudiogramAvailable();
    }
}

void PlayerWidget::goToBegin()
{
    mediaSeek(0);
}

void PlayerWidget::seekBackward()
{
    _fmodEx->seekRelative(3000, QFmodEx::Backward);
}

void PlayerWidget::togglePlay()
{
    _fmodEx->togglePlay();
}

void PlayerWidget::seekForward()
{
    _fmodEx->seekRelative(3000, QFmodEx::Forward);
}

void PlayerWidget::goToEnd()
{
    _fmodEx->seek(-1);
}

void PlayerWidget::changeButtonsState(QFmodEx::State oldState, QFmodEx::State newState)
{
    Q_UNUSED(oldState);

    QStyle* st = QApplication::style();

    switch(newState)
    {
    case QFmodEx::Playing:
        ui->btnBegin->setEnabled(true);
        ui->btnSeekBackward->setEnabled(true);
        ui->btnPlayPause->setEnabled(true);
        ui->btnSeekForward->setEnabled(true);
        ui->btnEnd->setEnabled(true);

        ui->btnPlayPause->setIcon(st->standardIcon(QStyle::SP_MediaPause));
        break;
    case QFmodEx::Paused:
        ui->btnBegin->setEnabled(true);
        ui->btnSeekBackward->setEnabled(true);
        ui->btnPlayPause->setEnabled(true);
        ui->btnSeekForward->setEnabled(true);
        ui->btnEnd->setEnabled(true);

        ui->btnPlayPause->setIcon(st->standardIcon(QStyle::SP_MediaPlay));
        break;
    case QFmodEx::Stopped:
        ui->btnBegin->setEnabled(false);
        ui->btnSeekBackward->setEnabled(false);
        ui->btnPlayPause->setEnabled(true);
        ui->btnSeekForward->setEnabled(false);
        ui->btnEnd->setEnabled(false);

        ui->btnPlayPause->setIcon(st->standardIcon(QStyle::SP_MediaPlay));
        break;
    case QFmodEx::Idle:
    case QFmodEx::Loading:
    case QFmodEx::Error:
    default:
        ui->btnBegin->setEnabled(false);
        ui->btnSeekBackward->setEnabled(false);
        ui->btnPlayPause->setEnabled(false);
        ui->btnSeekForward->setEnabled(false);
        ui->btnEnd->setEnabled(false);
        break;
    }
}

void PlayerWidget::updateTime(unsigned int time)
{
    _songTime = float(time) / 1000.0f;
    emit songTimeChanged(_songTime);
}

void PlayerWidget::mediaSeek(unsigned int time) {
    _fmodEx->seek(time);
}

void PlayerWidget::setFollowTimeBar(bool b)
{
    emit followTimeBarChanged(b);
}

void PlayerWidget::setDisplayWaveform(bool b)
{
    emit displayWaveformChanged(b);
}

/*void PlayerWidget::emitNewAudiogram(QImage img)
{
    emit newAudiogram(img);
}*/
