/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include <QtGui>
#include "splashwidget.hh"
#include "mainwindow.hh"

int main(int argc, char *argv[])
{
    QApplication::setGraphicsSystem(QString("native"));
    QApplication a(argc, argv);
    a.setApplicationName(QString("FRequency Periodic"));

    QFile f(":/res/css/global.css"); f.open(QFile::ReadOnly);
    a.setStyleSheet(f.readAll()); f.close();

    SplashWidget sw;
    MainWindow mw;

    sw.show();
    a.connect(&sw, SIGNAL(loadingFinished()), &mw, SLOT(showMaximized()));

    return a.exec();
}
