/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef DEF_GLEXTENSIONS
#define DEF_GLEXTENSIONS

#include <QtOpenGL/QtOpenGL>

#include "glext.hh"

#define GL_TEXTURE0 0x84C0
#define GL_TEXTURE1 0x84C1
#define GL_TEXTURE2 0x84C2
#define GL_TEXTURE3 0x84C3
#define GL_TEXTURE4 0x84C4
#define GL_TEXTURE5 0x84C5
#define GL_TEXTURE6 0x84C6
#define GL_TEXTURE7 0x84C7
#define GL_TEXTURE8 0x84C8
#define GL_TEXTURE9 0x84C9
#define GL_TEXTURE10 0x84CA
#define GL_TEXTURE11 0x84CB
#define GL_TEXTURE12 0x84CC
#define GL_TEXTURE13 0x84CD
#define GL_TEXTURE14 0x84CE
#define GL_TEXTURE15 0x84CF
#define GL_TEXTURE16 0x84D0
#define GL_TEXTURE17 0x84D1
#define GL_TEXTURE18 0x84D2
#define GL_TEXTURE19 0x84D3
#define GL_TEXTURE20 0x84D4
#define GL_TEXTURE21 0x84D5
#define GL_TEXTURE22 0x84D6
#define GL_TEXTURE23 0x84D7
#define GL_TEXTURE24 0x84D8
#define GL_TEXTURE25 0x84D9
#define GL_TEXTURE26 0x84DA
#define GL_TEXTURE27 0x84DB
#define GL_TEXTURE28 0x84DC
#define GL_TEXTURE29 0x84DD
#define GL_TEXTURE30 0x84DE
#define GL_TEXTURE31 0x84DF

#define PROC void*
extern PROC procAdresses[50];

//-----------------------------------------------------------------------------
// gl procedure defines
//-----------------------------------------------------------------------------

//Shader GLSL
#define glCreateProgramObject() ((PFNGLCREATEPROGRAMOBJECTARBPROC)procAdresses[0])()
#define glCreateShaderObject(a) ((PFNGLCREATESHADEROBJECTARBPROC)procAdresses[1])(a)
#define glShaderSource(a,b,c,d) ((PFNGLSHADERSOURCEARBPROC)procAdresses[2])(a,b,c,d)
#define glCompileShader(a) ((PFNGLCOMPILESHADERARBPROC)procAdresses[3])(a)
#define glAttachObject(a,b) ((PFNGLATTACHOBJECTARBPROC)procAdresses[4])(a,b)
#define glLinkProgram(a) ((PFNGLLINKPROGRAMARBPROC)procAdresses[5])(a)
#define glUseProgramObject(a) ((PFNGLUSEPROGRAMOBJECTARBPROC)procAdresses[6])(a)
#define glDeleteObject(a) ((PFNGLDELETEOBJECTARBPROC)procAdresses[7])(a)
#define glGetUniformLocation(a,b) ((PFNGLGETUNIFORMLOCATIONARBPROC)procAdresses[8])(a,b)
#define glProgramParameteri(a,b,c) ((PFNGLPROGRAMPARAMETERIEXTPROC)procAdresses[9])(a,b,c)
#define glUniform1i(a,b) ((PFNGLUNIFORM1IARBPROC)procAdresses[10])(a,b)
#define glUniform1f(a,b) ((PFNGLUNIFORM1FARBPROC)procAdresses[11])(a,b)
#define glUniform3f(a,b,c,d) ((PFNGLUNIFORM3FARBPROC)procAdresses[12])(a,b,c,d)
#define glUniform4f(a,b,c,d,e) ((PFNGLUNIFORM4FARBPROC)procAdresses[13])(a,b,c,d,e)

//Frame Buffer Object
#define glGenFramebuffers(a,b) ((PFNGLGENFRAMEBUFFERSEXTPROC)procAdresses[14])(a,b)
#define glGenRenderbuffers(a,b) ((PFNGLGENRENDERBUFFERSEXTPROC)procAdresses[15])(a,b)
#define glBindFramebuffer(a,b) ((PFNGLBINDFRAMEBUFFEREXTPROC)procAdresses[16])(a,b)
#define glBindRenderbuffer(a,b) ((PFNGLBINDRENDERBUFFEREXTPROC)procAdresses[17])(a,b)
#define glDeleteFramebuffers(a,b) ((PFNGLDELETEFRAMEBUFFERSEXTPROC)procAdresses[18])(a,b)
#define glDeleteRenderbuffers(a,b) ((PFNGLDELETERENDERBUFFERSEXTPROC)procAdresses[19])(a,b)
#define glRenderbufferStorage(a,b,c,d) ((PFNGLRENDERBUFFERSTORAGEEXTPROC)procAdresses[20])(a,b,c,d)
#define glFramebufferRenderbuffer(a,b,c,d) ((PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC)procAdresses[21])(a,b,c,d)
#define glFramebufferTexture2D(a,b,c,d,e) ((PFNGLFRAMEBUFFERTEXTURE2DEXTPROC)procAdresses[22])(a,b,c,d,e)

//Points sprite
#define glPointParameterf(a,b) ((PFNGLPOINTPARAMETERFARBPROC)procAdresses[23])(a,b)
#define glPointParameterfv(a,b) ((PFNGLPOINTPARAMETERFVARBPROC)procAdresses[24])(a,b)


//Vertex Buffer Object
#define glGenBuffers(a,b) ((PFNGLGENBUFFERSARBPROC)procAdresses[25])(a,b)
#define glDeleteBuffers(a,b) ((PFNGLDELETEBUFFERSARBPROC)procAdresses[26])(a,b)
#define glBindBuffer(a,b) ((PFNGLBINDBUFFERARBPROC)procAdresses[27])(a,b)
#define glBufferData(a,b,c,d) ((PFNGLBUFFERDATAARBPROC)procAdresses[28])(a,b,c,d)
#define glBufferSubData(a,b,c,d) ((PFNGLBUFFERSUBDATAARBPROC)procAdresses[29])(a,b,c,d)

//Others ..
#define glTexImage3D(a,b,c,d,e,f,g,h,i,j) ((PFNGLTEXIMAGE3DPROC)procAdresses[30])(a,b,c,d,e,f,g,h,i,j)
#define glActiveTexture(a) ((PFNGLACTIVETEXTUREARBPROC)procAdresses[31])(a)

//Debug
#define glGetObjectParameteriv(a,b,c) ((PFNGLGETOBJECTPARAMETERIVARBPROC)procAdresses[32])(a,b,c)
#define glUniform2f(a,b,c) ((PFNGLUNIFORM2FARBPROC)procAdresses[33])(a,b,c)

void InitProcAdresses(const QGLContext *context);

#endif
