;////////////////////////////////////////////////////////////////////////////;
;/ Neo Geo Pocket Color	Include	File						  by Dark Fader	/;
;////////////////////////////////////////////////////////////////////////////;
	cpu	93C141		;Toshiba TLCS-900/H
	maxmode	on

;////////////////////////////////////////////////////////////////////////////;
;/ General Registers														/;
;////////////////////////////////////////////////////////////////////////////;
rWDT		=	6fh		;Watch Dog Timer
WDT_UPDATE	=	4eh		;Value required	to be written to rWDT

rBV		=		6F80h	;Battery Voltage
rSL		=		6F82h	;Sys Lever (Controller Input)
rUSERB	=		6F84h	;User Boot
rUSERS	=		6F85h	;User Shutdown
rUSERA	=		6F86h	;User Answer
rLANG	=		6F87h	;Language
rOSV	=		6F91h	;OS	Version

;////////////////////////////////////////////////////////////////////////////;
;/ User	Program	Interrupt Vectors											/;
;////////////////////////////////////////////////////////////////////////////;
rSWI0	=		6FACh	;Software Interrupt	(SWI 0)	(???)
rSWI1	=		6FB0h	;Software Interrupt	(SWI 1)	(???)
rSWI2	=		6FB4h	;Software Interrupt	(SWI 2)	(???)
rSWI3	=		6FB8h	;Software Interrupt	(SWI 3)
rSWI4	=		6FBCh	;Software Interrupt	(SWI 4)
rSWI5	=		6FC0h	;Software Interrupt	(SWI 5)
rSWI6	=		6FC4h	;Software Interrupt	(SWI 6)
rRTCI	=		6FC8h	;RTC Alarm	Interrupt
rVBI	=		6FCCh	;Vertical Blanking	Interrupt
rZ80I	=		6FD0h	;Interrupt from	Z80
rTI0	=		6FD4h	;Timer Interrupt (8	bit	timer 0)
rTI1	=		6FD8h	;Timer Interrupt (8	bit	timer 1)
rTI2	=		6FDCh	;Timer Interrupt (8	bit	timer 2)
rTI3	=		6FE0h	;Timer Interrupt (8	bit	timer 3)
rSTI	=		6FE4h	;Serial	Transmission Interrupt
rSRI	=		6FE8h	;Serial	Reception Interrupt
rRESVD0	=		6FECh	;Reserved (???)
rEMDMA0	=		6FF0h	;End Micro DMA Int (MicroDMA 0)
rEMDMA1	=		6FF4h	;End Micro DMA Int (MicroDMA 1)
rEMDMA2	=		6FF8h	;End Micro DMA Int (MicroDMA 2)
rEMDMA3	=		6FFCh	;End Micro DMA Int (MicroDMA 3)

;////////////////////////////////////////////////////////////////////////////;
;/ Window Registers															/;
;////////////////////////////////////////////////////////////////////////////;
rWBAH	=		8002h	;WBA.H = Window	Horizontal Origin
rWBAV	=		8003h	;WBA.V = Window	Vertical Origin
rWSIH	=		8004h	;WSI.H = Window	X Size
rWSIV	=		8005h	;WSI.V = Window	Y Size

;////////////////////////////////////////////////////////////////////////////;
;/ Frame Rate Register														/;
;////////////////////////////////////////////////////////////////////////////;
rREF	=		8006h	;REF = Frame Rate Register

;////////////////////////////////////////////////////////////////////////////;
;/ Raster Position Registers												/;
;////////////////////////////////////////////////////////////////////////////;
rRASH	=		8008h	;RAS.H = Raster	Position Horizontal
rRASV	=		8009h	;RAS.V = Raster	Position Vertical

;////////////////////////////////////////////////////////////////////////////;
;/ 2D Status Register														/;
;////////////////////////////////////////////////////////////////////////////;
r2DSR	=		8010h	;Character Over	/ Vblank Status

;////////////////////////////////////////////////////////////////////////////;
;/ 2D Control Register														/;
;////////////////////////////////////////////////////////////////////////////;
r2DCR	=		8012h	;NEG / OOWC	Setting

;////////////////////////////////////////////////////////////////////////////;
;/ Sprite Position Offset													/;
;////////////////////////////////////////////////////////////////////////////;
rPOH	=		8020h	;PO.H =	Position Offset	Horizontal
rPOV	=		8021h	;PO.V =	Position Offset	Vertical

;////////////////////////////////////////////////////////////////////////////;
;/ Scroll Plane	Priority Function											/;
;////////////////////////////////////////////////////////////////////////////;
rPF		=		8030h	;Scroll	plane 1	in front/back

;////////////////////////////////////////////////////////////////////////////;
;/ Scroll Offset Registers													/;
;////////////////////////////////////////////////////////////////////////////;
rS1SOH	=		8032h	;S1SO.H	= Scroll Plane 1 X Scroll Offset
rS1SOV	=		8033h	;S1SO.V	= Scroll Plane 1 Y Scroll Offset
rS2SOH	=		8034h	;S2SO.H	= Scroll Plane 2 X Scroll Offset
rS2SOV	=		8035h	;S2SO.V	= Scroll Plane 2 Y Scroll Offset

;////////////////////////////////////////////////////////////////////////////;
;/ Color Palette RAM													 /;
;////////////////////////////////////////////////////////////////////////////;
_SPRPAL		=	8200h	;Sprite	palettes (K2GE)
_SCR1PAL	=	8280h	;Scroll	1 palettes (K2GE)
_SCR2PAL	=	8300h	;Scroll	2 palettes (K2GE)
_BGCPAL		=	83E0h	;Background	Color Palettes
_WCPAL		=	83F0h	;Window	Color Palettes

;////////////////////////////////////////////////////////////////////////////;
;/ Background Color	Register											 	/;
;////////////////////////////////////////////////////////////////////////////;
rBCR	=		8118h	;BGON /	BGC	Settings

;////////////////////////////////////////////////////////////////////////////;
;/ Mode	Selection Register													/;
;////////////////////////////////////////////////////////////////////////////;
rMSR	=		87E2h	;MODE (K1GE/K2GE Select)

;////////////////////////////////////////////////////////////////////////////;
;/ Memory addresses															/;
;////////////////////////////////////////////////////////////////////////////;
_MAINRAM	=	4000h		;Main work RAM Start Address
_SPRRAM		=	8800h		;Sprite	VRAM Start Address
_SCR1RAM	=	9000h		;Scroll	1 VRAM Start Address
_SCR2RAM	=	9800h		;Scroll	2 VRAM Start Address
_TILERAM	=	0A000h		;Sprite/Scroll Tileset Start Address
_CARTROM	=	200000h		;Cartridge ROM Start Address
_INTROM		=	0FF0000h	;Internal ROM Start	Address

;////////////////////////////////////////////////////////////////////////////;
;/ Screen Defines															/;
;////////////////////////////////////////////////////////////////////////////;
SCRN_X		=	160		;Width of screen in	pixels
SCRN_Y		=	152		;Height	of screen in pixels
SCRN_X_B	=	20		;Width of screen in	bytes
SCRN_Y_B	=	19		;Height	of screen in bytes

SCRN_VX		=	256		;Virtual width of screen in	pixels
SCRN_VY		=	256		;Virtual height	of screen in pixels
SCRN_VX_B	=	64		;Virtual width of screen in	bytes
SCRN_VY_B	=	64		;Virtual height	of screen in bytes

;////////////////////////////////////////////////////////////////////////////;
;/ Controller Input	Defines		(for rSL register)							/;
;////////////////////////////////////////////////////////////////////////////;
CONT_UP		=	0		;Up	direction
CONT_DOWN	=	1		;Down direction
CONT_LEFT	=	2		;Left direction
CONT_RIGHT	=	3		;Right direction
CONT_A		=	4		;A button
CONT_B		=	5		;B button
CONT_OPTION	=	6		;Option	button
CONT_POWER	=	7		;Power button

;////////////////////////////////////////////////////////////////////////////;
;/ System calls																/;
;////////////////////////////////////////////////////////////////////////////;
;"0" = Currently Unknown

VECT_SHUTDOWN			=		00h			;Shutdown (Power OFF)
VECT_CLOCKGEARSET		=		0			;CPU operation clock setting
VECT_INTLVSET			=		0			;Interrupt level setting
VECT_RTCGET				=		02h			;Real time clock - obtain time
VECT_ALARMSET			=		0			;Real time clock - alarm setting during	game operation
VECT_ALARMDOWNSET		=		0			;Real time clock - unit	start up alarm setting
VECT_SYSFONTSET			=		05h			;System	font setting
VECT_FLASHWRITE			=		0			;Flash memory -	data write
VECT_FLASHALLERS		=		0			;Flash memory -	erase all blocks
VECT_FLASHERS			=		0			;Flash memory -	erase specified	blocks
VECT_FLASHPROTECT		=		0			;Flash memory -	protect	specified blocks
VECT_GEMODESET			=		0			;Color LCD color mode setting (color version only)
VECT_COMINIT			=		0			;Initialize	serial communication BIOS
VECT_COMSENDSTART		=		0			;Communication start send BIOS
VECT_COMRECIVESTART		=		0			;Communication start reception BIOS
VECT_COMCREATEDATA		=		0			;Communication create send data	BIOS
VECT_COMGETDATA			=		0			;Communication obtain reception	data BIOS
VECT_COMONRTS			=		0			;Communication allow RTS signal	send BIOS
VECT_COMOFFRTS			=		0			;Communication prohibit	RTS	signal send	BIOS
VECT_COMSENDSTATUS		=		0			;Communication obtain send status BIOS
VECT_COMRECIVESTATUS	=		0			;Communication obtain reception	status BIOS
VECT_COMCREATEBUFDATA	=		0			;Communication obtain create data buffer BIOS
VECT_COMGETBUFDATA		=		0			;Communication write reception obtaining buffer	BIOS

;////////////////////////////////////////////////////////////////////////////;
;/ WatchDogUpdate															/;
;////////////////////////////////////////////////////////////////////////////;
WatchDogUpdate:	macro
	ld		(rWDT),	WDT_UPDATE
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ Shutdown	(Power OFF)														/;
;////////////////////////////////////////////////////////////////////////////;
Shutdown:	macro
	ld		rw3, VECT_SHUTDOWN
	calr	SYSTEM_CALL
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ CPU operation clock setting												/;
;////////////////////////////////////////////////////////////////////////////;
;Change	CPU	speed
ClockGearSet: macro	speed, regen
	ld		rw3, VECT_CLOCKGEARSET
	ld		rb3, speed			;CPU Speed Setting (4 =	384KHz)
	ld		rc3, regen			;Auto Clock	Speed Regeneration (0FFh = off)
	calr	SYSTEM_CALL
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ Real	time clock															/;
;////////////////////////////////////////////////////////////////////////////;
;Return	date/time into (ptr) in	BCD	form
; {Year	(00h-99h), Month (01h-12h),	Day	(01h-31h), Hours (00h-23h),	Mins (00h-59h),	Secs (00h-59h)}
RTCGet:	macro ptr
	ld		rw3, VECT_RTCGET
	ld		xhl3, ptr
	calr	SYSTEM_CALL
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ Load	System font															/;
;////////////////////////////////////////////////////////////////////////////;
;Copy system font to Character tile	RAM	with specified color
SysFontSet:	macro fgcolor, bgcolor
	ld		rw3, VECT_SYSFONTSET
	ld		ra3, fgcolor + (bgcolor<<4)
	calr	SYSTEM_CALL
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ System Call Code															/;
;////////////////////////////////////////////////////////////////////////////;
SystemCallCode:	macro
	push	sr
	ldf		3
	push	xix
	add		w, w		;*4
	add		w, w
	ld		xix, 0FFFE00h
	ld		xix, (xix+w)
	call	(xix)
	pop		xix
	pop		sr
	ret
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ Set NGP or NGPC mode														/;
;////////////////////////////////////////////////////////////////////////////;
OsVersionCode: macro
	cp		(rOSV),	0
	jr		nz,	OSVExit

	res		3, (6f83h)
	ld		(6da0h), 0
OSVExit:
	ret
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ This	macro accept RGB	values from	0-255 in R,G,B Format				/;
;////////////////////////////////////////////////////////////////////////////;
RGBSet:	macro r,g,b
	dw		((b	>> 4) << 8)	+ ((g >> 4)	<< 4) +	(r >> 4)
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ Area	switching macro's (saves/restores PC)								/;
;////////////////////////////////////////////////////////////////////////////;
_ROM		:= _CARTROM
_RAM		:= _MAINRAM
_area		:= "NULL"

area	macro to
_{_area}	:=	$
_area := to
	org	_{_area}
	endm

;////////////////////////////////////////////////////////////////////////////;
;/ ROM header																/;
;////////////////////////////////////////////////////////////////////////////;
	area	"ROM"
	
	db		" LICENSED BY SNK CORPORATION"
	dd		Main
	dw		0				;Cart ID Code
	db		0				;Cart Version
	DB		10h				;System	code (Monochrome =	0x00 / Color = 0x10)
;			"............"
	DB		"TEST		 "	;Cart title	(12	characters)
	DD		0,0,0,0			;Reserved

;////////////////////////////////////////////////////////////////////////////;
;/ Put some	handy functions	in the ROM										/;
;////////////////////////////////////////////////////////////////////////////;
SYSTEM_CALL:
	SystemCallCode
OS_VERSION:
	OsVersionCode
