PROC fall
pusha
mov es, [si+_vaddr]
mov ax, [si+_downfall]
mov cx, 64000
mov di, ax
add di, ax
imul ax,ax, 3
sub cx, ax

mov ax, [si+_elapsed_time]
add [si+_fallstep], ax
cmp word ptr [si+_fallstep], 4
jb @skip_fall
mov word ptr [si+_fallstep], 0

mov ax, [si+_speed_downfall]
add word ptr [si+_downfall], ax
add word ptr [si+_speed_downfall], 8
@skip_fall:
mov al, 1
rep stosb

;if (downfall>64*320) then begin inc(scene); reset_timer; end;}
cmp word ptr [si+_downfall], 64*320
jbe @skip_fall_end
  inc byte ptr [si+_scene]
  call reset_timer
@skip_fall_end:
popa
ret
ENDP fall


PROC open_fill
pusha
mov es, [si+_vaddr]
mov fs, [si+_vaddr2]

mov bx, [si+_elapsed_time]
mov dx, [si+_fillstep]
add dx, bx
cmp dx, 4
jb @skip_add_fill
xor dx, dx
@skip_add_fill:
mov [si+_fillstep], dx

; mov bp, height
movzx si, al     ; num of columns
dec si

@columns:
      mov bx, 65000
      mov dh, es:[si+bx]
      movzx di, dh

      cmp dh, ch ;8
      jbe @skip_nextcolumn_init
         mov byte ptr fs:[si+bx+1], 191
      @skip_nextcolumn_init:

      test dl, dl
      jne @skip_column_inc
      cmp dh, byte ptr fs:[si+bx]
      jae @skip_column_inc
          add dh, 16
          shr dh, cl ;4
          add es:[si+bx], dh
      @skip_column_inc:

      test di, di
      jz @skip_fdraw
      mov ax, si
      imul ax, bp  ;CX=n*height
      imul di, di, 320
      @fdraw:
         cmp di, 64000
         jae @skip_column_draw
         mov bx, bp  ; DX=height
         dec bx
         dec bx
         @column:
            add bx, ax
            mov word ptr es:[di+bx], 2020h
            sub bx, ax
            dec bx
            dec bx
         jns @column
         @skip_column_draw:
      sub di, 320
      jnc @fdraw
      @skip_fdraw:
dec si
jns @columns
popa
ret
ENDP open_fill



