-- title:  Chaos Equations
-- author: Jin X
-- desc:   Fast version with custom palette (4 colors of 3 shades each + 3 gray shades + black) stored inside .tic file, short equation and minimal size
-- script: lua

--cls()
t=4  -- time
P={} -- params

function TIC()
  -- random params
  if t>3 then
    t=-3
    for i=1,12 do
      P[i]=math.random()*2-1
    end
  end
  -- dimming
  for i=0,32639 do
    c=peek4(i)-1
    poke4(i,c<1 and 0 or c%3<1 and 3 or c)
  end
  -- calc
  for w=0,99 do
    c=.01
    x,y=t,t
    for s=0,99 do
      p={x,x*x,y,y*y,t,t*t}
      x,y=t,t
      for i=1,6 do
        x,y=x+p[i]*P[i],y+p[i]*P[i+6]
      end
      if x^2<1 and y^2<1 then
        pix(120+x*120,68-y*120,s*5)
        c=.0001
      end
    end
    t=t+c
  end
end
