; 2Days
; by P_Malin / Bitshifters
; a 256 byte intro for DOS
; part of the LoveByte 2024 countdown ( hence the title - it took me longer than 2 days :D )

;%define SAVE_FRAMES

ORG 256

Result:
    mov 	al,0x13			; set mode 13h
    int 	0x10

    mov     ah, 9 ; print string
    mov     dx,Text
    int     0x21

    ; copy string to store
    push 	0a000h			; get video memory segment in DS for movsd
    pop 	ds				

    push ds
    push es

    xor     si,si
    mov     di,Store
    mov cx, 320*8
    repz movsd

    ; restore segment registers in other order (ES = video mem segment)
    pop ds
    pop es



    ; set palette
    ;jmp NoPal

    xor cx,cx
    push cx
P4:
    mov ax,cx
    mov dx,0x3c8
    out dx,al    ; select palette color
    inc dx
    
    ; saw version
    test al,al
    js Positive
    not al
Positive:

    shl al,1
    xor bx,bx
PL2:
    push ax
    shr al,2
    out dx,al
    pop ax

    mul al
    mov al,ah
    mul al
    mov al,ah
    inc bx
    jpo PL2

    loop P4

NoPal:


    pop di
PixelLoop:

    mov ax,di
    test ax,ax

    jnz SkipInit

    ; ax = frame counter
    pop ax
    inc ax
    push ax

    fninit

    mov 	[si],ax			; move T into a memory location


    fild 	word [si]
    fidiv    word [FP128]   ; [T]
    fldln2                  ; [LN2] [T]
    fmulp                   ; [T]
    fsin                    ; [O]
    fldln2
    fmulp


    fild 	word [si]		; [T] [O]
    fidiv    word [FP128]   ; [T] [O]
    fsincos                 ; [C] [S] [O]

%ifdef SAVE_FRAMES
    call FrameDump
%endif

    hlt
SkipInit:

    xor 	dx,dx			; reset the high word before division
    mov 	bx,320			; 320 columns
    mov 	ax,di			; get screen pointer in AX
    div 	bx				; construct X,Y from screen pointer into AX,DX
    sub 	ax,100			; subtract the origin
    sub 	dx,160			; = (160,100) ... center of 320x200 screen	


    mov 	[si],ax			; move Y into a memory location
    fild 	word [si]		; [Y] [C] [S] [O]
    fidiv    word [FP128]   ; [V] [C] [S] [O]

    mov 	[si],dx			; move X into a memory location
    fild 	word [si]		; [X] [V]  [C] [S] [O]
    fidiv    word [FP128]   ; [U] [V]  [C] [S] [O]

    ;mov     cx,15
    mov     cx,20
IterLoop:                   ; [U] [V] [C] [S] [O]

	; f = abs(f);
    fabs                   ; [U] [V] [C] [S] [O]

    fxch st1                ; [V] [U] [C] [S]  [O]
    fabs
    fxch st1               ; [U] [V] [C] [S]  [O] 
                            

    ; see mathtest.asm

    ; f.x=f.x-o; 
    fsub st4                   ; [U] [V] [C] [S] [O]

    ; see mathtest.asm

    ; n.x = f.x*sin(a)+f.y*cos(a);
    ; n.y = f.x*cos(a)-f.y*sin(a);
    ; f = n; 


    fld st0                 ; [U] [U] [V] [C] [S]  [O]

    fmul st4           ; [U*S] [U] [V] [C] [S]  [O]
    fld st2                 ; [V] [U*S] [U] [V] [C] [S]  [O]
    fmul st4           ; [V*C] [U*S] [U] [V] [C] [S] [O]
    faddp                   ; [V*C+U*S] [U] [V] [C] [S] [O]

    fxch st2                ; [V] [U] [V*C+U*S] [C] [S] [O]
    fmul st4               ; [V*S] [U] [V*C+U*S] [C] [S] [O]
    fxch st1                ; [U] [V*S] [V*C+U*S] [C] [S] [O]
    fmul st3               ; [U*C] [V*S] [V*C+U*S] [C] [S] [O]
    fxch st1               ; [V*S] [U*C] [V*C+U*S] [C] [S] [O]
    fsubp                   ; [U*C - V*S] [V*C+U*S] [C] [S] [O]

    loop IterLoop

    fmul 	st0,st0		; [U^2] [V] [C] [S] [O]

    fxch st1             ; [V] [U^2] [C] [S] [O]

    fmul 	st0,st0		; [V^2] [U^2] [C] [S]

    faddp       		; [D] [C] [S]

    fsqrt

    fimul   word [FP256]
    fistp 	word [si]		; [C] [S]

    ; text bit

    pop bx ; get frame count in bx
    push bx

    push si
    mov     ax, di
    add     ax,bx
    and     ax,4096-1
    add     ax,Store
    mov     si,ax
    mov     cl,[ds:si]
    pop si

    mov 	ax,[si]			; get the result from memory

    add al,bl
    shl cl,3
    add al,cl

    stosb					; write al to screen (DI) and increment DI

    jmp PixelLoop			; next pixel

FP128:
    dw 128

FP256:
    dw 256    

Text:
    db "2 Days$"

%ifdef SAVE_FRAMES
%include "c\source\LIB\FRDUMP.ASM"
%endif

Store:

