; DLIFEx.ASM   - Classic game of Life .. (C) A.Millett 2014. Freeware.
;
; Released as free/open software under the terms of the GNU GPL3 license.  
;      See:  www.gnu.org/licenses/gpl-3.0.html 
;
; Simple DOS/VGA graphics program in NASM, showing some basic asm methods.
;  assemble with: NAS2COM name
;           or    NASM -f bin name.asm -o name.com
;
;  Imp simple m/code version with rnd start
; ->DLIFE1.ASM  (14.9.14)
;  imp PROG_EXTRA for extra functions/min demo switch
; ->DLIFE2.ASM  (14.9.14)
;  Assort improvements/optomisations..
; ->DLIFE3.ASM  (14.9.14) (Min 120 bytes)
;  Imp full edit version
; ->DLIFE4.ASM  (14.9.14) 
;  Remove PROG_EXTRA, imp sep DLIFE5M.ASM min ver
; ->DLIFE5M.ASM  (15.9.14) 
; ->DLIFE6M.ASM  (2.5.2025) 


endpos equ 56000		; end pos on screen
vdux   equ 320			; Width of VGA screen
xink   equ  11			; Ink for cells (must be odd #)
VGAseg equ 0xA0A0		; VGA segment (Leave top lines for text)

  org 100h

  mov	ax,19	 	; Screen mode 19 - VGA 320x200x256
  int 10h

InitLife:
  mov ax,VGAseg
  mov es,ax		; ES=VGA segment (Leave top lines for text)

RandFill:		; Fill VDU with random data (CX is seed)

  mov bh,(endpos-vdux*8)/256		; Start pos..

loopRnd:		; Simple pseudo rnd pattern generator 
  sub ax,bx
  xor al,ah		; Mash up AX for rnd..
  mov [es:bx+vdux*4],al
  dec bx	
  jne loopRnd		; if (BX!=0) goto loopRnd

GenLife:		; Gen next generation
  mov bh,(endpos/256)
  push bx

CopyLoop:		; Copy bit 0 of VDU mem to [pmem]..
  mov al,[es:bx]
  and al,1
  mov [bx+pmem],al
  dec bx
  jne CopyLoop

  pop bx		; mov bx,endpos

loopGen:

%if 0				; Faster, simpler code..

  mov cl,xink			; Set default ink colour
  mov al,[bx+pmem]		; Count surrounding cells
  add al,[bx+pmem+1]
  add al,[bx+pmem+2]
  add al,[bx+pmem+vdux]
  add al,[bx+pmem+vdux+2]
  add al,[bx+pmem+vdux+vdux]
  add al,[bx+pmem+vdux+vdux+1]
  add al,[bx+pmem+vdux+vdux+2]
  cmp al,4			; AL is count of surrounding cells
  jge cellDie			; AL>=4, die..
  cmp al,2
  jl  cellDie			; AL<2, die
  jne cellLive			; AL=3, live
  mov al,[bx+pmem+vdux+1]	; AL=2 - was cell occupied?
  or al,al
  jne cellLive			; yes, live..
cellDie:
  mov cl,0			; Clr cell

%else				; Smaller, slower code

  mov cx,0x0300+xink		; Set default ink colour (CL) & loop counter (CH)
  xor ax,ax
  push bx
loopGen2:			; Looped version (smaller)
  add al,[bx+pmem]		; Count surrounding cells
  add al,[bx+pmem+1]
  add al,[bx+pmem+2]
  add bx,vdux
  dec ch
  jne loopGen2
  pop bx
  mov ah,[bx+pmem+vdux+1]	; Keep center cell val (AH)
  sub al,ah
  cmp al,4			; AL is count of surrounding cells
  jge cellDie			; AL>=4, die..
  cmp al,2
  jl  cellDie			; AL<2, die
  jne cellLive			; AL=3, live
  or ah,ah			; AL=2 - was center cell occupied?
  jne cellLive			; yes, live..
cellDie:
  mov cl,0			; Clr cell

%endif

cellLive:
  mov [es:bx+vdux+1],cl		; Update cell on VDU
  dec bx
  jne loopGen

  mov ah,1
  int 16h		; Keyboard hit?
  je GenLife		; no, next generation
  
  ret			; Quit GenLife subroutine.


section .bss		; Uninitialised data sect..

temp: resb vdux
pmem: resb endpos+vdux*4
