; DLIFEx.ASM   - Classic game of Life .. (C) A.Millett 2014. Freeware.
;
; Released as free/open software under the terms of the GNU GPL3 license.  
;      See:  www.gnu.org/licenses/gpl-3.0.html 
;
; Simple DOS/VGA graphics program in NASM, showing some basic asm methods.
;  assemble with: NAS2COM name
;           or    NASM -f bin name.asm -o name.com
;
;  Imp simple m/code version with rnd start
; ->DLIFE1.ASM  (14.9.14)
;  imp PROG_EXTRA for extra functions/min demo switch
; ->DLIFE2.ASM  (14.9.14)
;  Assort improvements/optomisations..
; ->DLIFE3.ASM  (14.9.14) (Min 120 bytes)
;  Imp full edit version
; ->DLIFE4.ASM  (14.9.14) 
;  Remove PROG_EXTRA, imp sep DLIFE5M.ASM min ver
; ->DLIFE5.ASM  (15.9.14) 
; ->DLIFE6.ASM  (2.5.2025) 
;

endpos equ 56000		; end pos on screen
vdux   equ 320			; Width of VGA screen
xink   equ  11			; Ink for cells
VGAseg equ 0xA0A0		; VGA segment (Leave top lines for text)

keySpace equ 32
keyEnter equ 13

keyUp    equ 'H'
keyDown  equ 'P'
keyLeft  equ 'K'
keyRight equ 'M'


  org 100h

;---------------------------------------------------------------------------
; MainProg - menu
;---------------------------------------------------------------------------

MainProg:
  call MainClr
  call InitLife

MainAuto:
  call GenLife
  mov ah,1
  int 16h		; Keyboard hit?
  je MainAuto		; no, next generation

keyloop:		; Get a char in (al), loop till key hit..

  mov dl,255
  mov ah,6
  int 21h

  mov cx,VGAseg
  mov es,cx		; ES=VGA segment

  mov bx,[cursorPos]	; Flash edit cursor
  mov dl,[es:bx]
  add dl,16
  mov [es:bx],dl

  mov cx,[xrnd]		; Jumble up rnd seed..
  inc cx
  mov [xrnd],cx

  cmp al,'a'		; 'a' - Auto run
  je  MainAuto
  cmp al,27		; ESC - quit
  je  MainExit

  cmp al,keyEnter	; ENTER, single step
  jne Main2
  call GenLife
  jmp keyloop

Main2:			
  cmp al,'r'		; 'r' - random fill?
  jne Main3
  call RandFill
  jmp keyloop

Main3:
  cmp al,'c'		; 'c' - Clear screen
  jne Main4
  call MainClr
  jmp keyloop

Main4:			; SPACE - Toggle current edit pixel
  mov bx,[cursorPos]	; BX=Cursor pos
  cmp al,keySpace		; 		
  jne Main4b
  mov al,[es:bx]
  xor al,xink		; Flip pixel
  mov [es:bx],al
  jmp keyloop
  
Main4b:			; Cursor keys, find dir..
  xor dx,dx		; DX=Cursor Direction
  cmp al,keyUp
  jne Main5
  sub dx,vdux
Main5:
  cmp al,keyDown
  jne Main6
  mov dx,vdux
Main6:
  cmp al,keyLeft
  jne Main7
  dec dx
Main7:
  cmp al,keyRight
  jne Main8
  inc dx

Main8:
  or dx,dx		; No new dir..
  je keyloop  
  mov al,[es:bx]
  and al,15
  mov [es:bx],al
  add bx,dx
  mov [cursorPos],bx
  jmp keyloop

MainExit:
  mov	ax,3		; Screen mode 3 - Text 80x25
  int 10h

  ret			; Quit prog.


MainClr:
  mov	ax,19	 	; Screen mode 19 - VGA 320x200x256
  int 10h

  mov dx,msg	 	; Print a message
  mov ah,9
  int 21h
  ret

;---------------------------------------------------------------------------
; 
;---------------------------------------------------------------------------

InitLife:
  mov cx,VGAseg
  mov es,cx		; ES=VGA segment (Leave top lines for text)

RandFill:		; Fill VDU with random data (CX is seed)

  mov ax,cx
  mov bx,vdux*2		; Start pos..

loopRnd:		; Simple pseudo rnd pattern generator 
  sub ax,bx
  sal ax,1
  xor al,ah		; Mash up AX for rnd..
  sub ax,cx
  mov [es:bx],al
  inc bx	
  cmp bx,endpos
  jne loopRnd		; if (BX<320) goto loopX
  ret

GenLife:		; Gen next generation
  mov bx,endpos

CopyLoop:		; Copy bit 0 of VDU mem to [pmem]..
  mov al,[es:bx]
  and al,1
  mov [bx+pmem],al
  dec bx
  jne CopyLoop

  mov bx,endpos

loopGen:
  mov cl,xink			; Set default ink colour
  mov al,[bx+pmem]		; Count surrounding cells
  add al,[bx+pmem+1]
  add al,[bx+pmem+2]
  add al,[bx+pmem+vdux]
  add al,[bx+pmem+vdux+2]
  add al,[bx+pmem+vdux+vdux]
  add al,[bx+pmem+vdux+vdux+1]
  add al,[bx+pmem+vdux+vdux+2]
  cmp al,4			; AL is count of surrounding cells
  jge cellDie			; AL>=4, die..
  cmp al,2
  jl  cellDie			; AL<2, die
  jne cellLive			; AL=3, live
  mov al,[bx+pmem+vdux+1]	; AL=2 - was cell occupied?
  or al,al
  jne cellLive			; yes, live..
cellDie:
  mov cl,0			; Clr cell
cellLive:
  mov [es:bx+vdux+1],cl		; Update cell on VDU
  dec bx
  jne loopGen

  ret			; Quit GenLife subroutine.



section .data		; Initialised data section

msg:
  db ' Cmd(acr,Crsr,RET,SPC,ESC) Dlife(C)AM!$'

xrnd: dw 1234

cursorPos: dw 0x7DA0	; Cursor pos (def center of screen)

section .bss		; Uninitialised data sect..

temp: resb vdux
pmem: resb endpos+vdux*4
