; Metropolis by MX^Addict 2023 (mxadd@mxadd.org)

;
; Config
;
%define TESTKEYEXIT    1				; Exit on keypress
%define RESTORETXTMODE 0				; Restore text mode on exit (usefull for debugging)
%define VSYNC          0                ; VSync at 70Hz
%define ASSUMEREGS     1                ; Assume: ax=0 bx=0 cx=255 si=100h
%define USEMUSIC       1				; Music runtime
%define FLYINGCARS     1                ; Flying cars ?
%define MOVINGCARS     1                ; Moving cars ?
%define POSTCOLORIZE   1                ; Post-colorize
%define SCROLLER       1                ; Scroller

BITS 16
org 100h

%define all_vars 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
; Entry point
;
start:

		; ax=0 bx=0 cx=255 si=100h (if assumed)

		; Init gfx

		mov     al, 0x13
		int     0x10
%if !SCROLLER
		push    0xa000
		pop     fs
%else
        mov     dx, 0xa000
        mov     fs, dx
        push    ds
        mov     ds, dx
%endif
		; Grayscale palette (64 shades of gray, accross 0...127 range, then 64 shades of red accross 128...255 range)

		mov     dx, 0x3c8

%if !ASSUMEREGS
%if !SCROLLER
		mov     si, dx					; Frame counter (must be > 100, so use dx value now)
%endif
		mov     cx, 255
        xor     bx, bx
%endif

		salc                            ; ax = 0
        out     dx, al
		inc		dx						; 0x3c9 - palette port

.palloop:
		mov     al, cl                  ; color index
		neg     al
		shr     al, 1
		out     dx, al                  ; R [0-63]
        test    cl, 0x80
        jnz     .pallnr
        xor     al, al
.pallnr:
		out     dx, al                  ; G [0-63]
		out     dx, al                  ; B [0-63]
		loop	.palloop
										; al == 0, cl == 0, dx == 0x3c9, si >= 0x100

%if SCROLLER
        ; 0xa0000:0x0000 to 0xa0000:0xffff is set to 0 at this point
        ; Print text and grab it into memory to use as scroller
        ; Assume es == cs      

        ; First part of text

		mov     bp, ScrollText          ; es:bp will be the address of text
		mov     ah, 0x13                ; Write string (al is already 0)
		mov     bl, 0x3F                ; Color (bh is already 0)
		mov     cl, 5                   ; Text len
        xor     dx, dx                  ; dh - Row, dl - Column
		int     0x10                    ; Print text from es:bp onto screen

        ; Second part of text with different color

        mov     dx, 4
        add     bp, dx
	    mov     bl, 0xFE
        int     0x10
        sub     bp, dx
        
        ; Transfer this data into memory fragment

        mov     cx, 320*16
        mov     si, si
        mov     di, bp
        rep     movsb
        pop     ds
%endif		

		; Room for temporary vars (if any)

		mov     bp, sp

		; Install music interrupt (will be called at 18.2 Hz)
		
%if USEMUSIC
		mov 	dx, .music			
		mov 	ax, 0x251C
		int 	0x21
%endif

		; Main loop

.top:

%if VSYNC

		; VSync

		mov		dx, 0x3da
.vsync:
		in		al, dx
		and		al, 8
		jz		.vsync
%endif

		inc     si						; next frame
		mov     di, 58880               ; frame buffer offset
		mov     cx, -100                ; y position (count backwards)

%if TESTKEYEXIT

		; Wait for key

		in      al, 0x60				; read a character from keyboard into AL
		dec     al
		jnz     .yloop                  ; return to top of loop if AL != 1 (ESC)

%if RESTORETXTMODE

		; Restore text mode (for debugging only)

		mov		ax, 0x3
		int		0x10
%endif

		; End!

		ret
%endif

		; YLoop

.yloop:

		mov     bx, -160                ; x position (count backwards)

		; XLoop

.xloop:

		dec		di						; decrease frame buffer offset (we draw from bottom-right to top-left)
		jz      .top

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		; bp == stack frame
		; si == frame index
		; di == pixel position [0 - 320*200]
		; bx == X [-160 ... 160]
		; cx == Y [-100 ... 100]
		; [fs:di] == current pixel address
		; dx == free
		; ax == free

       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		pusha                       ; sp -= 16, [AX, CX, DX, BX, SP, BP, SI, DI]

        xor     cx, cx
        mov     es, cx
        mov     ds, cx
        push    bp

.PixelLoop:

        ; cx -- RayZ

        pop     bp

        ; at top: bp = sp, then: pusha (sp-16)  [AX(2), CX(4), DX(6), BX(8), SP PREV(10), BP(12), SI(14), DI(16)]
		; bx == X [-160 ... 160]
		; cx == Y [-100 ... 100]
        ; dx - SumX
        ; ax - SumY

        mov     ax, [bp - (all_vars+8)]
        add     ax, ax
        mov     dx, es
        add     ax, dx
        mov     es, ax
        sar     ax, 6

        mov     bx, [bp - (4+all_vars)]
        mov     dx, ds
        add     bx, dx
        mov     ds, bx
        sar     bx, 6

        push    bp

        ; ax - RayX
        ; bx - RayY
        ; cx - RayZ

        mov     dx, ax
        sar     dx, 15
        mov     di, ax
        xor     di, dx
        sub     di, dx

        ; di - abs(RayX)

        add     bx, 16
        mov     bp, si
        add     bp, cx
 
        ; ax - RayX
        ; bx - RayY
        ; cx - RayZ
        ; di - abs(RayX)
        ; si - Scrl
        ; bp - RayZ+Scrl
        ; dx - free

        ; -- Road --

        ; if (RayY < 0) break;

        test    bx, bx
        jl      .BreakLoop

        ; if (abs(RayX) > 64 && RayY < 10) break;

        cmp     di, 64
        jle     .ContinueLoop00
        cmp     bx, 10
        jge     .ContinueLoop04
        jmp     .BreakLoop

.ContinueLoop04:

        ; -- Buildings --

        ; ax - RayX
        ; bx - RayY
        ; cx - RayZ
        ; di - abs(RayX)
        ; si - Scrl
        ; bp - RayZ+Scrl
        ; dx - free

        ; if ((AbsRayX&256) && ((RayZ+Scrl)&64) && RayY < ((AbsRayX+(RayZ+Scrl))&255)) break;

        test    di, 256
        jz      .ContinueLoop05

        test    bp, 64
        jz      .ContinueLoop05

        lea     dx, [bp+di]         ; dx - AbsRayX+RayZ+Scrl
        xor     dh, dh              ; & 255
        cmp     bx, dx              
        jge     .ContinueLoop05
        jmp     .BreakLoop

.ContinueLoop05:

        ; if ((AbsRayX&512) && ((RayZ+Scrl)&256) && RayY < ((AbsRayX+(RayZ+Scrl))&1023)) break;

        test    di, 512
        jz      .ContinueLoop06

        test    bp, 256
        jz      .ContinueLoop06

        and     dh, 3               ; dx - AbsRayX+RayZ+Scrl
        cmp     bx, dx
        jge     .ContinueLoop06
        jmp     .BreakLoop

.ContinueLoop06:

        ; if ((AbsRayX& 64) && (((RayZ+Scrl)+360)&128) && RayY < ((AbsRayX+((RayZ+Scrl)+360))&1023)) break;

        test    di, 64
        jz      .ContinueLoop07

        lea     dx, [bp+360]        ; dx - RayZ+Scrl+360
        test    dl, dl
        jns     .ContinueLoop07

        add     dx, di              ; dx - AbsRayX+RayZ+Scrl+360
        and     dh, 3
        cmp     bx, dx
        jge     .ContinueLoop07
        jmp     .BreakLoop

.ContinueLoop07:
.ContinueLoop00:

%if MOVINGCARS
        ; -- Cars (boxes) on ground level --

        ; ax - RayX
        ; bx - RayY
        ; cx - RayZ
        ; di - abs(RayX)
        ; si - Scrl
        ; bp - RayZ+Scrl (free if needed)
        ; dx - free

        ; if (RayY < 16 && ((AbsRayX-50)&0xB0) == 0xB0) ...

        cmp     bx, 16
        jge     .ContinueLoop01
        lea     dx, [di-50]
        and     dl, 0xB0
        cmp     dl, 0xB0
        jne     .ContinueLoop01

        ; if (RayX > 0 && ((RayZ-Scrl)&32)) break;

        test    ax, ax
        js      .ContinueLoop02
        mov     dx, cx
        sub     dx, si
        test    dl, 32
        jz      .ContinueLoop02
        jmp     .CarLoop

.ContinueLoop02:

        ; if (RayX < 0 && ((RayZ+(Scrl<<1))&32)) break;

        test    ax, ax
        jns     .ContinueLoop01
        mov     dx, si
        add     dx, dx
        add     dx, cx
        test    dl, 32
        jz      .ContinueLoop01
        jmp     .CarLoop

.ContinueLoop01:
%endif

%if FLYINGCARS
        ; ax - RayX
        ; bx - RayY
        ; cx - RayZ
        ; di - abs(RayX)
        ; si - Scrl
        ; bp - RayZ+Scrl (free if needed)
        ; dx - free

        ; -- Flying cars (boxes) --

        ; if (RayY > 116 && RayY < 148 && ((RayZ+Scrl)&0xB0) == 0xB0 && ((RayX+(Scrl<<3))&128)) break;

        cmp     bx, 116
        jle     .ContinueLoop08
        cmp     bx, 148
        jge     .ContinueLoop08

        mov     dx, bp
        and     dl, 0xB0
        cmp     dl, 0xB0
        jne     .ContinueLoop08

        mov     dx, si
        sal     dx, 3
        add     dx, ax
        test    dl, dl
        js      .ContinueLoop08
        jmp     .BreakLoop

.ContinueLoop08:
%endif

        ; Inner loop maintance

        inc     cl
        jnz     .PixelLoop

.CarLoop:
        cmp     di, 64
        jge     .BreakLoop
        mov     ch, 128

.BreakLoop:

        neg     cl
    
        ; ax - RayX
        ; bx - RayY
        ; cl - ~RayZ, ch is 0 or 128 (128 indicates on-ground car)
        ; di - abs(RayX)
        ; si - Scrl
        ; bp - RayZ+Scrl (free if needed)
        ; dx - free

%if POSTCOLORIZE
    
        ; Road is darker
        ; if (AbsRayX < 64 && RayY <= 0) cl >>= 1;

        cmp     di, 64
        jge     .PostColor00
        test    bx, bx
        jns     .PostColor00
        shr     cl, 1
.PostColor00:

        ; Buildings are darker
        ; if (AbsRayX >= 64 && AbsRayX < 70 && RayY <= 10) cl >>= 2;

        cmp     di, 64
        jl      .PostColor01
        cmp     di, 70
        jge     .PostColor01
        cmp     bx, 10
        jg      .PostColor01
        shr     cl, 2
.PostColor01:

        ; Road strips - negative
        ; if (AbsRayX < 5 && RayY <= 0 && ((RayZ+Scrl)&64)) cl = ~cl;

        cmp     di, 5
        jge     .PostColor02
        test    bx, bx
        jns     .PostColor02
        test    bp, 64
        jz      .PostColor02
        not     cl
.PostColor02:

        ;
        ; Palette is divided into Grayscale[0-127] Redscale[128-255]
        ; We want cars to be red
        ;
        shr     cl, 1
        add     cl, ch

%endif

        pop     bp

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		pop		di
        push    di        
		mov		[fs:di], cl
		popa

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		; Loop maintance

		inc     bx                              ; next X
		cmp     bx, 160
		jne     .xloop
		inc     cx                              ; next Y
		jmp     .yloop

		;; EOP
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
%if USEMUSIC
		
; Music interrupt	
; Called ~18.2 times per second (every 55ms)
		
.music:
	pusha

    ;
    ; Load counters, they are in code segment at start (89E5 - [mov bp,sp])
    ; We will never call this code after interrupt instalation, so we may overwrite it anyway
    ;
    mov 	bx, [cs:start]

%if SCROLLER

    ; Blit scroll at bottom

    movzx   di, bl    
    add     di, 58880+(320*2)
    mov     cx, 320*12
    mov     si, ScrollText
    
.cpyloop:
    mov     al, [cs:si]
    mov     [fs:di], al
    inc     si
    inc     di
    loop .cpyloop
%endif

    ; Midi preps

	mov 	dx, 0x331
	mov 	al, 0x3F
	out 	dx, al
	dec 	dx

    ; Call Instrument 112 with note 24 and loudness 64 every 32 steps on channel 0

    test    bl, 0x1F
    jnz 	.nonote0

	    mov     al, 0xC0		; change instrument on channel 0
	    out     dx, al

	    mov     al, 122	        ; to this instrument (indexes of midi instruments http://www.midi.org/techspecs/gm1sound.php)
	    out     dx, al

	    mov     al, 0x90		; play note on channel 0
	    out     dx, al

        mov     al, 24          ; play THIS note
	    out     dx, al

	    mov     al, 64			; play it THAT loud
	    out     dx, al
		
.nonote0:

    ; Call Instrument 52 with note 24 or 36 and loudness 128 every 16 steps on channel 10

    test    bh, 0xF
    jnz 	.nonote1

	    mov     al, 0xCA		; change instrument on channel 10
	    out     dx, al

	    mov     al, 52	        ; to this instrument (indexes of midi instruments http://www.midi.org/techspecs/gm1sound.php)
	    out     dx, al

	    mov     al, 0x9A		; play note on channel 10
	    out     dx, al

        mov     al, 24          ; play THIS note
        test    bh, 0x10
        jz      .nochange
        mov     al, 36
.nochange:
	    out     dx, al

	    mov     al, 127			; play it THAT loud
	    out     dx, al
		
.nonote1:

    ;
    ; Increment counters and save them
    ;

    inc     bl
    inc     bh
	mov 	[cs:start], bx
	popa
	iret

%endif

%if SCROLLER
ScrollText: 
    db "LoveByte!"
%endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; EOF