cpu 386
org	0100h

;WIDTH equ 1024
;HEIGHT equ 768
;MODE equ 118h			;1024x768x32bpp


WIDTH equ 320
HEIGHT equ 200
MODE equ 10fh			;320x200x32bpp


;Setup vesa video mode.
mov	ax,4f02h
mov bx, MODE
int	10h

push 0xa000
pop es

;Enable the speaker
mov     al, 00000011b  
out     61h, al

nextFrame:
;bx keeps zero

;Reset frame writer
xor di, di
;DX holds the active vesa page
mov dx, di


mov bp, HEIGHT
nextRow:

mov cx, WIDTH
nextPixel:

or di,di
jnz skippage

;Set the next window index
mov ax, 0x4f05
xor bx,bx
int 10h

inc dx

skippage:

;cx and bp contain the screen coordinates
;Do math with them
pusha

;bp = -14
;cx = -6
;si = -16
;ax = -4

fninit

mov si, siOffset
;Load time
fild word [bx-16]
fidiv word [si-siOffset+timeScale]

;Generate uv coordinates
fild word [bx-6]
fidiv word [si-siOffset+axisScale]
fild word [bx-14]
fidiv word [si-siOffset+axisScale]
;x, y, time

;Generate the id
fld st1
frndint
fimul dword [si-siOffset+xScale]

;y1, x, y, time
fld st1
frndint
fimul dword [si-siOffset+yScale]
;x1, y1, x, y, time
fmulp st1

fsin
fimul word [si-siOffset+axisScale]
;Add the timecount
fadd st3


call cosScale

;id, x, y,time

;Determine the size of the square, based on the id and xy
fxch st2

;y, x, id, time
mov cx, 2
axisloop:

fmul dword [si-siOffset+colorScale]
call cosScale

fmul st2

fcom dword [si-siOffset+edge]
FSTSW AX
;Scale by 5
fdiv dword [si-siOffset+edge]

sahf
jb bigger
;Clear the stack and load a 1
fstp st0
fld1
bigger:
;Swap x and y for the loop
fxch st1

loop axisloop

;combine x and y into a final result

fmulp st1

;scale, id, time

;Now determine some colors
;Just fading in rgb based on offsetted cosines

mov cl, 3
colorLoop:
fild word [si]

fadd st3
fadd st2
fadd st2
fadd st2
call cosScale
;red, scale, id, time
fmul st1
fimul word [fullScale]
;Store them behind the offsets
fistp word [si+40]

;Next color
;inc si
;inc si
lodsw

loop colorLoop

popa

;Copy the resulting 3 bytes
push si

mov si, siOffset + 40
movsb
inc si
movsb
inc si
movsb
;Skip final byte
inc di

pop si

dec cx
jnz nextPixel

dec bp
jnz nextRow

;Wait for vsync
mov dx,3dah
sync:
in al,dx
test al,8
jz sync

;si is time keeper
inc si

;Cheap routine to get a few different beeps
mov     al, 0xa6		;timer 2, mode 3, hi byte only
out     43h, al         ; a new countdown value

mov di, si

and di, 15
test si, 32+16
jnz skipslow
and di, 7
skipslow:

mov al, [di+beeps]
out 42h, al
          

skipsound:



jmp nextFrame


;Scale fcos(st0)*0.5 and add 0.5
cosScale:
fcos
fmul dword [half]
fadd dword [half]
ret

beeps:

;db 34, 50, 58, 23, 44, 46, 46, 64
db 74, 60, 68, 45, 44, 66, 66, 44
db 10, 20, 30, 40, 50, 60, 70, 80


edge:
dd 0.2
siOffset:
half:
dd 0.5

colorScale:
dd 6.2831


fullScale:
dw 250
axisScale:
;dw 13
timeScale:
dw 13
yScale:
dw 17
xScale:
dw 113


