; RMDAtro, 128 byte intro (c) IlII / RMDA / 2020
; DataMatrix invitation code to website https://rmda.su (can be scanned by mobile)
; russkie idut...

; FASM

        org 100h

        ; ax=bx=0, cx=0FFh, di=sp=0FFFEh, df=0

start:
        int 10h                 ; 40x25 text mode

        push 0B800h
        pop es                  ; es = video segment

        mov sp,0C1F7h           ; DataMatrix color mask (white-blue-red)

redraw:
        mov dx,3C8h             ; palette color index
        out dx,al               ; 0
        mov si,matrix-2
        inc dx                  ; 3C9h - palette components
        outsb
        outsb
        out dx,al               ; set yellow background

        stosw                   ; set di = 0
        stosw                   ; hide cursor

        ; Draw data matrix (si = matrix)
        mov di,((12-7)*40 + (20-7))*2 + 1 ; starting position on screen
        mov cl,14               ; number of rows
row:
        lodsw                   ; load next data from matrix
        xchg bp,ax
        mov bl,40               ; number of columns
col:
        shr bp,1                ; extract next bit
        salc
        and ax,sp               ; al = 0 or color from low byte of sp (yeah, this is color, not char, because di is odd)
        stosw                   ; output cell

        dec bx
        jnz col                 ; next column

        loop row                ; next row

        ; Delay
        mov cl,24h              ; 2 sec
        sar sp,cl               ; sar sp,4: 0C1F7h --> 0FC1Fh (5=odd) --> 0FFC1h (3=odd) --> 0FFFCh (6=even)
@@:     hlt
        loop @B
        jpo redraw

        ; Alarm (si = midi)
        mov dl,31h              ; 331h - midi command
        outsb
        dec dx                  ; 330h - midi data
        mov cl,midisize
        rep outsb               ; send midi commands

alarm:
        mov al,0E0h             ; Pitch Wheel Change
        out dx,al

        mov al,cl               ; al = cl
@@:     inc cx                  ; inc cx - double speed on tone increase, dec cx - double speed on tone decrease, move any of them above (before 'mov al,cl') for constant speed
        xor al,0FFh             ; al = 0...7Fh --> 7Fh...0
        js @B
        test al,40h             ; sf = of = 0
        jnz skip                ; don't touch the pitch if al >= 40h

        out dx,al               ; LSB
        out dx,al               ; MSB (tone increase with on cl = 0FFh...0C0h (al = 0...3Fh), constant tone on cl = 0BFh...40h, tone decrease on cl = 3Fh...0)

skip:   hlt
        jge alarm               ; jmp (jge jumps if sf = of) - this opcode is also used as red and green components of background color palette

; DataMatrix bit code
matrix  dw 5461,9325,2699,10583,7929,15695,775
        dw 13779,6579,12343,3511,15669,6275,16383

; Midi command and data
o = 6                           ; Upper octave of high C# and G# (5 = 1st, 6 = 2nd, etc)
r = 12                          ; Alarm tone range
        db 3Fh                  ; enter UART mode (--> 331h)
mididata:
        db 0B0h,101,0           ; RPN MSB 0
        db 0B0h,100,0           ; RPN LSB 0 (Pitch Bend Sensitivity)
        db 0B0h,6,r             ; Data Entry MSB (r semitones)
;        db 0B0h,38,0            ; Data Entry LSB (0 cents) - not so important, can be commented
;        db 0B0h,91,127          ; Effect Control 1 (Reverb Send Level, max) - doesn't work on Windows GS midi(?), can be commented
        db 0C0h,50              ; Program Change (50 - Synth String 1)
        db 90h,o*12+8,7Fh       ; Note on (-> G#r)
        db 90h,o*12+1,7Fh       ; Note on (-> C#r)
        db 90h,(o-1)*12+1,7Fh   ; Note on (-> C#r-1)
midisize = $-mididata
