;demozoo ad
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: m.a.d.e.s - nightkiller

;i had the idea for a demozoo ad for quite a while but never managed to find a
;concept that actually fits. after i came up with a nice message i simply tried
;how a cube in textmode would look like. and it fits imho even though there is
;heavy re-use of code. it also reminds me on my intro "the eye of aldebaran"
;but i think it works the way it should. and in the end: it does not try to be
;more than a little ad for a demoscene site :)

org 100h
use16

;assuming: ax = bx = 0 / cx = 255

;vars used:
;bp+2  = degrees for rotation/speed of movements
;bp+4  = x
;bp+6  = y
;bp+8  = z

;bp+10 = x after rotation
;bp+12 = y after rotation
;bp+14 = z after rotation

start:   push 0b800h ;textmooooooode
         pop es
         push 08000h ;vscreen
         pop ds
;        mov ax,03h ;needed if starts NOT in textmode
;        int 10h
         mov ax,1112h  ;80x50 so 8000b buffer needed
                       ;1byte char and 1byte attributes
         int 10h

         mov ax,1003h  ;disable blink (128) ---> full 16 bg colors
                       ;so syntax = color (0..15) + 16*background color (0..15 = 16 colors)
         int 10h

;fninit ;safety what? runs on my xp machine, under DosBox and VMWare
        ;so it might run on other systems too.

main:

;draw bar in middle with nice pastel color
mov bx,160*5
bar:
;mov byte[ds:bx+21*160-2],177;b1
;mov byte[ds:bx+21*160-2+1],14+3*16;=3e
mov word[ds:bx+21*160-2],3eb1h
dec bx
dec bx
jnz bar

mov dx,0f900h ;f9 = 9+15*16
mov ax,-10 ;save a few bytes below
mov bl,11 ;bh = 0  ;save 1b below
mov cl,21 ;ch = 0; save 1b below
mov word[bp+4],ax;x ;start values (center of cube)
cube1:
mov word[bp+6],ax;y
cube2:
mov word[bp+8],ax;z
cube3:

;################################## R O T A T E ##################################

fild word[bp+8] ;z ;load on fpu stack
fild word[bp+6] ;y
fild word[bp+4] ;x

;[on] around y axis | x=cos*x-sin*z | z=sin*x+cos*z | y=y
;[on] around x axis | y=cos*y-sin*z | z=sin*y+cos*z | x=x
;[off] around z axis | x=cos*x-sin*y | y=sin*x-cos*y | z=z

;at his point thanks to lord kelvin for his intro "only a cube" where i
;first saw 2 rotation calls together, so no loop-stuff needed. here it
;rotates around all 3 axis
call rotate  ;y axis in x y z out y' x z'
call rotate  ;x axis in y' x z' out x' y' z''
fxch st2     ;z'' y' x'
call rotate  ;z axis in z'' y' x' out y'' z'' x''

fistp word[bp+12]  ;grab new value y
fistp word[bp+14]   ;grab new value z (color)
fistp word[bp+10]   ;grab new value x
;################################## R O T A T E done #############################

;calculate pos on screen
imul si,word[bp+12],160
shl word[bp+10],1
sub si,word[bp+10] ;add = clockwise, sub = anti clockwise

;mov dx,word[bp+14]  ;get current z (= color)

inc dl ;texture it

mov word[ds:si+23*160+44],dx ;set

inc word[bp+8]
cmp word[bp+8],bx
jne cube3 ;z

inc word[bp+6]
cmp word[bp+6],bx
jne cube2 ;y

inc word[bp+4]
;cmp word[bp+4],bx
;jne cube1 ;x
loop cube1

;draw the text
mov di,49+4 ;length of string
text:
mov ah,15+8*16
cmp di,43 ;check if start of demozoo.org
jb okk    ;not yet
mov ah,15+4*16 ;yes, so colour me beautiful
okk:
mov al,byte[cs:addie+di-1];get letter
mov bx,di;1b smaller than imul bx,di,2
mov word[ds:di+bx+50+26*160],ax
dec di
jnz text ;draw whole string

;mov dx,3dah     ;wait for vsync for constant speed
;vsync1:         ;to slow things down and make the
;in al,dx        ;scroller actually readable ;)
;test al,8
;jnz vsync1
;vsync2:
;in al,dx
;test al,8
;jz vsync2

inc word[bp+2]        ;change degrees

;mov cx,80*50 ;no *2 since stosw does that
;80*64=1400h / word use makes this to 160*64
;di = cx = 0 here
mov ch,14h
flip:
mov ax,0fe00h
xchg ax,word[ds:di]
stosw ;incl add di,2
loop flip

         in al,60h            ;read keyboard buffer
         dec al               ;ESC?
         jnz main             ;no, so go on
breaker: ;ret                 ;safe that byte by using the ret at the end of rotate
                              ;not caring about instructions

rotate:
;                     0              1             2             3             4         5         6         7
;                     x              y             z
fild word[bp+2]      ;g              x             y             z
fidiv word[cs:start+4] ;close enough to 57/2
fsincos              ;cos           sin            x             y             z
fmul st0,st3         ;cos*y         sin            x             y             z
fxch st1             ;sin         cos*y            x             y             z
fmul st0,st4         ;sin*z       cos*y            x             y             z
fsubp st1,st0        ;cos*y-sin*z    x             y             z
                     ; y'            x             y             z
fild word[bp+2]      ;g              y'            x             y             z
fidiv word[cs:start+4]
fsincos              ;cos           sin            y'            x             y         z
fmulp st5,st0        ;sin            y'            x             y           cos*z
fmulp st3,st0        ;y'             x           sin*y         cos*z
fxch st2             ;sin*y          x             y'          cos*z
faddp st3,st0        ;x              y'         sin*y+cos*z
                     ;x              y'            z'
fxch st1             ;y'             x             z'
ret

;                     1         2         3         4         5         6         7         8
;            12345678901234567890123456789012345678901234567890123456789012345678901234567890
addie db 32,254,32,254,254,'where information meets preservation.demozoo.org'

;for_rad dw 57/2    ;pi*grad/180 = grad/57 (180/3.14... = 57,...)
                   ;byte + additional byte at doubleword below works fine