%define DOSBOX ; cycles=280000  mpu401=uart
%define SOUND

org 100h                       
start:
texseg equ $				;gs=349f; texture segment; f668: rand seed
	push    0A000h - 70		;68 F6 9F 	screen: center x to 160, y is still 0 on top
_13471 equ $-1	
_4916 equ $
	xor     al,13h			;34 13
_19 equ $-1
	add		dh,al			;dx=cs+0x1300 for fs below
_4301 equ $	
	int     10h				;CD 10
	pop     es              ;07			es=A000-10: screen  segment
	lgs		cx,[si]			;gs=349f; texture segment; cx=f668: rand seed	
	mov		fs,dx			;fs=cs+0x1300
	
;--------------------------------------------------------------------		
; palette
;--------------------------------------------------------------------
	salc
palette:						
	mov 	dx,0x3c9		;BA C9 03			
	out 	dx,al			;EE			
	ror		ax,1			;D1 C8
	out 	dx,al			;EE
	rol		ax,1			;D1 C0				
	out 	dx,al			;EE		
	;rol		ax,1		;D1 C0				
	inc		al				;FE C0
	jnz		palette
palette_done:

;--------------------------------------------------------------------		
; brown noise texture, (by baze and rrrola)
;--------------------------------------------------------------------
	push	ds				;1E		
	lds		ax,[si]			;ds=349f; texture segment; ax=f668: rand seed				
texloop:					;			ch = left texel
	adc		cx,bp			;			ch += random (-16..16)
	adc		ch,al			;			ch += top right texel, or last pixel (on frame start)
	shr		cx,1        	;			average ch to 0..127; cl,carry = old texel bits
	mov		byte[si+126],ch	;			store texel = (left + top right + random + adc) / 2	
	rcr		bp,cl       	;			next random value
	sar		bp,2	      	;			adjust, mess up the top bits
	lodsb           		;			load top right texel, advance si (= time)
	dec		bx          	;			loop 256 times (65536 on init), si += 256
	loopnz	texloop    		;			cx-- for more randomness
	pop		ds
	
;--------------------------------------------------------------------
; intro mainloop		
;--------------------------------------------------------------------
mainloop:		
	mov 	ax,0xcccd		; rrrola's trick ...
	mul		di				; ... to approximate centered coords from DI -> DL=X, DH=Y
	sub 	dh,[si]			; align vertically (subtract 104 from Y)
	pusha					; x = word [bx-9], y = word [bx-8], 0 ~= center screen		

; blur background (which for us is the framebuffer 0xA000 @ ES)
	mov		bp,cx				;offset in bp == time, when ch | 1
	test	ch,0x0f
	jp		nooffset
	
	; x-offset from texture
	mov		bp,word[gs:di+bp] 	; read from texture
	sar		bp,13	
	; y-offset from texture	
	mov		ax,word[gs:di]		; read from texture
	sar		ax,13
	imul	word[si+_m320-start]
	sub		bp,ax				;x-offs + y-offs
nooffset:
	
	; gaussian 3x3 via 4 2x2 blocks
	xor		cx,cx			; PF -> true
	mov		al,0b00001111
gaussian3x3loop:	
	jnp		sameline		; PF initially true 
_mp4 equ $-1	
		add	di,318			; one line down
sameline:		
	mov		dx,word[fs:di+bp-320]
_m320 equ $-2	
	add		dx,word[fs:di+bp]	
	add		dh,dl
	shr		dx,10
	add		cx,dx
	inc		di
	shr		al,1
	jnz		gaussian3x3loop
	shr		cx,2			; gaussian sum in cx

	; CL = previous blurred pixel
	mov		ax,[bx-6]
test	al,0x80	
; -- flexible 2D sdf
	fild	word[bx-9]			;x
	fild	word[bx-8]			;y		x	
; rotation	
	fild	word[bx-6]			;t		y		x
	fidiv	word[si+_19-start]
	fst		dword[bx]
jz 		norotchange
	fchs
norotchange:
	fsincos						;c		s		y		x
	fld 	st2					;y		c		s		y		x
	fmul 	st0,st1				;cy		c		s		y		x
	fld 	st4					;x		cy		c		s		y		x
	fmul 	st0,st3				;sx		cy		c		s		y		x
	fsubp 	st1,st0				;cy-sx	c		s		y		x
jz		noheart
	fabs						;y'		c		s		y		x
noheart:
	fstp	st5					;c		s		y		x		y'
	fmulp 	st3,st0				;s		y		cx		y'
	fmulp 	st1,st0				;sy		cx		y'
	faddp 	st1,st0				;x'		y'
	fabs						;x'
	
	fild	word[si+_13471-start];w		x'		y'
	
; cross	part start
test	al,0x20
jz		nocross
	fld		st2					;y'		w		x'		y'		
	fadd	st2					;x+y	w		x'		y'	
%ifdef DOSBOX
	fcom 	st1
	fnstsw 	ax
	sahf
	jnbe	_min1
_min0:
	fxch 	st1
_min1:
	fstp 	st0	
%else
	fucomi	st0,st1
	fcmovnbe st0,st1
	fstp	st1
%endif
	fld		dword[bx]
	fcos
	fmulp	st1,st0
;test	byte[bx-6],0x40
;jz		nocross
	;fmul	dword[si+_mp4-start]
; cross	part end
nocross:		
	
	fsub	st2,st0				;m'		x'		y'-m'
	fsubp	st1,st0				;x'-m	y'-m'	
	fmul	st0,st0				;x²		y'-m'
	fxch	st1,st0				;y'-m'	x²
	fmul	st0,st0				;y²		x²
	faddp	st1,st0				;x²+y²
	fsqrt						;l	
	fisub	word[si+_4916-start];d
	fidiv	word[bx-16] 		; /256 (si) to bring to proper range
	fistp	dword[bx]			;-
	cmp		word[bx],bx	
	jg		color_done
	mov		cx,[bx]				; take sdf distance as interior color	
	ror		cl,5
color_done:
	xchg	ax,cx
	stosb						; output pixel	
	popa
pixel_done:		
	inc		di
mainloop_indirect:	
	jnz		mainloop	
	
	; flip backbuffer/display
	push	es
	push	fs
	pop		es
	pop		fs

%ifdef SOUND	
	
	; chord progression
	mov 	dx,0x330			;MIDI Control Port (331h)
	mov 	al,0x9a
	out 	dx,al				;send: note on (channel 0)		
	xor		al,0x72
	mul		cl		
	add		al,ch
	out 	dx,al				;send: key			
	out 	dx,al				;send: velocity	
%endif
	
	inc		cx					; next frame
	
%ifdef CHECK_ESC	
	in      al,60h          
	dec     al
	jnz 	mainloop_indirect
	int		20h
%else
	jmp		mainloop_indirect
%endif